/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf;

import java.io.File;
import java.io.IOException;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;
import blanco.jsf.task.valueobject.BlancoJsfProcessInput;
import blanco.jsf.valueobject.BlancoJsfStructure;
import blanco.valueobject.BlancoValueObjectXml2JavaClass;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

/**
 * (blancoJsf)̂߂̃vLVENXB
 */
class BlancoJsfExpandDownloadInfo {
    private BlancoJsfProcessInput fInput = null;

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argProcessStructureList
     *            ^t@CWł\f[^B
     * @param argRuntimePackage
     *            ^CpbP[WBnullђ0̏̕ꍇ͒`ƂɃ^CNX𐶐B
     * @param argTargetLang
     *            o͑ΏۃvO~OB
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    public void expandSourceFile(final BlancoJsfStructure structure,
            final List<BlancoJsfStructure> listJsfStructure,
            final BlancoJsfProcessInput input) {
        fInput = input;

        expandSourceFileInternal(structure, listJsfStructure, input);
    }

    public void expandSourceFileInternal(final BlancoJsfStructure structure,
            final List<BlancoJsfStructure> listJsfStructure,
            final BlancoJsfProcessInput input) {

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlanco = new File(new File(input.getTargetdirjee())
                .getAbsolutePath());

        String runtimePackage = structure.getPackage();
        if (BlancoStringUtil.null2Blank(fInput.getRuntimepackage()).length() > 0) {
            runtimePackage = fInput.getRuntimepackage();
        }

        final BlancoValueObjectClassStructure classStructure = new BlancoValueObjectClassStructure();
        classStructure.setName("BlancoJsfDownloadInfo");
        classStructure.setDescription("_E[hNXB");
        classStructure.setPackage(runtimePackage);

        {
            final BlancoValueObjectFieldStructure field = new BlancoValueObjectFieldStructure();
            classStructure.getFieldList().add(field);
            field.setName("ContentType");
            field.setType("java.lang.String");
            field.setDefault("application/octet-stream");
        }

        {
            final BlancoValueObjectFieldStructure field = new BlancoValueObjectFieldStructure();
            classStructure.getFieldList().add(field);
            field.setName("filename");
            field.setType("java.lang.String");
        }

        {
            final BlancoValueObjectFieldStructure field = new BlancoValueObjectFieldStructure();
            classStructure.getFieldList().add(field);
            field.setName("attachment");
            field.setType("boolean");
            field.setDefault("false");
        }

        try {
            BlancoValueObjectXml2JavaClass xml2JavaClass = new BlancoValueObjectXml2JavaClass();
            xml2JavaClass.setEncoding(input.getEncoding());
            xml2JavaClass.structure2Source(classStructure, fileBlanco);
        } catch (IOException e) {
            throw new IllegalArgumentException("\[XR[ho͎ɗOB", e);
        }
    }
}
