/*
 * ̃\[XR[h blanco Frameworkɂ莩܂B
 */
package blanco.sample.pdf.report;

import java.io.OutputStream;

import blanco.pdf.page.BlancoPdfPageUtil;
import blanco.pdf.page.BlancoPdfPageWriter;
import blanco.pdf.page.valueobject.BlancoPdfPageDef;
import blanco.pdf.valueobject.BlancoPdfMetrix;
import blanco.pdf.valueobject.BlancoPdfSetting;
import blanco.sample.pdf.report.items.Yoko01PdfReportItems;

import com.lowagie.text.pdf.PdfWriter;

/**
 * PDF |[gB
 */
public class Yoko01PdfReport {
    /**
     * y[W`IuWFNgB
     */
    private BlancoPdfPageDef fPageDef;

    /**
     * y[WEC^[EIuWFNgB
     */
    private BlancoPdfPageWriter fPageWriter;

    /**
     * 1 y[W̃f[^Zbg܂B
     *
     * @param pdfSetting PDF ڌQB
     * @param outStream o̓Xg[B
     */
    public Yoko01PdfReport(final BlancoPdfSetting pdfSetting, final OutputStream outStream) {
        fPageDef = BlancoPdfPageUtil.read(pdfSetting, "yoko01");
        fPageWriter = new BlancoPdfPageWriter(pdfSetting.getConfPath(), fPageDef, outStream);
    }

    /**
     * 1 y[W̃f[^Zbg܂B
     *
     * @param pdfItems PDF ڌQB
     */
    public void writeItems(final Yoko01PdfReportItems pdfItems) {
        final BlancoPdfMetrix metrix = new BlancoPdfMetrix();
        metrix.setFont("mincho");
        metrix.setFontSize(12);
        fPageWriter.drawText(144.0f, 144.0f, pdfItems.getField00(), metrix);
        metrix.setFont("mincho");
        metrix.setFontSize(12);
        fPageWriter.drawText(72.0f, 72.0f, pdfItems.getField01(), metrix);
        metrix.setFont("mincho");
        metrix.setFontSize(24);
        fPageWriter.drawText(144.0f, 72.0f, pdfItems.getField02(), metrix);
        metrix.setFont("mincho");
        metrix.setFontSize(24);
        fPageWriter.drawText(144.0f, 72.0f, pdfItems.getField03(), metrix);
    }

    /**
     * y[W܂B
     */
    public void nextPage() {
        fPageWriter.nextPage();
    }

    /**
     * ObhEV[g`悵܂B
     */
    public void drawGridSheet() {
        fPageWriter.drawGridSheet();
    }

    /**
     * N[Y܂B
     */
    public void close() {
        fPageWriter.close();
    }

    /**
     * PDF C^[擾܂B
     *
     * @return IɗpĂ郉C^[[B
     */
    @Deprecated
    public PdfWriter getPdfWriter() {
        return fPageWriter.getWriter();
    }
}
