/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xliff;

import java.io.File;
import java.io.IOException;

import junit.framework.TestCase;
import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffAltTrans;
import blanco.xliff.valueobject.BlancoXliffBody;
import blanco.xliff.valueobject.BlancoXliffContext;
import blanco.xliff.valueobject.BlancoXliffContextGroup;
import blanco.xliff.valueobject.BlancoXliffFile;
import blanco.xliff.valueobject.BlancoXliffHeader;
import blanco.xliff.valueobject.BlancoXliffNote;
import blanco.xliff.valueobject.BlancoXliffTarget;
import blanco.xliff.valueobject.BlancoXliffTool;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

/**
 * XLIFF𑀍삷邽߂̃[eBeB[B
 * 
 * @author IGA Tosiki
 */
public class BlancoXliffTest extends TestCase {
    /**
     * XLIFF`̃t@Cp[X܂B
     * 
     * 
     * @param args
     */
    public void testParse() throws Exception {
        new File("./tmp").mkdirs();
        System.out.println(new BlancoXliffParser().parse(new File(
                "./tmp/conf/xliff/org.dummy.test.xlf")));
    }

    /**
     * XLIFF`ւ̃VACYs܂B
     * 
     * @param args
     * @throws IOException
     */
    public void testSerializer() throws Exception {
        final File confDir = new File("tmp/conf/xliff");
        confDir.mkdirs();
        final BlancoXliff xliff = BlancoXliffUtil.getXliffInstance(confDir,
                "org.dummy.test");

        final BlancoXliffFile fileAdd = new BlancoXliffFile();
        xliff.getFileList().add(fileAdd);
        fileAdd.setSourceLanguage("en-US");
        fileAdd.setTargetLanguage("ja-JP");

        for (int fileIndex = 0; fileIndex < xliff.getFileList().size(); fileIndex++) {
            final BlancoXliffFile file = (BlancoXliffFile) xliff.getFileList()
                    .get(fileIndex);

            final BlancoXliffHeader header = file.getHeader();
            final BlancoXliffBody body = file.getBody();

            {
                final BlancoXliffTool tool = new BlancoXliffTool();
                tool.setToolId("pleiades");
                tool.setToolName("MergeDoc - Pleiades");
                BlancoXliffUtil.setTool(header, tool);
            }

            for (int index = 0; index < 10; index++) {
                final BlancoXliffTransUnit unit = new BlancoXliffTransUnit();

                body.getTransUnitList().add(unit);
                unit.setId("a" + index);
                unit.setSource("ugeuge" + index);

                final BlancoXliffTarget target = new BlancoXliffTarget();
                unit.setTarget(target);
                target.setTarget("" + index);

                {
                    final BlancoXliffNote note = new BlancoXliffNote();
                    unit.getNoteList().add(note);
                    note.setFrom("S");
                    note.setText("B");
                }

                switch (index) {
                case 0:
                    unit.getTarget().setState("final");
                    unit.setApproved(true);
                    break;
                case 1:
                    unit.getTarget().setState("needs-review-adaptation");
                    break;
                case 2:
                    unit.getTarget().setState("needs-review-translation");
                    unit.getTarget().setStateQualifier("id-match");
                    break;
                case 3:
                    unit.setTranslate(false);
                    break;
                }

                {
                    final BlancoXliffContextGroup contextGroup = new BlancoXliffContextGroup();
                    unit.getContextGroupList().add(contextGroup);
                    contextGroup.setCrc("1");
                    contextGroup.setName("omit.tm");
                    contextGroup.setPurpose("x-tm");

                    final BlancoXliffContext context = new BlancoXliffContext();
                    contextGroup.getContextList().add(context);
                    context.setContextType("x-omit");
                }

                {
                    final BlancoXliffAltTrans altTrans = new BlancoXliffAltTrans();
                    altTrans.setToolId("pleiades");
                    altTrans.setSource("alt");
                    final BlancoXliffTarget altTransTarget = new BlancoXliffTarget();
                    altTransTarget.setTarget("");
                    altTrans.setTarget(altTransTarget);
                    unit.getAltTransList().add(altTrans);

                    {
                        final BlancoXliffNote note = new BlancoXliffNote();
                        altTrans.getNoteList().add(note);
                        note.setText("B");
                    }
                }
                {
                    final BlancoXliffAltTrans altTrans = new BlancoXliffAltTrans();
                    altTrans.setToolId("eclipse3.2.1");
                    altTrans.setSource("alt");
                    final BlancoXliffTarget altTransTarget = new BlancoXliffTarget();
                    altTransTarget.setTarget("");
                    altTrans.setTarget(altTransTarget);
                    unit.getAltTransList().add(altTrans);
                }
            }

            BlancoXliffUtil.saveXliffInstance(xliff, confDir, "org.dummy.test");

            {
                // xǂݏB
                final BlancoXliff xliff2 = BlancoXliffUtil.getXliffInstance(
                        confDir, "org.dummy.test");
                BlancoXliffUtil.saveXliffInstance(xliff2, confDir,
                        "org.dummy.test2");
            }
        }

    }
}
