/*
 * blancoCommons Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.commons.util;

import junit.framework.TestCase;

/**
 * OɊւ郆[eBeB̃eXgP[Xł
 * 
 * @author iga
 */
public class BlancoNameUtilTest extends TestCase {
    public void testTrimFileExtention() throws Exception {
        assertEquals("abc", BlancoNameUtil.trimFileExtension("abc.txt"));
        assertEquals("abc.def", BlancoNameUtil.trimFileExtension("abc.def.txt"));
        assertEquals(".cvsignore", BlancoNameUtil
                .trimFileExtension(".cvsignore"));
        assertEquals(".cvsignore", BlancoNameUtil
                .trimFileExtension(".cvsignore.txt"));
        assertEquals(".", BlancoNameUtil.trimFileExtension(".."));
        assertEquals("aaa", BlancoNameUtil.trimFileExtension("aaa."));
        assertEquals("aaa.", BlancoNameUtil.trimFileExtension("aaa.."));
    }

    public void testSplitPath() throws Exception {
        // ʓIȒl̎
        assertEqualsStringArray(new String[] { "aaa" }, BlancoNameUtil
                .splitPath("aaa"));
        assertEqualsStringArray(new String[] { "aaa", "bbb", "ccc" },
                BlancoNameUtil.splitPath("aaa/bbb/ccc"));
        assertEqualsStringArray(new String[] { "aaa" }, BlancoNameUtil
                .splitPath("aaa"));

        // ⋫ElIȎ
        assertEqualsStringArray(new String[] { "aaa", "", "ccc" },
                BlancoNameUtil.splitPath("aaa//ccc"));
        // |CgF[g̓[gƂăJEgAbv܂B
        assertEqualsStringArray(new String[] { "", "aaa", "bbb" },
                BlancoNameUtil.splitPath("/aaa/bbb"));
        // |CgFŌ̃obNXbV͖܂B
        assertEqualsStringArray(new String[] { "", "aaa", "bbb" },
                BlancoNameUtil.splitPath("/aaa/bbb/"));

        // ͓ȃP[X
        assertEqualsStringArray(new String[] { "", "", "" }, BlancoNameUtil
                .splitPath("///"));
        assertEqualsStringArray(new String[] { "", "" }, BlancoNameUtil
                .splitPath("//"));
        assertEqualsStringArray(new String[] { "" }, BlancoNameUtil
                .splitPath("/"));

        // ͋E̎
        // |CgF"" ͖̂Ƃď܂B
        assertEqualsStringArray(new String[0], BlancoNameUtil.splitPath(""));
        // |CgFnull ̂Ƃď܂B
        assertEqualsStringArray(new String[0], BlancoNameUtil.splitPath(null));
    }

    /**
     * URIpbP[Wɕό`̂܂B
     * 
     * @throws Exception
     */
    public void testUri2JavaPackage() throws Exception {
        assertEquals("ccc.bbb.aaa.ddd.eee", BlancoNameUtil
                .uri2JavaPackage("http://aaa.bbb.ccc/ddd/eee"));
        assertEquals("ccc.bbb.aaa.ddd.eee", BlancoNameUtil
                .uri2JavaPackage("https://aaa.bbb.ccc/ddd/eee"));
        assertEquals("ccc.bbb.aaa.ddd.eee", BlancoNameUtil
                .uri2JavaPackage("https://aaa.bbb.ccc:8080/ddd/eee"));
        assertEquals("ccc.bbb.aaa.ddd.eee", BlancoNameUtil
                .uri2JavaPackage("ftp://aaa.bbb.ccc:43/ddd/eee"));
        assertEquals("aaa", BlancoNameUtil.uri2JavaPackage("http://aaa"));
        assertEquals("aaa.bbb", BlancoNameUtil
                .uri2JavaPackage("http://aaa/bbb"));
        assertEquals("aaa.bbb.ccc", BlancoNameUtil
                .uri2JavaPackage("http://aaa/bbb/ccc"));
        assertEquals("org.aaa", BlancoNameUtil
                .uri2JavaPackage("http://aaa.org"));
        assertEquals("org.aaa", BlancoNameUtil
                .uri2JavaPackage("http://aaa.org/"));
        try {
            BlancoNameUtil.uri2JavaPackage("abc.def");
            fail("OׂƂŁAO܂łB");
        } catch (IllegalArgumentException e) {
        }
    }

    private void assertEqualsStringArray(String[] wish, String[] target)
            throws Exception {
        assertEquals(wish.length, target.length);
        for (int index = 0; index < wish.length; index++) {
            assertEquals(wish[index], target[index]);
        }
    }
}
