package blanco.html.normalizer.parser.helper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

import junit.framework.TestCase;
import blanco.commons.util.BlancoFileUtil;
import blanco.html.normalizer.parser.BlancoHtmlEventListSerializer;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEvent;
import blanco.html.normalizer.util.BlancoHtmlNormalizerUtil;
import blanco.html.parser.BlancoHtmlParser;
import blanco.html.parser.BlancoHtmlParserFactory;

public class BlancoHtmlEventParserContentHandlerTest extends TestCase {
    public void test001() throws Exception {
        final BlancoHtmlEventParserContentHandler handler = new BlancoHtmlEventParserContentHandler();

        new File("tmp").mkdirs();

        // ̓f[^B
        final byte[] inputData = BlancoFileUtil.file2Bytes(new File(
                "../blancoHtmlParser/test/data/test001.html"));

        // HTML̃GR[fBO擾B
        final BlancoHtmlParser encodingParser = BlancoHtmlParserFactory
                .getInstance();
        encodingParser.parse(inputData);

        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();
        parser.setHandler(handler);

        parser.parse(inputData);

        List<BlancoHtmlEvent> eventList = handler.getEventList();
        eventList = BlancoHtmlNormalizerUtil.adjust(eventList);

        new File("./tmp").mkdirs();
        new BlancoHtmlEventListSerializer().serialize(eventList,
                new BufferedWriter(new OutputStreamWriter(new FileOutputStream(
                        "./tmp/aaa.html"), encodingParser.getEncoding())));
    }
}
