/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.cs;

import blanco.cg.valueobject.BlancoCgType;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgType\[XR[hɓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgTypeCsSourceExpander {
    /**
     * vO~O̗\ꗗB
     */
    private static final String[] LANGUAGE_RESERVED_KEYWORD = { "void", "byte",
            "short", "int", "long", "char", "float", "double", "decimal",
            "bool", "string" };

    /**
     * blancoCg^A̓Iȕւƕϊ܂B
     * 
     * z\[]WFlNXWJ܂B<br>
     * TODO pbP[WԂł̓NX(:java.util.Datejava.sql.DateȂ)͍lĂ܂B
     * pbP[W̓NX̃\[Xt@Cŗpׂ̏@\͖񋟂łB
     * 
     * @param argType
     *            blancoCǧ^B
     * @return vO~Oɂ^B
     */
    public static String toTypeString(final BlancoCgType argType) {
        final StringBuffer buf = new StringBuffer();
        buf.append(BlancoNameUtil.trimJavaPackage(argType.getName()));

        // zWJ܂B
        if (argType.getArray()) {
            buf.append("[");
            for (int dimension = 1; dimension < argType.getArrayDimension(); dimension++) {
                buf.append(",");
            }
            buf.append("]");
        }

        // WFlNXWJ܂B
        if (BlancoStringUtil.null2Blank(argType.getGenerics()).length() > 0) {
            // TODO C#.NET̃WFlNXēxKv܂B
            buf.append(argType.getGenerics());
        }

        return buf.toString();
    }

    /**
     * ^ꂽ񂪃vO~O̗\ł邩ǂ`FbN܂B
     * 
     * @param argCheck
     *            `FbNB
     * @return vO~O̗\ɊYǂB
     */
    public static boolean isLanguageReservedKeyword(final String argCheck) {
        for (int index = 0; index < LANGUAGE_RESERVED_KEYWORD.length; index++) {
            if (LANGUAGE_RESERVED_KEYWORD[index].equals(argCheck)) {
                // ̓̕vO~O̗\łB
                return true;
            }
        }

        // L[[hɃqbg܂łB̓̕vO~O̗\ł͂܂B
        return false;
    }
}
