/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.commons.calc.parser.block;

import java.util.ArrayList;
import java.util.List;

/**
 * L[}bṽubN܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoCalcParserPropertyBlock extends
        AbstractBlancoCalcParserBlock {

    private List<BlancoCalcParserPropertyKey> list = new ArrayList<BlancoCalcParserPropertyKey>();

    /**
     * vpeBubÑRXgN^B
     * 
     * @param name
     *            ubNB
     */
    public BlancoCalcParserPropertyBlock(String name) {
        setName(name);
    }

    /**
     * vpeBubNɃvpeBL[ǉ܂B
     * 
     * @param item
     *            vpeBL[IuWFNgB
     */
    public void add(BlancoCalcParserPropertyKey item) {
        list.add(item);
    }

    /**
     * JnɗACe܂B
     * 
     * @param startString
     *            JnB
     * @return ꂽvpeBL[IuWFNgB
     */
    public BlancoCalcParserPropertyKey findByStartString(String startString) {
        final int listSize = list.size();
        for (int index = 0; index < listSize; index++) {
            final BlancoCalcParserPropertyKey item = (BlancoCalcParserPropertyKey) list
                    .get(index);
            if (item.isStartString(startString)) {
                return item;
            }
        }
        return null;
    }
}
