/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.File;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

import blanco.commons.util.BlancoXmlUtil;

/**
 * plugin.xmlt@CWJ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoEclipsePluginGenExpandPluginXml {
    private String fPluginName = null;

    private String fPluginDisplayName = null;

    private String fPackageName = null;

    private String fPluginDefFile = null;

    /**
     * plugin.xmlt@CWJ܂B
     * 
     * @param elementCommon
     * @param listList
     * @param directoryRoot
     *            [gfBNgB̃fBNgplugin.xmlt@Co͂܂B
     */
    public final void expand(final Element elementCommon,
            final NodeList listList, final File directoryRoot) {
        fPluginName = BlancoXmlUtil.getTextContent(elementCommon, "name");
        fPluginDisplayName = BlancoXmlUtil.getTextContent(elementCommon,
                "displayName");
        fPackageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        fPluginDefFile = BlancoXmlUtil.getTextContent(elementCommon,
                "pluginDefFile");

        final Document document = BlancoXmlUtil.newDocument();

        // Eclipse 3.2ȏOƂ܂B
        final ProcessingInstruction processingInstruction = document
                .createProcessingInstruction("eclipse", "version=\"3.2\"");
        document.appendChild(processingInstruction);

        document.appendChild(document
                .createComment("This file is generated by blanco Framework."));

        final Element elePlugin = document.createElement("plugin");
        document.appendChild(elePlugin);
        elePlugin.appendChild(document.createTextNode("\n  "));

        expandEditor(document, elePlugin);
        elePlugin.appendChild(document.createTextNode("\n  "));

        expandWizard(document, elePlugin);
        elePlugin.appendChild(document.createTextNode("\n"));

        final File fileTarget = new File(directoryRoot.getAbsolutePath()
                + "/plugin.xml");
        if (fileTarget.exists()) {
            System.out.println("ep: skip  : plugin.xml: file already exist.");
        } else {
            System.out.println("ep: create: plugin.xml");
            BlancoXmlUtil.transformDom2File(document, fileTarget);
        }
    }

    /**
     * GfB^WJ܂B
     * 
     * @param document
     * @param elePlugin
     */
    private void expandEditor(final Document document, final Element elePlugin) {
        final Element eleExtension = document.createElement("extension");
        elePlugin.appendChild(eleExtension);

        // NX̊mB
        final String className = fPackageName + ".editors." + fPluginName;

        // g|Cg̎wB
        eleExtension.setAttribute("point", "org.eclipse.ui.editors");
        eleExtension.appendChild(document.createTextNode("\n    "));

        final Element eleEditor = document.createElement("editor");
        eleExtension.appendChild(eleEditor);

        eleEditor.setAttribute("name", fPluginName + " Editor");

        // ҏWΏۂ̃t@C̎włB
        final StringBuffer strbufNames = new StringBuffer(fPluginDefFile
                + ".blancofw");
        for (int indexFilenames = 0; indexFilenames <= 9; indexFilenames++) {
            strbufNames.append("," + fPluginDefFile + indexFilenames
                    + ".blancofw");
        }
        eleEditor.setAttribute("filenames", strbufNames.toString());

        // ACRBACR͌ŒłB
        eleEditor.setAttribute("icon", "icons/blanco.gif");

        // NXw肵܂B
        eleEditor.setAttribute("class", className + "Editor");

        // EDITORIDw肵܂B
        eleEditor.setAttribute("id", fPackageName + ".editors");

        eleEditor.appendChild(document.createTextNode("\n    "));

        eleExtension.appendChild(document.createTextNode("\n  "));
    }

    private void expandWizard(final Document document, final Element elePlugin) {
        final Element eleExtension = document.createElement("extension");
        elePlugin.appendChild(eleExtension);

        // NX̊mB
        final String className = fPackageName + ".wizards." + fPluginName;

        // g|Cg̎wB
        eleExtension.setAttribute("point", "org.eclipse.ui.newWizards");
        eleExtension.appendChild(document.createTextNode("\n    "));

        final Element eleCategory = document.createElement("category");
        eleExtension.appendChild(eleCategory);
        eleCategory.setAttribute("name", "blanco Framework");
        eleCategory.setAttribute("id", "blanco.plugin.wizards");

        final Element eleWizard = document.createElement("wizard");
        eleExtension.appendChild(document.createTextNode("\n    "));
        eleExtension.appendChild(eleWizard);
        // EBU[h̖Ow肵܂B̖OEclipsẽEBU[hɌ܂B
        eleWizard.setAttribute("name", fPluginDisplayName + " Wizard");

        // ACRBACR͌ŒłB
        eleWizard.setAttribute("icon", "icons/blanco.gif");

        eleWizard.setAttribute("category", "blanco.plugin.wizards");

        // NXw肵܂B
        eleWizard.setAttribute("class", className + "Wizard");

        eleWizard.setAttribute("id", className + "Wizard");

        eleWizard.appendChild(document.createTextNode("\n    "));

        eleExtension.appendChild(document.createTextNode("\n  "));
    }
}
