/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.nlpack.generator.task;

import java.io.IOException;

import blanco.nlpack.generator.task.valueobject.BlancoNLpackGeneratorConvertProperties2XliffProcessInput;

/**
 * ob`NX [BlancoNLpackGeneratorConvertProperties2XliffBatchProcess]B
 *
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.nlpack.generator.task.BlancoNLpackGeneratorConvertProperties2XliffBatchProcess -help
 * </code>
 */
public class BlancoNLpackGeneratorConvertProperties2XliffBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoNLpackGeneratorConvertProperties2XliffBatchProcess batchProcess = new BlancoNLpackGeneratorConvertProperties2XliffBatchProcess();

        // ob`̈B
        final BlancoNLpackGeneratorConvertProperties2XliffProcessInput input = new BlancoNLpackGeneratorConvertProperties2XliffProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldSourcedirProcessed = false;
        boolean isFieldXliffdirProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-sourcedir=")) {
                input.setSourcedir(arg.substring(11));
                isFieldSourcedirProcessed = true;
            } else if (arg.startsWith("-xliffdir=")) {
                input.setXliffdir(arg.substring(10));
                isFieldXliffdirProcessed = true;
            } else if (arg.startsWith("-tmpdir=")) {
                input.setTmpdir(arg.substring(8));
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoNLpackGeneratorConvertProperties2XliffBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldSourcedirProcessed == false) {
            System.out.println("BlancoNLpackGeneratorConvertProperties2XliffBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcedir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldXliffdirProcessed == false) {
            System.out.println("BlancoNLpackGeneratorConvertProperties2XliffBatchProcess: JnsB̓p[^[input]̕K{tB[hl[xliffdir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoNLpackGeneratorConvertProperties2XliffProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoNLpackGeneratorConvertProperties2XliffProcessC^tF[X blanco.nlpack.generator.taskpbP[W BlancoNLpackGeneratorConvertProperties2XliffProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoNLpackGeneratorConvertProperties2XliffProcess process = new BlancoNLpackGeneratorConvertProperties2XliffProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoNLpackGeneratorConvertProperties2XliffProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoNLpackGeneratorConvertProperties2XliffBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoNLpackGeneratorConvertProperties2XliffBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoNLpackGeneratorConvertProperties2XliffBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoNLpackGeneratorConvertProperties2XliffBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoNLpackGeneratorConvertProperties2XliffBatchProcess: Usage:");
        System.out.println("  java blanco.nlpack.generator.task.BlancoNLpackGeneratorConvertProperties2XliffBatchProcess -verbose=l1 -sourcedir=l2 -xliffdir=l3 -tmpdir=l4");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -sourcedir");
        System.out.println("      [\[XfBNgB*.jart@CWJEclipsevOCB]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -xliffdir");
        System.out.println("      [XLIFFt@Ci[Ăo͐惋[gEtH_w肵܂BXLIFFt@C Bundle-SymbolicName fBNgɊi[邱ƂOƂ܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -tmpdir");
        System.out.println("      [e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[tmp]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoNLpackGeneratorConvertProperties2XliffProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getSourcedir() == null) {
            throw new IllegalArgumentException("BlancoNLpackGeneratorConvertProperties2XliffBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcedir]ɒlݒ肳Ă܂B");
        }
        if (input.getXliffdir() == null) {
            throw new IllegalArgumentException("BlancoNLpackGeneratorConvertProperties2XliffBatchProcess: JnsB̓p[^[input]̕K{tB[hl[xliffdir]ɒlݒ肳Ă܂B");
        }
    }
}
