package blanco.findbugs.util.task;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import blanco.findbugs.util.BlancoFindbugsMessageParser;
import blanco.findbugs.util.task.valueobject.BlancoFindbugsUtilTranslateMessageProcessInput;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessage;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessageBugCategory;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessageBugCode;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessageBugPattern;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessageDetector;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessagePlugin;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlMarshaller;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlCdata;
import blanco.xml.bind.valueobject.BlancoXmlCharacters;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

public class BlancoFindbugsUtilTranslateMessageProcessImpl implements
        BlancoFindbugsUtilTranslateMessageProcess {
    protected BlancoFindbugsUtilTranslateMessageProcessInput fInput = null;

    protected BlancoXmlDocument fDocument = null;

    public int execute(
            final BlancoFindbugsUtilTranslateMessageProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        final File fileEn = new File(fInput.getSourcedir() + "/messages.xml");
        final BlancoFindbugsMessage messageEn = new BlancoFindbugsMessageParser()
                .parse(fileEn);
        final File fileJa = new File(fInput.getSourcedir() + "/messages_ja.xml");
        final BlancoFindbugsMessage messageJa = new BlancoFindbugsMessageParser()
                .parse(fileJa);

        fDocument = new BlancoXmlUnmarshaller().unmarshal(fileEn);

        final BlancoXmlElement eleRoot = (BlancoXmlElement) fDocument
                .getChildNodes().get(0);
        if ("MessageCollection".equals(eleRoot.getLocalName()) == false) {
            throw new IllegalArgumentException("s messages.xml^܂B("
                    + eleRoot.getLocalName() + ")");
        }

        processPlugin(eleRoot, messageEn, messageJa);
        processBugCategory(eleRoot, messageEn, messageJa);
        processDetector(eleRoot, messageEn, messageJa);
        processBugPattern(eleRoot, messageEn, messageJa);
        processBugCode(eleRoot, messageEn, messageJa);

        new BlancoXmlMarshaller().marshal(fDocument, new File(fInput
                .getTargetfile()));

        return 0;
    }

    private void processPlugin(final BlancoXmlElement eleRoot,
            final BlancoFindbugsMessage messageEn,
            final BlancoFindbugsMessage messageJa) {
        final BlancoFindbugsMessagePlugin localizedValue = messageJa
                .getPlugin();
        final BlancoXmlElement eleBase = BlancoXmlBindingUtil.getElement(
                eleRoot, "Plugin");
        {
            final BlancoXmlElement eleLook = BlancoXmlBindingUtil.getElement(
                    eleBase, "ShortDescription");
            setElementText(eleLook, localizedValue.getShortDescription());
        }

        {
            final BlancoXmlElement eleLook = BlancoXmlBindingUtil.getElement(
                    eleBase, "Details");
            setElementTextWithCdata(eleLook, localizedValue.getDetails());
        }
    }

    private void processBugCategory(final BlancoXmlElement eleRoot,
            final BlancoFindbugsMessage messageEn,
            final BlancoFindbugsMessage messageJa) {
        final Map<String, BlancoFindbugsMessageBugCategory> map = new HashMap<String, BlancoFindbugsMessageBugCategory>();
        for (int index = 0; index < messageJa.getBugCategoryList().size(); index++) {
            final BlancoFindbugsMessageBugCategory look = (BlancoFindbugsMessageBugCategory) messageJa
                    .getBugCategoryList().get(index);
            map.put(look.getCategory(), look);
        }

        final List baseList = BlancoXmlBindingUtil.getElementsByTagName(
                eleRoot, "BugCategory");
        for (int index = 0; index < baseList.size(); index++) {
            final BlancoXmlElement eleBase = (BlancoXmlElement) baseList
                    .get(index);
            final BlancoFindbugsMessageBugCategory localizedValue = map
                    .get(BlancoXmlBindingUtil.getAttribute(eleBase, "category"));
            if (localizedValue == null) {
                continue;
            }

            {
                final BlancoXmlElement eleLook = BlancoXmlBindingUtil
                        .getElement(eleBase, "Description");
                setElementText(eleLook, localizedValue.getDescription());
            }

            {
                final BlancoXmlElement eleLook = BlancoXmlBindingUtil
                        .getElement(eleBase, "Details");
                setElementText(eleLook, localizedValue.getDetails());
            }
        }
    }

    private void processDetector(final BlancoXmlElement eleRoot,
            final BlancoFindbugsMessage messageEn,
            final BlancoFindbugsMessage messageJa) {
        final Map<String, BlancoFindbugsMessageDetector> map = new HashMap<String, BlancoFindbugsMessageDetector>();
        for (int index = 0; index < messageJa.getDetectorList().size(); index++) {
            final BlancoFindbugsMessageDetector look = (BlancoFindbugsMessageDetector) messageJa
                    .getDetectorList().get(index);
            map.put(look.getClassId(), look);
        }

        final List baseList = BlancoXmlBindingUtil.getElementsByTagName(
                eleRoot, "Detector");
        for (int index = 0; index < baseList.size(); index++) {
            final BlancoXmlElement eleBase = (BlancoXmlElement) baseList
                    .get(index);
            final BlancoFindbugsMessageDetector localizedValue = map
                    .get(BlancoXmlBindingUtil.getAttribute(eleBase, "class"));
            if (localizedValue == null) {
                continue;
            }

            {
                final BlancoXmlElement eleLook = BlancoXmlBindingUtil
                        .getElement(eleBase, "Details");
                setElementTextWithCdata(eleLook, localizedValue.getDetails());
            }
        }
    }

    private void processBugPattern(final BlancoXmlElement eleRoot,
            final BlancoFindbugsMessage messageEn,
            final BlancoFindbugsMessage messageJa) {
        final Map<String, BlancoFindbugsMessageBugPattern> map = new HashMap<String, BlancoFindbugsMessageBugPattern>();
        for (int index = 0; index < messageJa.getBugPatternList().size(); index++) {
            final BlancoFindbugsMessageBugPattern look = (BlancoFindbugsMessageBugPattern) messageJa
                    .getBugPatternList().get(index);
            map.put(look.getType(), look);
        }

        final List baseList = BlancoXmlBindingUtil.getElementsByTagName(
                eleRoot, "BugPattern");
        for (int index = 0; index < baseList.size(); index++) {
            final BlancoXmlElement eleBase = (BlancoXmlElement) baseList
                    .get(index);
            final BlancoFindbugsMessageBugPattern localizedValue = map
                    .get(BlancoXmlBindingUtil.getAttribute(eleBase, "type"));
            if (localizedValue == null) {
                continue;
            }

            {
                final BlancoXmlElement eleLook = BlancoXmlBindingUtil
                        .getElement(eleBase, "ShortDescription");
                setElementText(eleLook, localizedValue.getShortDescription());
            }
            {
                final BlancoXmlElement eleLook = BlancoXmlBindingUtil
                        .getElement(eleBase, "LongDescription");
                setElementText(eleLook, localizedValue.getLongDescription());
            }
            {
                final BlancoXmlElement eleLook = BlancoXmlBindingUtil
                        .getElement(eleBase, "Details");
                setElementTextWithCdata(eleLook, localizedValue.getDetails());
            }
        }
    }

    private void processBugCode(final BlancoXmlElement eleRoot,
            final BlancoFindbugsMessage messageEn,
            final BlancoFindbugsMessage messageJa) {
        final Map<String, BlancoFindbugsMessageBugCode> map = new HashMap<String, BlancoFindbugsMessageBugCode>();
        for (int index = 0; index < messageJa.getBugCodeList().size(); index++) {
            final BlancoFindbugsMessageBugCode look = (BlancoFindbugsMessageBugCode) messageJa
                    .getBugCodeList().get(index);
            map.put(look.getAbbrev(), look);
        }

        final List baseList = BlancoXmlBindingUtil.getElementsByTagName(
                eleRoot, "BugCode");
        for (int index = 0; index < baseList.size(); index++) {
            final BlancoXmlElement eleBase = (BlancoXmlElement) baseList
                    .get(index);
            final BlancoFindbugsMessageBugCode localizedValue = map
                    .get(BlancoXmlBindingUtil.getAttribute(eleBase, "abbrev"));
            if (localizedValue == null) {
                continue;
            }

            setElementText(eleBase, localizedValue.getText());
        }
    }

    private void setElementText(final BlancoXmlElement eleTarget,
            final String argText) {
        eleTarget.getChildNodes().clear();
        final BlancoXmlCharacters characters = new BlancoXmlCharacters();
        eleTarget.getChildNodes().add(characters);
        characters.setValue(argText);
    }

    private void setElementTextWithCdata(final BlancoXmlElement eleTarget,
            final String argText) {
        for (int index = 0; index < eleTarget.getChildNodes().size(); index++) {
            if (eleTarget.getChildNodes().get(index) instanceof BlancoXmlCdata) {
                final BlancoXmlCdata cdata = (BlancoXmlCdata) eleTarget
                        .getChildNodes().get(index);
                cdata.getChildNodes().clear();
                final BlancoXmlCharacters characters = new BlancoXmlCharacters();
                cdata.getChildNodes().add(characters);
                characters.setValue(argText);
                break;
            }
        }
    }
}
