/*
 * blanco Framework
 * Copyright (C) 2004-2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.findbugs.util;

import java.io.File;
import java.util.ArrayList;

import blanco.findbugs.util.valueobject.BlancoFindbugsMessage;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessageBugCategory;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessageBugCode;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessageBugPattern;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessageDetector;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlCdata;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

public class BlancoFindbugsMessageParser {
    protected BlancoFindbugsMessage fFindbugsMessage = null;

    public BlancoFindbugsMessage parse(final File fileInput) {
        fFindbugsMessage = new BlancoFindbugsMessage();

        final BlancoXmlDocument document = new BlancoXmlUnmarshaller()
                .unmarshal(fileInput);

        final BlancoXmlElement eleMessageCollection = BlancoXmlBindingUtil
                .getDocumentElement(document);
        if ("MessageCollection".equals(eleMessageCollection.getLocalName()) == false) {
            throw new IllegalArgumentException("s messages.xml^܂B("
                    + eleMessageCollection.getLocalName() + ")");
        }

        final ArrayList list = eleMessageCollection.getChildNodes();
        for (int index = 0; index < list.size(); index++) {
            final Object objNode = list.get(index);
            if (objNode instanceof BlancoXmlElement == false) {
                continue;
            }
            final BlancoXmlElement element = (BlancoXmlElement) objNode;

            if ("Plugin".equals(element.getLocalName())) {
                parsePlugin(element);
            } else if ("BugCategory".equals(element.getLocalName())) {
                parseBugCategory(element);
            } else if ("Detector".equals(element.getLocalName())) {
                parseDetector(element);
            } else if ("BugPattern".equals(element.getLocalName())) {
                parseBugPattern(element);
            } else if ("BugCode".equals(element.getLocalName())) {
                parseBugCode(element);
            } else {
                throw new IllegalArgumentException("m̃Gg["
                        + element.getLocalName() + "]܂܂Ă܂B");
            }
        }

        return fFindbugsMessage;
    }

    private void parsePlugin(final BlancoXmlElement element) {
        fFindbugsMessage.getPlugin().setShortDescription(
                getTextConsiderCdata(element, "ShortDescription"));
        fFindbugsMessage.getPlugin().setDetails(
                getTextConsiderCdata(element, "Details"));
    }

    private void parseBugCategory(final BlancoXmlElement element) {
        final BlancoFindbugsMessageBugCategory bugCategory = new BlancoFindbugsMessageBugCategory();
        fFindbugsMessage.getBugCategoryList().add(bugCategory);
        bugCategory.setCategory(BlancoXmlBindingUtil.getAttribute(element,
                "category"));
        bugCategory
                .setDescription(getTextConsiderCdata(element, "Description"));
        bugCategory.setAbbreviation(getTextConsiderCdata(element,
                "Abbreviation"));
        bugCategory.setDetails(getTextConsiderCdata(element, "Details"));
    }

    private void parseDetector(final BlancoXmlElement element) {
        final BlancoFindbugsMessageDetector detector = new BlancoFindbugsMessageDetector();
        fFindbugsMessage.getDetectorList().add(detector);
        detector
                .setClassId(BlancoXmlBindingUtil.getAttribute(element, "class"));
        detector.setDetails(getTextConsiderCdata(element, "Details"));
    }

    private void parseBugPattern(final BlancoXmlElement element) {
        final BlancoFindbugsMessageBugPattern bugPattern = new BlancoFindbugsMessageBugPattern();
        fFindbugsMessage.getBugPatternList().add(bugPattern);
        bugPattern.setType(BlancoXmlBindingUtil.getAttribute(element, "type"));
        bugPattern.setShortDescription(getTextConsiderCdata(element,
                "ShortDescription"));
        bugPattern.setLongDescription(getTextConsiderCdata(element,
                "LongDescription"));
        bugPattern.setDetails(getTextConsiderCdata(element, "Details"));
    }

    private void parseBugCode(final BlancoXmlElement element) {
        final BlancoFindbugsMessageBugCode bugCode = new BlancoFindbugsMessageBugCode();
        fFindbugsMessage.getBugCodeList().add(bugCode);
        bugCode.setAbbrev(BlancoXmlBindingUtil.getAttribute(element, "abbrev"));
        bugCode.setText(getTextConsiderCdata(element));
    }

    private String getTextConsiderCdata(final BlancoXmlElement element) {
        for (int index = 0; index < element.getChildNodes().size(); index++) {
            if (element.getChildNodes().get(index) instanceof BlancoXmlCdata) {
                return BlancoXmlBindingUtil
                        .getTextContent((BlancoXmlCdata) element
                                .getChildNodes().get(index));
            }
        }
        return BlancoXmlBindingUtil.getTextContent(element);
    }

    private String getTextConsiderCdata(final BlancoXmlElement element,
            final String argLocalName) {
        final BlancoXmlElement eleLook = BlancoXmlBindingUtil.getElement(
                element, argLocalName);
        for (int index = 0; index < eleLook.getChildNodes().size(); index++) {
            if (eleLook.getChildNodes().get(index) instanceof BlancoXmlCdata) {
                return BlancoXmlBindingUtil
                        .getTextContent((BlancoXmlCdata) eleLook
                                .getChildNodes().get(index));
            }
        }

        return BlancoXmlBindingUtil.getTextContent(element, argLocalName);
    }
}
