/*
 * blanco Framework
 * Copyright (C) 2004-2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.findbugs.util.task;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import blanco.commons.util.BlancoStringUtil;
import blanco.findbugs.util.BlancoFindbugsMessageParser;
import blanco.findbugs.util.task.valueobject.BlancoFindbugsUtilMessage2TmxProcessInput;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessage;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessageBugCategory;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessageBugCode;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessageBugPattern;
import blanco.findbugs.util.valueobject.BlancoFindbugsMessageDetector;
import blanco.tmx.BlancoTmxSerializer;
import blanco.tmx.valueobject.BlancoTmx;
import blanco.tmx.valueobject.BlancoTmxTu;
import blanco.tmx.valueobject.BlancoTmxTuv;

public class BlancoFindbugsUtilMessage2TmxProcessImpl implements
        BlancoFindbugsUtilMessage2TmxProcess {
    protected BlancoFindbugsUtilMessage2TmxProcessInput fInput = null;

    protected BlancoTmx fTmx = new BlancoTmx();

    protected Map<String, String> fMapProcessed = new HashMap<String, String>();

    public int execute(final BlancoFindbugsUtilMessage2TmxProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        // sourcedir fBNg݊mFB

        // e̓ǂݍ݁B
        final File fileEn = new File(fInput.getSourcedir() + "/messages.xml");
        final BlancoFindbugsMessage messageEn = new BlancoFindbugsMessageParser()
                .parse(fileEn);
        final File fileJa = new File(fInput.getSourcedir() + "/messages_ja.xml");
        final BlancoFindbugsMessage messageJa = new BlancoFindbugsMessageParser()
                .parse(fileJa);

        processPlugin(messageEn, messageJa);
        processBugCategory(messageEn, messageJa);
        processDetector(messageEn, messageJa);
        processBugPattern(messageEn, messageJa);
        processBugCode(messageEn, messageJa);

        final BlancoTmxSerializer serializer = new BlancoTmxSerializer();
        if (fInput.getIsindentxml() == false) {
            serializer.setIndent(false);
        }
        serializer.serialize(fTmx, new File(fInput.getTargetfile()));
        return 0;
    }

    private void addTu(final String strEn, final String strJa) {
        if (BlancoStringUtil.null2Blank(strEn).trim().length() == 0) {
            // ł܂B
            return;
        }
        if (BlancoStringUtil.null2Blank(strJa).trim().length() == 0) {
            // ł܂B
            return;
        }

        if (fMapProcessed.get(strEn) != null) {
            // ς݂̕B
            if (strJa.equals(fMapProcessed.get(strEn)) == false) {
                System.out.println("p̂ݓŘäقȂP[X");
                System.out.println("- en: " + strEn);
                System.out.println("- ja: " + fMapProcessed.get(strEn));
                System.out.println("- ja: " + strJa);
            }
            return;
        }
        fMapProcessed.put(strEn, strJa);

        final BlancoTmxTu tu = new BlancoTmxTu();
        fTmx.getBody().getTuList().add(tu);
        final BlancoTmxTuv tuvEn = new BlancoTmxTuv();
        tu.getTuvList().add(tuvEn);
        final BlancoTmxTuv tuvJa = new BlancoTmxTuv();
        tu.getTuvList().add(tuvJa);
        tuvEn.setLang("EN-US");
        tuvEn.setSeg(strEn);
        tuvJa.setLang("JA");
        tuvJa.setSeg(strJa);
    }

    private void processPlugin(final BlancoFindbugsMessage messageEn,
            final BlancoFindbugsMessage messageJa) {
        addTu(messageEn.getPlugin().getShortDescription(), messageJa
                .getPlugin().getShortDescription());
        addTu(messageEn.getPlugin().getDetails(), messageJa.getPlugin()
                .getDetails());
    }

    private void processBugCategory(final BlancoFindbugsMessage messageEn,
            final BlancoFindbugsMessage messageJa) {
        final Map<String, BlancoFindbugsMessageBugCategory> map = new HashMap<String, BlancoFindbugsMessageBugCategory>();
        for (int index = 0; index < messageJa.getBugCategoryList().size(); index++) {
            final BlancoFindbugsMessageBugCategory look = (BlancoFindbugsMessageBugCategory) messageJa
                    .getBugCategoryList().get(index);
            map.put(look.getCategory(), look);
        }

        for (int index = 0; index < messageEn.getBugCategoryList().size(); index++) {
            final BlancoFindbugsMessageBugCategory look = (BlancoFindbugsMessageBugCategory) messageEn
                    .getBugCategoryList().get(index);
            if (map.get(look.getCategory()) != null) {
                final BlancoFindbugsMessageBugCategory lookJa = map.get(look
                        .getCategory());
                addTu(look.getDescription(), lookJa.getDescription());
                addTu(look.getDetails(), lookJa.getDetails());
            }
        }
    }

    private void processDetector(final BlancoFindbugsMessage messageEn,
            final BlancoFindbugsMessage messageJa) {
        final Map<String, BlancoFindbugsMessageDetector> map = new HashMap<String, BlancoFindbugsMessageDetector>();
        for (int index = 0; index < messageJa.getDetectorList().size(); index++) {
            final BlancoFindbugsMessageDetector look = (BlancoFindbugsMessageDetector) messageJa
                    .getDetectorList().get(index);
            map.put(look.getClassId(), look);
        }

        for (int index = 0; index < messageEn.getDetectorList().size(); index++) {
            final BlancoFindbugsMessageDetector look = (BlancoFindbugsMessageDetector) messageEn
                    .getDetectorList().get(index);
            if (map.get(look.getClassId()) != null) {
                final BlancoFindbugsMessageDetector lookJa = map.get(look
                        .getClassId());
                addTu(look.getDetails(), lookJa.getDetails());
            }
        }
    }

    private void processBugPattern(final BlancoFindbugsMessage messageEn,
            final BlancoFindbugsMessage messageJa) {
        final Map<String, BlancoFindbugsMessageBugPattern> map = new HashMap<String, BlancoFindbugsMessageBugPattern>();
        for (int index = 0; index < messageJa.getBugPatternList().size(); index++) {
            final BlancoFindbugsMessageBugPattern look = (BlancoFindbugsMessageBugPattern) messageJa
                    .getBugPatternList().get(index);
            map.put(look.getType(), look);
        }

        for (int index = 0; index < messageEn.getBugPatternList().size(); index++) {
            final BlancoFindbugsMessageBugPattern look = (BlancoFindbugsMessageBugPattern) messageEn
                    .getBugPatternList().get(index);
            if (map.get(look.getType()) != null) {
                final BlancoFindbugsMessageBugPattern lookJa = map.get(look
                        .getType());
                addTu(look.getShortDescription(), lookJa.getShortDescription());
                addTu(look.getLongDescription(), lookJa.getLongDescription());
                addTu(look.getDetails(), lookJa.getDetails());
            }
        }
    }

    private void processBugCode(final BlancoFindbugsMessage messageEn,
            final BlancoFindbugsMessage messageJa) {
        final Map<String, BlancoFindbugsMessageBugCode> map = new HashMap<String, BlancoFindbugsMessageBugCode>();
        for (int index = 0; index < messageJa.getBugCodeList().size(); index++) {
            final BlancoFindbugsMessageBugCode look = (BlancoFindbugsMessageBugCode) messageJa
                    .getBugCodeList().get(index);
            map.put(look.getAbbrev(), look);
        }

        for (int index = 0; index < messageEn.getBugCodeList().size(); index++) {
            final BlancoFindbugsMessageBugCode look = (BlancoFindbugsMessageBugCode) messageEn
                    .getBugCodeList().get(index);
            if (map.get(look.getAbbrev()) != null) {
                final BlancoFindbugsMessageBugCode lookJa = map.get(look
                        .getAbbrev());
                addTu(look.getText(), lookJa.getText());
            }
        }
    }
}
