/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.tmx;

import java.io.File;
import java.util.List;

import blanco.tmx.valueobject.BlancoTmx;
import blanco.tmx.valueobject.BlancoTmxTu;
import blanco.tmx.valueobject.BlancoTmxTuv;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

public class BlancoTmxParser {
    /**
     * w肳ꂽt@CTMXǂݍ݂܂B
     * 
     * @param argFileTarget
     * @return
     */
    public BlancoTmx parse(final File argFileTarget) {
        final BlancoXmlDocument document = new BlancoXmlUnmarshaller()
                .unmarshal(argFileTarget);
        return document2ValueObject(document);
    }

    /**
     * blancohLgo[IuWFNgɕϊ܂B
     * 
     * @param argDocument
     * @return
     */
    public BlancoTmx document2ValueObject(final BlancoXmlDocument argDocument) {
        final BlancoXmlElement eleTmx = (BlancoXmlElement) argDocument
                .getChildNodes().get(0);
        if ("tmx".equals(eleTmx.getLocalName()) == false) {
            throw new IllegalArgumentException("sTMX^܂B("
                    + eleTmx.getLocalName() + ")");
        }

        final BlancoTmx tmx = new BlancoTmx();

        tmx.setVersion(BlancoXmlBindingUtil.getAttribute(eleTmx, "version"));

        final BlancoXmlElement eleHeader = BlancoXmlBindingUtil.getElement(
                eleTmx, "header");
        if (eleHeader == null) {
            throw new IllegalArgumentException("sTMX^܂Bheaderꂸ");
        }
        final BlancoXmlElement eleBody = BlancoXmlBindingUtil.getElement(
                eleTmx, "body");
        if (eleBody == null) {
            throw new IllegalArgumentException("sTMX^܂Bbodyꂸ");
        }

        parseHeader(eleHeader, tmx);
        parseBody(eleBody, tmx);

        return tmx;
    }

    private void parseHeader(final BlancoXmlElement eleHeader,
            final BlancoTmx tmx) {
        tmx.getHeader().setCreationtool(
                BlancoXmlBindingUtil.getAttribute(eleHeader, "creationtool"));
        tmx.getHeader().setCreationtoolversion(
                BlancoXmlBindingUtil.getAttribute(eleHeader,
                        "creationtoolversion"));
        tmx.getHeader().setCreationtoolversion(
                BlancoXmlBindingUtil.getAttribute(eleHeader, "segtype"));
        tmx.getHeader().setCreationtoolversion(
                BlancoXmlBindingUtil.getAttribute(eleHeader, "o-tmf"));
        tmx.getHeader().setCreationtoolversion(
                BlancoXmlBindingUtil.getAttribute(eleHeader, "adminlang"));
        tmx.getHeader().setCreationtoolversion(
                BlancoXmlBindingUtil.getAttribute(eleHeader, "srclang"));
        tmx.getHeader().setCreationtoolversion(
                BlancoXmlBindingUtil.getAttribute(eleHeader, "datatype"));
    }

    private void parseBody(final BlancoXmlElement eleBody, final BlancoTmx tmx) {
        final List listTu = BlancoXmlBindingUtil.getElementsByTagName(eleBody,
                "tu");
        for (int indexTu = 0; indexTu < listTu.size(); indexTu++) {
            final BlancoXmlElement eleTu = (BlancoXmlElement) listTu
                    .get(indexTu);
            final BlancoTmxTu tu = new BlancoTmxTu();
            tmx.getBody().getTuList().add(tu);
            tu.setTuid(BlancoXmlBindingUtil.getAttribute(eleTu, "tuid"));

            final List listTuv = BlancoXmlBindingUtil.getElementsByTagName(
                    eleTu, "tuv");
            for (int indexTuv = 0; indexTuv < listTuv.size(); indexTuv++) {
                final BlancoXmlElement eleTuv = (BlancoXmlElement) listTuv
                        .get(indexTuv);
                final BlancoTmxTuv tuv = new BlancoTmxTuv();
                tu.getTuvList().add(tuv);
                tuv.setLang(BlancoXmlBindingUtil.getAttribute(eleTuv,
                        "xml:lang"));
                BlancoXmlElement eleSeg = BlancoXmlBindingUtil.getElement(
                        eleTuv, "seg");
                tuv.setSeg(BlancoXmlBindingUtil.getTextContent(eleSeg));
            }
        }
    }
}
