/*
 * blanco Framework
 * Copyright (C) 2004-2008 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.svnconf;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import blanco.commons.util.BlancoFileUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.svnconf.valueobject.BlancoSvnConfStructure;
import blanco.svnconf.valueobject.BlancoSvnConfUserStructure;

/**
 * uSubversion|Wg`vExcell svn.conft@C𐶐B
 * 
 * ̃NX́AXMLt@Cݒt@C@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoSvnConfXml2SvnConfFile {
    public static final String CMDLINE_PREFIX = "svnconf: ";

    /**
     * XMLt@Cݒt@C܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argDirectoryTarget
     *            ݒt@CfBNgB
     * @param argAcceptLowerCaseUserName
     *            ꂽ[U󂯕t邩ǂB
     * @return ^̔zB
     * @throws IOException
     *             o͗OꍇB
     */
    public BlancoSvnConfStructure[] process(final File argMetaXmlSourceFile,
            final File argDirectoryTarget,
            final boolean argAcceptLowerCaseUserName) throws IOException {
        final BlancoSvnConfStructure[] structures = new BlancoSvnConfParser()
                .parse(argMetaXmlSourceFile);

        for (int index = 0; index < structures.length; index++) {
            // ^̉͌ʂƂɃ\[XR[hs܂B
            structure2File(structures[index], argDirectoryTarget,
                    argAcceptLowerCaseUserName);
        }

        return structures;
    }

    /**
     * w̃V[g̋LqeWJ܂B
     * 
     * @param argStructure
     *            ^XN̍\B
     * @param argDirectoryTarget
     *            o͐fBNg
     * @param argAcceptLowerCaseUserName
     *            ꂽ[U󂯕t邩ǂB
     */
    public void structure2File(final BlancoSvnConfStructure argStructure,
            final File argDirectoryTarget,
            final boolean argAcceptLowerCaseUserName) {
        final File dirBlancoSvnConf = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/svn.conf");
        dirBlancoSvnConf.mkdirs();
        final File fileSvnConf = new File(dirBlancoSvnConf.getAbsolutePath()
                + "/" + argStructure.getName() + ".svnauthz");
        expandSvnConf(argStructure, fileSvnConf, argAcceptLowerCaseUserName);
    }

    /**
     * Subversionp̐ݒt@C𐶐܂B
     * 
     * @param argStructure
     *            \̏B
     * @param argTarget
     *            o͐t@CB
     * @param argAcceptLowerCaseUserName
     *            ꂽ[U󂯕t邩ǂB
     */
    private void expandSvnConf(final BlancoSvnConfStructure argStructure,
            final File argTarget, final boolean argAcceptLowerCaseUserName) {
        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(
                    outStream));

            writeHead(argStructure, writer, argAcceptLowerCaseUserName);
            writer.newLine();

            writeBody(argStructure, writer, argAcceptLowerCaseUserName);
            writer.newLine();

            if ("new".equals(argStructure.getType())) {
                writeUsageNewRepos(argStructure, writer);
                writer.newLine();
            } else if ("update".equals(argStructure.getType())) {
                writeUsageUpdateRepos(argStructure, writer);
                writer.newLine();
            } else if ("delete".equals(argStructure.getType())) {
                writeUsageDeleteRepos(argStructure, writer);
                writer.newLine();
            }

            writeEndOfFile(writer);

            writer.close();
            writer.close();
        } catch (IOException ex) {
        }

        try {
            switch (BlancoFileUtil.bytes2FileIfNecessary(outStream
                    .toByteArray(), argTarget)) {
            case 1:
                System.out.println(CMDLINE_PREFIX + "create: "
                        + argTarget.getAbsolutePath());
                break;
            case 2:
                System.out.println(CMDLINE_PREFIX + "update: "
                        + argTarget.getAbsolutePath());
                break;
            }
        } catch (IOException e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
        }
    }

    /**
     * ݒt@Cwbḧ̏oB
     * 
     * @param argStructure
     *            \̏B
     * @param writer
     *            o͐惉C^[B
     * @param argAcceptLowerCaseUserName
     *            ꂽ[U󂯕t邩ǂB
     * @throws IOException
     *             o͗OꍇB
     */
    private void writeHead(final BlancoSvnConfStructure argStructure,
            final BufferedWriter writer,
            final boolean argAcceptLowerCaseUserName) throws IOException {
        final SimpleDateFormat sdFormat = new SimpleDateFormat("yyyy/MM/dd");

        writer
                .write("############################################################");
        writer.newLine();
        writer.write("# <" + argStructure.getBaseDirectory() + ".conf/"
                + argStructure.getName() + ".svnauthz" + ">");
        writer.newLine();
        writer.write("#");
        writer.newLine();
        writer.write("# ̃t@C [" + argStructure.getName()
                + "] |Wĝ߂ SubversionF؃t@CłB");
        writer.newLine();
        writer.write("#");
        writer.newLine();

        writer.write("# |Wg`ID: " + argStructure.getName());
        writer.newLine();
        if (argStructure.getDescription() != null) {
            writer.write("# : " + argStructure.getDescription());
            writer.newLine();
        }
        writer.write("# zXg: " + argStructure.getHostname());
        writer.newLine();
        writer.write("# fBNg: " + argStructure.getBaseDirectory());
        writer.newLine();
        writer.write("# ǗID: " + argStructure.getManagerName());
        writer.newLine();
        if (argStructure.getValidityPeriodBegin() != null) {
            writer.write("# LԁEJn: "
                    + sdFormat.format(argStructure.getValidityPeriodBegin()));
            writer.newLine();
        }
        if (argStructure.getValidityPeriodEnd() != null) {
            writer.write("# LԁEI: "
                    + sdFormat.format(argStructure.getValidityPeriodEnd()));
            writer.newLine();
        }
        if (argAcceptLowerCaseUserName) {
            writer
                    .write("# ꂽpIDtBɂ菬pIDSubversionF؂ɓn錻ۂɑΉ邽߁B");
            writer.newLine();
        }
        writer
                .write("############################################################");
        writer.newLine();
    }

    /**
     * ݒt@C{̗̈̏oB
     * 
     * @param argStructure
     *            \̏B
     * @param writer
     *            o͐惉C^[B
     * @param argAcceptLowerCaseUserName
     *            ꂽ[U󂯕t邩ǂB
     * @throws IOException
     *             o͗OꍇB
     */
    private void writeBody(final BlancoSvnConfStructure argStructure,
            final BufferedWriter writer,
            final boolean argAcceptLowerCaseUserName) throws IOException {
        final ArrayList listCommitter = new ArrayList();
        final ArrayList listReader = new ArrayList();
        for (int index = 0; index < argStructure.getUserList().size(); index++) {
            final BlancoSvnConfUserStructure user = (BlancoSvnConfUserStructure) argStructure
                    .getUserList().get(index);
            if ("rw".equals(user.getAuth())) {
                listCommitter.add(user);
            }
            if ("r".equals(user.getAuth())) {
                listReader.add(user);
            }
        }

        writer.write("[groups]");
        writer.newLine();
        {
            writer.write("# ǂݏ(rw): " + listCommitter.size() + "");
            writer.newLine();
            final StringBuffer strbuf = new StringBuffer();
            for (int index = 0; index < listCommitter.size(); index++) {
                final BlancoSvnConfUserStructure user = (BlancoSvnConfUserStructure) listCommitter
                        .get(index);
                if (index != 0) {
                    strbuf.append(",");
                }
                addUserLine(user, strbuf, writer, argAcceptLowerCaseUserName);
            }
            writer.write("committer = " + strbuf.toString());
        }
        writer.newLine();
        writer.newLine();
        {
            writer.write("# ǂݍ(r) : " + listReader.size() + "");
            writer.newLine();
            final StringBuffer strbuf = new StringBuffer();
            for (int index = 0; index < listReader.size(); index++) {
                final BlancoSvnConfUserStructure user = (BlancoSvnConfUserStructure) listReader
                        .get(index);
                if (index != 0) {
                    strbuf.append(",");
                }
                addUserLine(user, strbuf, writer, argAcceptLowerCaseUserName);
            }
            writer.write("reader = " + strbuf.toString());
        }
        writer.newLine();
        writer.newLine();

        writer.write("[/]");
        writer.newLine();

        if ("r".equals(argStructure.getAnonymousAuth())
                || "rw".equals(argStructure.getAnonymousAuth())) {
            writer.write("# o^җp");
            writer.newLine();
            writer.write("* = " + argStructure.getAnonymousAuth());
            writer.newLine();
            writer.newLine();
        } else {
            writer.write("# o^җṕA܂B");
            writer.newLine();
            writer.newLine();
        }

        writer.write("@committer = rw");
        writer.newLine();
        writer.write("@reader = r");
        writer.newLine();
    }

    /**
     * [U킷s
     * 
     * @param user
     * @param strbuf
     * @param writer
     * @param argAcceptLowerCaseUserName
     * @throws IOException
     */
    private void addUserLine(final BlancoSvnConfUserStructure user,
            final StringBuffer strbuf, final BufferedWriter writer,
            final boolean argAcceptLowerCaseUserName) throws IOException {
        strbuf.append(user.getName());
        boolean isLowerCaseUserNameNeed = false;
        if (argAcceptLowerCaseUserName) {
            // [UIDłANZXꍇ̏B
            if (user.getName().toLowerCase().equals(user.getName()) == false) {
                isLowerCaseUserNameNeed = true;
            }
        }
        if (isLowerCaseUserNameNeed) {
            strbuf.append("," + user.getName().toLowerCase());
        }

        writer.write("# "
                + user.getName()
                + (isLowerCaseUserNameNeed ? (" ("
                        + user.getName().toLowerCase() + ")") : ""));
        if (BlancoStringUtil.null2Blank(user.getDescription()).length() > 0) {
            writer.write(" : "
                    + BlancoStringUtil.null2Blank(user.getDescription()));
        }
        writer.newLine();
    }

    private void writeUsageNewRepos(final BlancoSvnConfStructure argStructure,
            final BufferedWriter writer) throws IOException {
        writer.write("########################################");
        writer.newLine();
        writer.write("# Subversion|Wg쐬R}h");
        writer.newLine();
        writer.write("# svnadmin create " + argStructure.getBaseDirectory()
                + "/" + argStructure.getName());
        writer.newLine();
        writer.write("########################################");
        writer.newLine();
    }

    private void writeUsageUpdateRepos(
            final BlancoSvnConfStructure argStructure,
            final BufferedWriter writer) throws IOException {
        writer.write("########################################");
        writer.newLine();
        writer.write("# Subversion|WgXV");
        writer.newLine();
        writer.write("########################################");
        writer.newLine();
    }

    private void writeUsageDeleteRepos(
            final BlancoSvnConfStructure argStructure,
            final BufferedWriter writer) throws IOException {
        writer.write("########################################");
        writer.newLine();
        writer.write("# Subversion|Wg폜");
        writer.newLine();
        writer.write("# fBNg폜\ [" + argStructure.getBaseDirectory() + "/"
                + argStructure.getName() + "]");
        writer.newLine();
        writer.write("########################################");
        writer.newLine();
    }

    /**
     * end of file ̈̏oB
     * 
     * @param writer
     *            o͐惉C^[B
     * @throws IOException
     *             o͗OꍇB
     */
    private void writeEndOfFile(final BufferedWriter writer) throws IOException {
        writer.write("####################");
        writer.newLine();
        writer.write("# end of file");
        writer.newLine();
        writer.write("####################");
        writer.newLine();
    }
}
