/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;

import blanco.cg.valueobject.BlancoCgSourceFile;

/**
 * blancoCg̃o[IuWFNg\[XR[hgXtH[}[̃C^tF[XłB
 *
 * ʂ̌p̃\[XR[h́ÃC^tF[XĎ܂B
 *
 * @author IGA Tosiki
 */
public interface BlancoCgTransformer {
    /**
     * \[Xt@CEo[IuWFNgJava\[XR[hɕϊďo͐fBNgɏo͂܂B
     *
     * APIł̓pbP[W\fBNg\Ƃčl܂B
     *
     * @param sourceFile \[Xt@CEo[IuWFNgB
     * @param outputDirectory o͐惋[gfBNgB
     */
    void transform(final BlancoCgSourceFile sourceFile, final File outputDirectory);

    /**
     * \[Xt@CEo[IuWFNg\[XR[hɕϊăC^[ɏo͂܂B
     *
     * APIł̓pbP[W\fBNg\Ƃ͍l܂B
     *
     * @param sourceFile \[Xt@CEo[IuWFNgB
     * @param writer o͐̃C^[B
     * @throws IOException o͗OꍇB
     */
    void transform(final BlancoCgSourceFile sourceFile, final BufferedWriter writer) throws IOException;
}
