/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.resourcebundle;

import java.io.File;
import java.util.ArrayList;

import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleStructure;

/**
 * XMLt@C vpeBt@C̃L[݂̂̒萔NX𐶐܂B
 * 
 * ̃\[XR[hblancoResourceBundlëꕔłB<br>
 * Iɂ blancoConstantspXMLt@C𐶐܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleXml2ConstantsXml {
    /**
     * \[XohANZT̃CX^XB
     */
    private final BlancoResourceBundleResourceBundle fBundle = new BlancoResourceBundleResourceBundle();

    /**
     * XMLt@C vpeBt@C̃L[݂̂̒萔NX𐶐܂B
     * 
     * @param fileSource
     *            ͂ƂȂ钆XMLt@CB
     * @param blancoTmpResourceBundleDirectory
     *            blancoConstantsp̒XMLt@Co͂o͐fBNgB
     */
    public void process(final File fileSource,
            final File blancoTmpResourceBundleDirectory) {
        final DOMResult result = BlancoXmlUtil.transformFile2Dom(fileSource);

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);
                // System.out.println("V[g[" + elementSheet.getAttribute("name")
                // + "]B");

                final NodeList listCommon = elementSheet
                        .getElementsByTagName(fBundle
                                .getMeta2xmlElementCommon());
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                final Element elementCommon = (Element) listCommon.item(0);
                final String baseName = BlancoXmlUtil.getTextContent(
                        elementCommon, "baseName");
                if (baseName == null) {
                    continue;
                }

                if (BlancoXmlUtil.getTextContent(elementCommon, "packageName") == null) {
                    continue;
                }

                final ArrayList listLocale = new ArrayList();
                final NodeList nodeListCommon = elementCommon
                        .getElementsByTagName("locale");
                for (int indexLocale = 0; indexLocale < nodeListCommon
                        .getLength(); indexLocale++) {
                    final Node nodeLook = nodeListCommon.item(indexLocale);
                    if (nodeLook instanceof Element) {
                        final Element elementLook = (Element) nodeLook;
                        final NodeList nodeChields = elementLook
                                .getChildNodes();
                        for (int indexChild = 0; indexChild < nodeChields
                                .getLength(); indexChild++) {
                            final Node nodeChild = nodeChields.item(indexChild);
                            if (nodeChild instanceof Text) {
                                listLocale.add(((Text) nodeChild)
                                        .getNodeValue());
                            }
                        }
                    }
                }
                if (listLocale.size() == 0) {
                    continue;
                }

                expandSheet(elementSheet, elementCommon,
                        blancoTmpResourceBundleDirectory);
            }
        }
    }

    /**
     * V[g̃m[hWJ܂B
     * 
     * @param elementSheet
     *            V[gGgB
     * @param elementCommon
     *            ʃGgB
     * @param blancoTmpResourceBundleDirectory
     *            blancoConstantsp̒XMLt@Co͂o͐fBNgB
     */
    private void expandSheet(final Element elementSheet,
            final Element elementCommon,
            final File blancoTmpResourceBundleDirectory) {
        final BlancoResourceBundleBundleStructure structure = new BlancoResourceBundleBundleStructure();
        structure.setName(BlancoXmlUtil.getTextContent(elementCommon,
                "baseName"));
        // NX͖Oό`܂B
        final String className = BlancoNameAdjuster.toClassName(structure
                .getName())
                + "Constants";
        structure.setPackage(BlancoXmlUtil.getTextContent(elementCommon,
                "packageName"));
        structure.setDescription(BlancoXmlUtil.getTextContent(elementCommon,
                "description"));

        final NodeList listResourceList = elementSheet
                .getElementsByTagName(fBundle.getMeta2xmlElementList());
        if (listResourceList.getLength() == 0) {
            // commonꍇɂ̓XLbv܂B
            return;
        }

        new File(blancoTmpResourceBundleDirectory.getAbsolutePath()
                + "/constants").mkdirs();

        final Document document = BlancoXmlUtil.newDocument();
        final Element eleWorkbook = document.createElement("workbook");
        document.appendChild(eleWorkbook);

        final Element eleSheet = document.createElement("sheet");
        eleWorkbook.appendChild(eleSheet);

        final Element eleCommon = document
                .createElement("blancoconstants-common");
        eleSheet.appendChild(eleCommon);

        BlancoXmlUtil.addChildElement(document, eleCommon, "name", className);
        BlancoXmlUtil.addChildElement(document, eleCommon, "package", structure
                .getPackage());
        BlancoXmlUtil.addChildElement(document, eleCommon, "description",
                structure.getDescription());
        BlancoXmlUtil.addChildElement(document, eleCommon, "fileDescription",
                structure.getDescription());

        final Element eleList = document.createElement("blancoconstants-list");
        eleSheet.appendChild(eleList);

        final NodeList listResource = ((Element) listResourceList.item(0))
                .getElementsByTagName("resource");
        final int sizeListResource = listResource.getLength();
        for (int indexResource = 0; indexResource < sizeListResource; indexResource++) {
            final Element elementResource = (Element) listResource
                    .item(indexResource);

            final Element eleField = document.createElement("field");
            eleList.appendChild(eleField);

            final String fieldResourceId = BlancoXmlUtil.getTextContent(
                    elementResource, "resourceKey");

            // no͂ďo͂܂B

            BlancoXmlUtil.addChildElement(document, eleField, "name",
                    fieldResourceId.replaceAll("[.]", "_"));
            BlancoXmlUtil.addChildElement(document, eleField, "type",
                    "java.lang.String");
            BlancoXmlUtil.addChildElement(document, eleField, "value",
                    fieldResourceId);

            String allDescription = "";
            final NodeList nodeListResourceString = elementResource
                    .getElementsByTagName("resourceString");
            for (int indexResourceString = 0; indexResourceString < nodeListResourceString
                    .getLength(); indexResourceString++) {
                if (nodeListResourceString.item(indexResourceString) instanceof Element) {
                    final Element elementResourceString = (Element) nodeListResourceString
                            .item(indexResourceString);
                    final String resourceString = BlancoXmlUtil
                            .getTextContent(elementResourceString);
                    if (resourceString != null) {
                        if (allDescription.length() != 0) {
                            allDescription += "\n";
                        }
                        allDescription += resourceString;
                    }
                }
            }

            // ۂ̃L[̓eJavaDocɋLڂ܂B
            BlancoXmlUtil.addChildElement(document, eleField, "description",
                    "e: " + allDescription + " (L[: " + fieldResourceId + ")");
        }
        BlancoXmlUtil.transformDom2File(document, new File(
                blancoTmpResourceBundleDirectory.getAbsolutePath()
                        + "/constants/" + className + ".constantsxml"));
    }
}