package blanco.anttask.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.anttask.BlancoAntTaskConstants;
import blanco.anttask.BlancoAntTaskMeta2Xml;
import blanco.anttask.BlancoAntTaskXml2JavaClass;
import blanco.anttask.resourcebundle.BlancoAntTaskMessageResourceBundle;
import blanco.anttask.task.valueobject.BlancoAntTaskBatchProcessInput;

/**
 * ob`NXB
 * 
 * ob`̌ĂяoB <code>
 * java -classpath (NXpX) blanco.anttask.task.BlancoAntTaskBatchProcess -help
 * </code>
 */
public class BlancoAntTaskBatchProcess extends
        AbstractBlancoAntTaskBatchProcess {
    /**
     * bZ[W`B
     */
    protected final BlancoAntTaskMessageResourceBundle fMsg = new BlancoAntTaskMessageResourceBundle();

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     * 
     * ̃\bhɎۂ̏eLq܂B
     * 
     * @param input
     *            ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION,
     *         END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͒lɕsꍇB
     */
    public int process(final BlancoAntTaskBatchProcessInput input)
            throws IOException, IllegalArgumentException {
        System.out.println("- " + BlancoAntTaskConstants.PRODUCT_NAME + " ("
                + BlancoAntTaskConstants.VERSION + ")");

        validateInput(input);

        try {
            final File blancoTmpAntTaskDirectory = new File(input.getTmpdir()
                    + BlancoAntTaskConstants.TARGET_SUBDIRECTORY);
            blancoTmpAntTaskDirectory.mkdirs();

            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fMsg.getMbata001(input
                        .getMetadir()));
            }

            new BlancoAntTaskMeta2Xml().processDirectory(fileMetadir,
                    blancoTmpAntTaskDirectory.getAbsolutePath());

            final File[] fileTmp = blancoTmpAntTaskDirectory.listFiles();
            if (fileTmp == null) {
                // ̗Rɂt@Cꗗ̎擾ɎsꍇB
                throw new IllegalArgumentException(fMsg
                        .getMbata002(blancoTmpAntTaskDirectory
                                .getAbsolutePath()));
            }

            for (int index = 0; index < fileTmp.length; index++) {
                if (fileTmp[index].getName().endsWith(".xml")) {
                    new BlancoAntTaskXml2JavaClass().process(fileTmp[index],
                            new File(input.getTargetdir()));
                }
            }
        } catch (TransformerException e) {
            throw new IOException("XMLϊ̉ߒŗO܂: " + e.toString());
        }

        return END_SUCCESS;
    }
}
