/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.message.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.message.BlancoMessageConstants;
import blanco.message.BlancoMessageMeta2Xml;
import blanco.message.BlancoMessageXml2SourceFile;
import blanco.message.resourcebundle.BlancoMessageResourceBundle;

/**
 * ubZ[W`vExcell烁bZ[WNXE\[XR[h𐶐B
 * 
 * ̃NX́AApache Ant^XN܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoMessageTask extends AbstractBlancoMessageTask {
    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoMessageResourceBundle fBundle = new BlancoMessageResourceBundle();

    /**
     * `(XLS)\[XR[hApache Ant^XÑGg|CgłB
     */
    protected void process() throws IllegalArgumentException {
        System.out.println("- " + BlancoMessageConstants.PRODUCT_NAME + " ("
                + BlancoMessageConstants.VERSION + ")");

        try {
            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fBundle
                        .getAnttaskErr001(getMetadir()));
            }

            if ("true".equals(fBundle
                    .getXml2sourceFileNoGenerateConstantIfFormatElementExist())) {
                System.out
                        .println(fBundle
                                .getXml2sourceFileNoGenerateConstantIfFormatElementExistMsg());
            }

            // e|fBNg쐬B
            new File(getTmpdir() + BlancoMessageConstants.TARGET_SUBDIRECTORY)
                    .mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoMessageMeta2Xml().processDirectory(fileMetadir,
                    getTmpdir() + BlancoMessageConstants.TARGET_SUBDIRECTORY);

            // XMLꂽԃt@C\[XR[h𐶐
            final File[] fileMeta2 = new File(getTmpdir()
                    + BlancoMessageConstants.TARGET_SUBDIRECTORY).listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoMessageXml2SourceFile().process(fileMeta2[index],
                        getTargetlang(), "true".equals(getConstants()),
                        new File(getTargetdir()));
            }
        } catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (TransformerException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }
}
