/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.message;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.util.BlancoCgLineUtil;
import blanco.cg.util.BlancoCgSourceUtil;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.message.resourcebundle.BlancoMessageResourceBundle;
import blanco.message.valueobject.BlancoMessageFieldStructure;
import blanco.message.valueobject.BlancoMessageStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * ubZ[W`vExcell烁bZ[WNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoMessageXml2SourceFile {
    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoMessageResourceBundle fBundle = new BlancoMessageResourceBundle();

    /**
     * o͑ΏۂƂȂvO~OB
     */
    private int fTargetLang = BlancoCgSupportedLang.NOT_DEFINED;

    /**
     * 萔ƂăNXɏo͂邩ǂB
     */
    private boolean fIsGenerateConstants = false;

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * XMLt@C\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argTargetLang
     *            o͑ΏۃvO~OB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @param argIsGenerateConstants
     *            萔NXɏo͂邩ǂ̃tOB
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File argMetaXmlSourceFile,
            final String argTargetLang, final boolean argIsGenerateConstants,
            final File argDirectoryTarget) throws IOException {

        fTargetLang = new BlancoCgSupportedLang().convertToInt(argTargetLang);
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.VB:
        case BlancoCgSupportedLang.PHP:
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
            break;
        default:
            throw new IllegalArgumentException(fBundle
                    .getXml2sourceFileErr002(argTargetLang));
        }

        fIsGenerateConstants = argIsGenerateConstants;

        // ^͂ăo[IuWFNg̃c[擾܂B
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);

        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(documentMeta);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List listSheet = BlancoXmlBindingUtil.getElementsByTagName(
                elementRoot, "sheet");
        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            // ̂̂̃V[g܂B
            final BlancoXmlElement elementSheet = (BlancoXmlElement) listSheet
                    .get(index);

            // ʏ擾܂B
            final BlancoXmlElement elementCommon = BlancoXmlBindingUtil
                    .getElement(elementSheet, fBundle
                            .getMeta2xmlElementCommon());
            if (elementCommon == null) {
                // commonꍇɂ́ÃV[g̏XLbv܂B
                continue;
            }

            final String name = BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "name");
            if (BlancoStringUtil.null2Blank(name).trim().length() == 0) {
                // namȅꍇɂ͏XLbv܂B
                continue;
            }

            // ꗗ擾܂B
            final BlancoXmlElement elementList = BlancoXmlBindingUtil
                    .getElement(elementSheet, fBundle.getMeta2xmlElementList());

            // V[gڍׂȏ擾܂B
            final BlancoMessageStructure processStructure = parseSheet(
                    elementCommon, elementList, argDirectoryTarget);

            if (processStructure != null) {
                // ^̉͌ʂƂɃ\[XR[hs܂B
                expandSourceFile(processStructure, argDirectoryTarget);
            }
        }
    }

    /**
     * sheetGgWJ܂B
     * 
     * @param argElementCommon
     *            ݏĂCommonm[hB
     * @param argElementList
     *            ݏĂListm[hB
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     * @return Wꂽ^\f[^B
     */
    private BlancoMessageStructure parseSheet(
            final BlancoXmlElement argElementCommon,
            final BlancoXmlElement argElementList, final File argDirectoryTarget) {

        final BlancoMessageStructure processStructure = new BlancoMessageStructure();
        processStructure.setName(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "name"));
        processStructure.setPackage(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "package"));

        if (BlancoStringUtil.null2Blank(processStructure.getPackage()).trim()
                .length() == 0) {
            throw new IllegalArgumentException(fBundle
                    .getXml2sourceFileErr001(processStructure.getName()));
        }

        if (BlancoXmlBindingUtil
                .getTextContent(argElementCommon, "description") != null) {
            processStructure.setDescription(BlancoXmlBindingUtil
                    .getTextContent(argElementCommon, "description"));
        }

        if (BlancoXmlBindingUtil.getTextContent(argElementCommon, "suffix") != null) {
            processStructure.setSuffix(BlancoXmlBindingUtil.getTextContent(
                    argElementCommon, "suffix"));
        }

        if (argElementList == null) {
            return null;
        }

        // ꗗ̓e擾܂B
        final List listField = BlancoXmlBindingUtil.getElementsByTagName(
                argElementList, "field");
        for (int indexField = 0; indexField < listField.size(); indexField++) {
            final Object nodeField = listField.get(indexField);

            if (nodeField instanceof BlancoXmlElement == false) {
                continue;
            }

            final BlancoXmlElement elementField = (BlancoXmlElement) nodeField;
            BlancoMessageFieldStructure field = new BlancoMessageFieldStructure();
            field
                    .setNo(BlancoXmlBindingUtil.getTextContent(elementField,
                            "no"));

            field.setKey(BlancoXmlBindingUtil.getTextContent(elementField,
                    "key"));
            if (BlancoStringUtil.null2Blank(field.getKey()).length() == 0) {
                continue;
            }

            field.setValue(BlancoXmlBindingUtil.getTextContent(elementField,
                    "value"));
            if (BlancoStringUtil.null2Blank(field.getValue()).length() == 0) {
                // ŌxB
                continue;
            }

            // ɓeo^ĂȂǂ̃`FbNB
            for (int indexPast = 0; indexPast < processStructure.getListField()
                    .size(); indexPast++) {
                final BlancoMessageFieldStructure fieldPast = (BlancoMessageFieldStructure) processStructure
                        .getListField().get(indexPast);
                if (fieldPast.getKey().equals(field.getKey())) {
                    throw new IllegalArgumentException(fBundle
                            .getXml2sourceFileErr003(
                                    processStructure.getName(), field.getKey()));
                }
            }

            processStructure.getListField().add(field);
        }

        return processStructure;
    }

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    private void expandSourceFile(
            final BlancoMessageStructure argProcessStructure,
            final File argDirectoryTarget) {

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(argProcessStructure
                .getPackage(), "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgClass = fCgFactory.createClass(argProcessStructure.getName()
                + BlancoStringUtil.null2Blank(argProcessStructure.getSuffix()),
                BlancoStringUtil.null2Blank(argProcessStructure
                        .getDescription()));
        fCgSourceFile.getClassList().add(fCgClass);

        if (fIsGenerateConstants) {
            expandFieldMessage(argProcessStructure);
        }

        expandMethodGetMessage(argProcessStructure);

        BlancoCgTransformerFactory.getSourceTransformer(fTargetLang).transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * 萔tB[hWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandFieldMessage(
            final BlancoMessageStructure argProcessStructure) {

        for (int indexField = 0; indexField < argProcessStructure
                .getListField().size(); indexField++) {
            final BlancoMessageFieldStructure fieldLook = (BlancoMessageFieldStructure) argProcessStructure
                    .getListField().get(indexField);

            final String fieldName = fieldLook.getKey().toUpperCase();

            // ubZ[Wɒu񂪂ꍇɂ͒萔tB[h͐ȂvƂdl邩ǂ̃tOւ̑ΉB
            if ("true".equals(fBundle
                    .getXml2sourceFileNoGenerateConstantIfFormatElementExist())) {
                final List listSplitMessage = new ArrayList();
                listSplitMessage.add(fieldLook.getValue());
                final int maxReplaceNumber = new BlancoMessageSplitUtil()
                        .split(listSplitMessage);
                if (maxReplaceNumber >= 0) {
                    // u񂪑݂̂Œ萔tB[h͐܂B
                    continue;
                }
            }

            final BlancoCgField cgField = fCgFactory.createField(fieldName,
                    getTypeString(), "["
                            + BlancoCgSourceUtil.escapeStringAsLangDoc(
                                    fTargetLang, fieldLook.getValue()) + "]");
            fCgClass.getFieldList().add(cgField);
            cgField.setAccess("public");
            cgField.setStatic(true);
            cgField.setFinal(true);
            cgField.setDefault(BlancoCgLineUtil
                    .getStringLiteralEnclosure(fTargetLang)
                    + BlancoCgSourceUtil.escapeStringAsSource(fTargetLang,
                            fieldLook.getValue())
                    + BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang));

            if (fieldLook.getNo() != null) {
                cgField.getLangDoc().getDescriptionList().add(
                        fBundle.getXml2sourceFileFieldNo(fieldLook.getNo()));
            }
        }
    }

    /**
     * getbZ[W \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodGetMessage(
            final BlancoMessageStructure argProcessStructure) {

        for (int indexField = 0; indexField < argProcessStructure
                .getListField().size(); indexField++) {
            final BlancoMessageFieldStructure fieldLook = (BlancoMessageFieldStructure) argProcessStructure
                    .getListField().get(indexField);

            final List listSplitMessage = new ArrayList();
            listSplitMessage.add(fieldLook.getValue());
            final int maxReplaceNumber = new BlancoMessageSplitUtil()
                    .split(listSplitMessage);

            switch (fTargetLang) {
            case BlancoCgSupportedLang.RUBY:
            case BlancoCgSupportedLang.PYTHON:
                new BlancoMessageSplitUtil()
                        .splitByNewLineChar(listSplitMessage);
                break;
            }
            final String methodName = "get"
                    + BlancoNameAdjuster.toClassName(fieldLook.getKey());

            final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                    getMethodName(methodName), "bZ[W`ID["
                            + argProcessStructure.getName() + "]AL[["
                            + fieldLook.getKey() + "]̕擾܂B");
            fCgClass.getMethodList().add(cgMethod);

            // System.out.println("u:" + maxReplaceNumber);
            for (int indexArg = 0; indexArg <= maxReplaceNumber; indexArg++) {
                cgMethod.getParameterList().add(
                        fCgFactory.createParameter("arg" + indexArg,
                                getTypeString(), "u{" + indexArg + "}̒lB",
                                true));
            }

            if (fieldLook.getNo() != null) {
                cgMethod.getLangDoc().getDescriptionList().add(
                        fBundle.getXml2sourceFileFieldNo(fieldLook.getNo()));
            }
            cgMethod.getLangDoc().getDescriptionList().add(
                    "["
                            + BlancoCgSourceUtil.escapeStringAsLangDoc(
                                    fTargetLang, fieldLook.getValue()) + "]");

            cgMethod.setReturn(fCgFactory.createReturn(getTypeString(),
                    "bZ[WB"));

            final List lineList = cgMethod.getLineList();

            StringBuffer bufLine = new StringBuffer();

            switch (fTargetLang) {
            case BlancoCgSupportedLang.RUBY:
            case BlancoCgSupportedLang.PYTHON:
                bufLine.append(getReturnStringRuby(listSplitMessage));
                break;
            default:
                bufLine.append(getReturnString(listSplitMessage));
                break;
            }

            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, bufLine
                    .toString())
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
        }
    }

    /**
     * vO~Oꏈnɍ String ^̖̂擾܂B
     * 
     * ^̓ǂݑւB
     * 
     * @return
     */
    private final String getTypeString() {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return "java.lang.String";
        case BlancoCgSupportedLang.CS:
            return "string";
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return "string";
        case BlancoCgSupportedLang.VB:
            return "String";
        }
    }

    /**
     * vO~Oꏈnɍ \bh̖Oό`Ȃ܂B
     * 
     * \bh̓ǂݑւB
     * 
     * @return
     */
    private final String getMethodName(final String argMethodName) {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return argMethodName;
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.VB:
            return BlancoNameAdjuster.toUpperCaseTitle(argMethodName);
        case BlancoCgSupportedLang.JS:
            return argMethodName;
        }
    }

    /**
     * 
     * bZ[W𐶐鎮擾
     * 
     * @param listSplitMessage
     *            ߍݕŕꂽbZ[W̃Xg
     * @return
     */
    private StringBuffer getReturnString(final List listSplitMessage) {
        StringBuffer bufLine = new StringBuffer();
        boolean isPastString = false;
        for (int index = 0; index < listSplitMessage.size(); index++) {
            final Object objLook = listSplitMessage.get(index);
            if (objLook instanceof Integer) {
                // uB
                final Integer intLook = (Integer) objLook;
                if (isPastString) {
                    bufLine.append(BlancoCgLineUtil
                            .getStringLiteralEnclosure(fTargetLang));
                }
                isPastString = false;
                if (index != 0) {
                    bufLine
                            .append(" "
                                    + BlancoCgLineUtil
                                            .getStringConcatenationOperator(fTargetLang)
                                    + " ");
                }
                if (fTargetLang == BlancoCgSupportedLang.PHP) {
                    bufLine.append("$");
                }
                bufLine.append("arg" + intLook.intValue());
            } else {
                if (isPastString == false) {
                    if (index != 0) {
                        bufLine
                                .append(" "
                                        + BlancoCgLineUtil
                                                .getStringConcatenationOperator(fTargetLang)
                                        + " ");
                    }
                    bufLine.append(BlancoCgLineUtil
                            .getStringLiteralEnclosure(fTargetLang));
                }
                isPastString = true;

                final String strLook = (String) objLook;
                bufLine.append(BlancoCgSourceUtil.escapeStringAsSource(
                        fTargetLang, strLook));
            }
        }

        if (isPastString) {
            bufLine.append(BlancoCgLineUtil
                    .getStringLiteralEnclosure(fTargetLang));
        }

        return bufLine;
    }

    /**
     * 
     * RubyɂāAbZ[W𐶐鎮擾
     * 
     * sʂ̕񃊃eƂĎ舵ꍇ gp܂B
     * 
     * @param listSplitMessage
     *            ߍݕŕꂽbZ[W̃Xg
     * @return
     */
    private StringBuffer getReturnStringRuby(final List listSplitMessage) {
        StringBuffer bufLine = new StringBuffer();
        for (int index = 0; index < listSplitMessage.size(); index++) {
            final Object objLook = listSplitMessage.get(index);
            if (index != 0) {
                bufLine.append(" "
                        + BlancoCgLineUtil
                                .getStringConcatenationOperator(fTargetLang)
                        + " ");
            }
            if (objLook instanceof Integer) {
                // ȕꍇB
                final Integer intLook = (Integer) objLook;

                if (fTargetLang == BlancoCgSupportedLang.PHP) {
                    bufLine.append("$");
                }
                bufLine.append("arg" + intLook.intValue());
            } else {
                // 񃊃ȅꍇB
                final String strLook = (String) objLook;

                // ŝ݂̏ꍇA񃊃e\"ň݂͂܂
                StringBuffer literalEnclosure = new StringBuffer();
                if ("\n".equals(strLook)) {
                    literalEnclosure.append("\"");
                } else {
                    literalEnclosure.append(BlancoCgLineUtil
                            .getStringLiteralEnclosure(fTargetLang));
                }

                bufLine.append(literalEnclosure);
                bufLine.append(BlancoCgSourceUtil.escapeStringAsSource(
                        fTargetLang, strLook));
                bufLine.append(literalEnclosure);
            }
        }

        return bufLine;
    }
}
