package blanco.plugin.message.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import blanco.doclisting.BlancoDocListingXml2CombinedXmlCsv;
import blanco.message.BlancoMessageConstants;
import blanco.message.BlancoMessageMeta2Xml;
import blanco.message.BlancoMessageXml2SourceFile;
import blanco.message.resourcebundle.BlancoMessageResourceBundle;
import blanco.plugin.message.BlancoMessagePlugin;
import blanco.plugin.message.BlancoMessagePluginConstants;
import blanco.plugin.message.editors.BlancoMessagePluginUtil;

public class BlancoMessageGenerateAction {
    private static final BlancoMessageResourceBundle fBundle = new BlancoMessageResourceBundle();

    /**
     * \[XR[hs܂B
     * 
     * @param ifile
     *            Ώۂ̃t@CB
     * @param shell
     *            ẽVFB
     * @param workbenchMonitor
     *            [Nx`j^B
     * @param targetLang
     *            o͑ΏۃvO~OB
     * @param argIsGenerateConstants
     *            萔tB[h𐶐邩ǂB
     * @param metaDir
     *            ^fBNgB
     * @throws InvocationTargetException
     *             s̗OB
     * @throws InterruptedException
     *             荞ݗOB
     */
    public static final void processBlancoMessageSource(final IFile ifile,
            final Shell shell, final IProgressMonitor workbenchMonitor,
            final String targetLang, final boolean argIsGenerateConstants,
            final String metaDir) throws InvocationTargetException,
            InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(final IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask(
                                        BlancoMessageConstants.PRODUCT_NAME
                                                + "\[XR[h", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("fBNg: e|tH_̒B");

                                // e|tH_U폜܂B
                                BlancoMessagePluginUtil
                                        .deleteFolder(
                                                ifile,
                                                workbenchMonitor,
                                                "tmp"
                                                        + BlancoMessageConstants.TARGET_SUBDIRECTORY);
                                BlancoMessagePluginUtil
                                        .createFolder(
                                                ifile,
                                                workbenchMonitor,
                                                "tmp"
                                                        + BlancoMessageConstants.TARGET_SUBDIRECTORY);
                                final IFolder tempFolder = BlancoMessagePluginUtil
                                        .findFolder(
                                                ifile,
                                                workbenchMonitor,
                                                "tmp"
                                                        + BlancoMessageConstants.TARGET_SUBDIRECTORY);

                                // hLgꗗ̂߂̒ԃt@CpfBNgB
                                final File blancoTempDirectoryDocListing = ifile
                                        .getProject().getFolder(
                                                "tmp/doclisting").getLocation()
                                        .toFile();
                                blancoTempDirectoryDocListing.mkdirs();

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask(fBundle
                                        .getMetafileDisplayname()
                                        + " (*.xls)܂");
                                monitor.worked(1);

                                final IFolder findFolder = BlancoMessagePluginUtil
                                        .findFolder(ifile, workbenchMonitor,
                                                metaDir);
                                findFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                new BlancoMessageMeta2Xml() {
                                    protected boolean progress(
                                            final int progressCurrent,
                                            final int progressTotal,
                                            final String progressItem) {
                                        if (monitor.isCanceled()) {
                                            // f܂B
                                            return false;
                                        }

                                        monitor.subTask("^t@C: t@C["
                                                + progressItem + "]܂ ("
                                                + progressCurrent + "/"
                                                + progressTotal + ")");

                                        if (BlancoMessagePluginConstants.IS_DEBUG) {
                                            try {
                                                Thread.sleep(10000);
                                            } catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }

                                        return true;
                                    }
                                }.processDirectory(findFolder.getLocation()
                                        .toFile(), tempFolder.getLocation()
                                        .toFile().getAbsolutePath());

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: tmptH_");
                                monitor.worked(1);

                                tempFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                String targetRootFolderName = "blanco";
                                if (targetLang.equals("java") == false) {
                                    targetRootFolderName += "." + targetLang;
                                }

                                monitor.subTask("tH_쐬: "
                                        + targetRootFolderName + "tH_");

                                IFolder folderTargetDirectory = ifile
                                        .getProject().getFolder(
                                                targetRootFolderName);
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectory.create(true, true,
                                            workbenchMonitor);
                                }

                                monitor.subTask("tH_쐬: "
                                        + targetRootFolderName + "/maintH_");
                                final IFolder folderTargetDirectoryWithMain = folderTargetDirectory
                                        .getFolder("main");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectoryWithMain.create(true,
                                            true, workbenchMonitor);
                                }

                                File blancoTargetDirectory = folderTargetDirectory
                                        .getLocation().toFile();

                                monitor.subTask(targetLang + "\[XR[h쐬");
                                monitor.worked(1);

                                IResource[] resourcesXml2 = tempFolder
                                        .members();
                                for (int index = 0; index < resourcesXml2.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (resourcesXml2[index] instanceof IFile) {
                                        IFile fileLook = (IFile) resourcesXml2[index];
                                        if (fileLook.getFileExtension().equals(
                                                "xml") == false) {
                                            // gqxmlȊÕt@C̓XLbv܂B
                                            continue;
                                        }

                                        monitor.subTask(targetLang
                                                + "\[XR[h쐬: t@C["
                                                + fileLook.getName()
                                                + "]܂ (" + (index + 1)
                                                + "/" + resourcesXml2.length
                                                + ")");

                                        try {
                                            new BlancoMessageXml2SourceFile()
                                                    .process(
                                                            fileLook
                                                                    .getLocation()
                                                                    .toFile(),
                                                            targetLang,
                                                            argIsGenerateConstants,
                                                            blancoTargetDirectory);
                                        } catch (IllegalArgumentException ex) {
                                            throw new IllegalArgumentException(

                                                    "t@C["
                                                            + fileLook
                                                                    .getName()
                                                            + "]̏ɃG[܂B𒆒f܂B\n\n"
                                                            + ex.toString());
                                        }

                                        if (BlancoMessagePluginConstants.IS_DEBUG) {
                                            Thread.sleep(1000);
                                        }

                                    }
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("hLgꗗ̂߂̒ԃt@C쐬B");
                                monitor.worked(1);

                                // hLgꗗ̂߂̒ԃt@C쐬B
                                final BlancoDocListingXml2CombinedXmlCsv doclistingCsv = new BlancoDocListingXml2CombinedXmlCsv();
                                doclistingCsv.process(tempFolder.getLocation()
                                        .toFile(),
                                        blancoTempDirectoryDocListing);

                                monitor.subTask("tH_XV: "
                                        + targetRootFolderName + "tH_XV");
                                monitor.worked(1);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                folderTargetDirectory.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                if (BlancoMessagePluginConstants.IS_DEBUG) {
                                    Thread.sleep(1000);
                                }
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoMessagePlugin.log(ex);
            // O̒{̌oƂ|CgłB
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoMessagePlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoMessagePlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoMessagePlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }
}