/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * EclipsevOC [BlancoEclipsePluginGenSample]̒ۃGfB^NX
 */
package blanco.sample.eclipseplugingen.editors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.xml.transform.dom.DOMResult;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.editors.text.TextEditor;
import org.w3c.dom.Document;

import blanco.commons.util.BlancoXmlUtil;

/**
 * EclipsevOC [BlancoEclipsePluginGenSample]̒ۃGfB^NXB
 *
 * TvvOłB<br>
 */
public abstract class AbstractBlancoEclipsePluginGenSampleEditor extends TextEditor {
    /**
     * GfB^NX̃RXgN^łB
     */
    public AbstractBlancoEclipsePluginGenSampleEditor() {
        // ̃GR[fBOēo͂邽߂ɃvoC_ZbgĂ܂B
        setDocumentProvider(new BlancoEclipsePluginGenSampleDocumentProvider());
    }

    /**
     * tH[JXZbgꂽꍇɌĂяo܂B
     */
    public final void setFocus() {
    }

    /**
     * OtĕۑĂ邩ǂB
     *
     * @return false߂܂B
     */
    public final boolean isSaveAsAllowed() {
        return false;
    }

    /**
     * GfB^ۂɕۑKvǂ߂܂B
     *
     * @return true߂܂B
     */
    public final boolean isSaveOnCloseNeeded() {
        return true;
    }

    /**
     *
     * @param target
     */
    protected final void setFocusLostHandler(final Control target) {
        target.addFocusListener(new FocusListener() {
            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                saveToTextEditor();
            }
        }
        );
    }

    /**
     * eLXgGfB^f[^[hۂɌĂяo܂B
     *
     * ̃\bh blancoœƎɋK肷̂łB
     */
    protected final void loadFromTextEditor() {
        final String editorText = getDocumentProvider().getDocument(getEditorInput()).get();

        final DOMResult result;
        try {
            result = BlancoXmlUtil.transformStream2Dom(new ByteArrayInputStream(editorText.getBytes("UTF-8")));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return;
        }

        loadFromTextEditorInternal(result);
    }

    /**
     * ۂɃf[^[h鏈eLq܂B
     *
     * @param argResult
     */
    protected abstract void loadFromTextEditorInternal(final DOMResult argResult);

    /**
     * eLXgGfB^f[^Z[uۂɌĂяo܂B
     *
     * ̃\bh blancoœƎɋK肷̂łB
     */
    protected final void saveToTextEditor() {
        Document document = saveToTextEditorInternal();
        if (document == null) {
            return;
        }

        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        BlancoXmlUtil.transformDom2Stream(document, outStream);
        try {
            outStream.flush();
            final String result = new String(outStream.toByteArray(), "UTF-8");
            final String pastEditorText = getDocumentProvider().getDocument(getEditorInput()).get();
            if (pastEditorText.equals(result) == false) {
                // eقȂꍇɂ̂ݏ݂s܂B
                getDocumentProvider().getDocument(getEditorInput()).set(result);
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return;
        } catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    /**
     * ۂɃf[^Z[u鏈eLq܂B
     *
     * @return
     */
    protected abstract Document saveToTextEditorInternal();
}
