/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.util.Iterator;

import blanco.db.definition.QueryIterator;
import blanco.db.mapping.BlancoDbMappingUtil;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.db.util.BlancoDbQueryParserUtil;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class SetInputParameterMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    private QueryIterator _iterator = null;

    public SetInputParameterMethod(final BlancoDbObjectStorage storage,
            final QueryIterator iterator) {
        super("setInputParameter");
        _iterator = iterator;
        this.storage = storage;
    }

    public void setupSignature() {
        getJavaDoc().addException(new Type("java.sql.SQLException"),
                "SQLOꍇB");
        addException(new Type("java.sql.SQLException"));

        final Iterator iteInParameter = _iterator.getInParameterIterator();
        while (iteInParameter.hasNext()) {
            Value value = (Value) iteInParameter.next();
            addArgument(value);
            if (value.getType().getName().equals("InputStream")
                    || value.getType().getName().equals("Reader")) {
                addArgument(new Value(new Type(int.class), value.getName()
                        + "StreamLength"));
            }
        }

        getJavaDoc().addLine("SQLɗ^SQL̓p[^Zbg܂B");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("Iɂ PreparedStatementSQL̓p[^Zbg܂B");

        final Iterator iteInParameterJavaDoc = _iterator
                .getInParameterIterator();
        boolean isFirst = true;
        while (iteInParameterJavaDoc.hasNext()) {
            if (isFirst) {
                isFirst = false;
                // getJavaDoc().addLine("");
            }
            final Value parameter = (Value) iteInParameterJavaDoc.next();
            final String name = parameter.getName();
            getJavaDoc().addParameter(name, "'" + name + "'̒l");
        }
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");

            String strLine = "fLog.debug(\"" + getName() + ": ";
            final Iterator ite = _iterator.getInParameterIterator();
            boolean isFirst = true;
            while (ite.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    strLine += " + \", ";
                }
                Value parameter = (Value) ite.next();
                strLine += parameter.getName() + " = \" + "
                        + parameter.getName();
            }
            strLine += ");";

            implementor.addLine(strLine);
            implementor.addLine("}");
            implementor.addLine("");
        }

        // statementmۂł΂AIprepareStatementĂяo܂B
        implementor.addLine("if (fStatement == null) {");
        implementor.addStatement("prepareStatement()");
        implementor.addLine("}");

        final BlancoDbQueryParserUtil query = new BlancoDbQueryParserUtil(
                _iterator.getQuery());

        final Iterator ite = _iterator.getInParameterIterator();
        while (ite.hasNext()) {
            // TODO: SQLp[^𔭌ȂĂ͂Ȃ܂B
            // AƂ肠^ꂽœoƉ肪Ă܂B
            final Value val = (Value) ite.next();

            final int[] listCol = query.getSqlParameters(val.getName());
            if (listCol == null) {
                throw new IllegalArgumentException("SQL`ID["
                        + _iterator.getName() + "] SQL̓p[^["
                        + val.getName() + "]тĂ܂.");
            }
            for (int iteSame = 0; iteSame < listCol.length; iteSame++) {
                final int index = listCol[iteSame];
                if (BlancoDbMappingUtil.isMapWrapperClassNecessity(val
                        .getType().getName())) {
                    implementor.openIf(val.getName() + " == null");
                    implementor.addStatement("fStatement.setNull("
                            + index
                            + ", "
                            + BlancoDbMappingUtil.convertJavaTypeToJdbcType(val
                                    .getType().getFullName()) + ")");
                    implementor.addElse();
                }

                final String type = BlancoDbMappingUtil
                        .getPreparedStatementSetterMethodName(val.getType()
                                .getName());
                if (val.getType().getName().equals("Date")) {
                    // BlancoDbMappingUtil.mapWrapperClassIntoPrimitive\bhTimestamp^KvłB
                    implementor.addUsingType(new Type("java.sql.Timestamp"));
                }

                String stmtLine = "fStatement."
                        + type
                        + "("
                        + index
                        + ", "
                        + BlancoDbMappingUtil.mapWrapperClassIntoPrimitive(val
                                .getName(), val.getType().getName());
                if (val.getType().getName().equals("InputStream")
                        || val.getType().getName().equals("Reader")) {
                    stmtLine += ", " + val.getName() + "StreamLength";
                }
                stmtLine += ")";
                implementor.addStatement(stmtLine);

                if (BlancoDbMappingUtil.isMapWrapperClassNecessity(val
                        .getType().getName())) {
                    implementor.closeIf();
                }
            }
        }
    }
}