/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.util;

import blanco.db.util.method.ConvertToBlancoExceptionMethod;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.MethodExpander;

/**
 * blancoDbʓIɗp郆[eBeBNXB
 * 
 * ̃NXNXblancoDb\[XR[hŗp܂
 * 
 * @since 2006.03.02
 * @author IGA Tosiki
 */
public class BlancoDbUtilClass extends ClassExpander {
    /**
     * ̃NXg̃NX
     */
    public static final String CLASS_NAME = "BlancoDbUtil";

    private BlancoDbObjectStorage storage = null;

    public BlancoDbUtilClass(final BlancoDbObjectStorage storage,
            final Type argType) {
        super(argType);
        this.storage = storage;
    }

    protected void expandClassStruct() {
        getJavaDoc().addLine("blancoDbʓIɗp郆[eBeBNXB");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("̃NXblancoDb\[XR[hŗp܂ <br>");
        getJavaDoc().addLine(
                "̃NX blancoDb\[XR[h痘p܂BڌĂяoƂ͐܂B");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("@since 2006.03.02");
        getJavaDoc().addLine("@author blanco Framework");

        addMethod(new ConvertToBlancoExceptionMethod(storage));

        addMethod(new MethodExpander("convertTimestampToDate") {
            protected boolean isStatic() {
                return true;
            }

            protected boolean isFinal() {
                return true;
            }

            public void setupSignature() {
                getJavaDoc().addLine("JDBCTimestampDate^ɕϊ܂B");
                getJavaDoc().addLine("");
                getJavaDoc().addLine(
                        "java.sql.Timestamp^java.util.Date^ւƕϊ܂B<br>");
                getJavaDoc()
                        .addLine(
                                "̃\bh blancoDb\[XR[h痘p܂BڌĂяoƂ͐܂B");

                getJavaDoc().addParameter("argTimestamp",
                        "JDBCTimestamp^^܂B");
                addArgument(new Value(new Type("java.sql.Timestamp"),
                        "argTimestamp"));

                getJavaDoc().addReturn("ϊjava.util.Date^߂܂B");
                setReturnType(new Type("java.util.Date"));
            }

            public void implement() {
                getData().addLine("if (argTimestamp == null) {");
                getData().addLine("return null;");
                getData().addLine("}");
                getData().addLine("return new Date(argTimestamp.getTime());");
            }
        });
    }
}