/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker;

import blanco.db.definition.QueryInvoker;
import blanco.db.exception.NoRowModifiedExceptionClass;
import blanco.db.exception.TooManyRowsModifiedExceptionClass;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.implementor.StringLiteral;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class ExecuteSingleUpdateMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    private String runtimePackage = null;

    public ExecuteSingleUpdateMethod(final BlancoDbObjectStorage storage,
            final QueryInvoker invoker) {
        super("executeSingleUpdate");
        this.storage = storage;

        runtimePackage = storage.getSetting().getRootNameSpace();
        if (storage.getSetting().getRuntimePackage() != null) {
            runtimePackage = storage.getSetting().getRuntimePackage();
        }
    }

    public void setupSignature() {
        // ^CpbP[W̕ωɑΉB

        final Type noRowModifiedException = new Type(runtimePackage
                + ".exception.NoRowModifiedException");
        getJavaDoc().addException(noRowModifiedException,
                "f[^x[X̏̌ʁA1sf[^ύXȂꍇB");
        addException(noRowModifiedException);
        final Type tooManyRowsModifiedException = new Type(runtimePackage
                + ".exception.TooManyRowsModifiedException");
        getJavaDoc().addException(tooManyRowsModifiedException,
                "f[^x[X̏̌ʁA1s𒴂f[^ύXĂ܂ꍇB");
        addException(tooManyRowsModifiedException);

        final Type integrityConstraintException = new Type(runtimePackage
                + ".exception.IntegrityConstraintException");
        getJavaDoc().addException(integrityConstraintException,
                "f[^x[XᔽꍇB");
        addException(integrityConstraintException);

        final Type deadlockException = new Type(runtimePackage
                + ".exception.DeadlockException");
        getJavaDoc().addException(deadlockException, "f[^x[XfbhbNꍇB");
        addException(deadlockException);

        final Type timeoutException = new Type(runtimePackage
                + ".exception.TimeoutException");
        getJavaDoc().addException(timeoutException, "f[^x[X^CAEgꍇB");
        addException(timeoutException);

        getJavaDoc().addException(new Type("java.sql.SQLException"),
                "SQLOꍇB");
        addException(new Type("java.sql.SQLException"));

        getJavaDoc().addLine("SQLs܂B");
        getJavaDoc().addLine("");
        getJavaDoc().addLine(
                "SQL̎sʂ1sł邱ƂmF܂Bsʂ1sȊOłꍇɂ͗O𔭐܂B<br>");
        getJavaDoc().addLine("VOLƂȂĂ̂Ő܂B<br>");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        final Value result = new Value(int.class, "result");

        implementor.declare(result, new Statement(int.class, "0"));

        implementor.addStatement("result = executeUpdate()");

        implementor.emptyLine();

        final Type noModified = new Type(runtimePackage + ".exception",
                NoRowModifiedExceptionClass.CLASS_NAME);
        final Type tooMeny = new Type(runtimePackage + ".exception",
                TooManyRowsModifiedExceptionClass.CLASS_NAME);

        Statement s = new Statement(result);
        s.join("==", new Statement(int.class, "0"));
        implementor.openIf(s);

        Call c = new Call(noModified);
        c.addArgument(new StringLiteral("f[^x[X̏̌ʁA1sf[^ύX܂łB"));
        implementor.addThrow(c);

        s = new Statement(result);
        s.join(">", new Statement(int.class, "1"));
        implementor.addElseIf(s);

        Value message = new Value(String.class, "message");
        s = new StringLiteral("f[^x[X̏̌ʁA1s𒴂f[^ύX܂BύX:");
        s.join("+", new Statement(result));
        implementor.declare(message, s);

        c = new Call(tooMeny);
        c.addArgument(message);
        implementor.addThrow(c);

        implementor.closeIf();
    }
}