/**
 * blancoDbc[ <br>
 * TableGatewayXMLt@C邽߂̃[eBeBvO <br>
 * 
 * @since 2005.05.04
 * @author Tosiki Iga
 */
package blanco.db;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.db.collector.BlancoDbDatabaseConnection;
import blanco.db.collector.DatabaseService;
import blanco.db.collector.GatewayCollector;
import blanco.db.conf.BlancoDbDatabaseConnectionSettingDef;
import blanco.db.conf.BlancoDbMetadata;
import blanco.db.conf.Table;
import blanco.db.definition.TableField;
import blanco.db.resourcebundle.BlancoDbResourceBundle;

/**
 * TableGatewayXgAbv邽߂̃[eBeBNXB
 * 
 * 2005.09.05 IGA Tosiki XMLt@Ce[uƂɐ悤ɕύXB <br>
 */
public abstract class BlancoDbTableMeta2Xml implements IBlancoDbProgress {
    /**
     * P\̃NXɕtvtBbNXB
     */
    public static final String CLASS_PREFIX = "Simple";

    private final BlancoDbResourceBundle bundle = new BlancoDbResourceBundle();

    /**
     * łʓI blancoDbGenerators܂B
     * 
     * @param jdbcDriver
     *            JDBChCoNX
     * @param jdbcUrl
     *            JDBCڑURI
     * @param jdbcUsername
     *            JDBC[U
     * @param jdbcPassword
     *            JDBCpX[h
     * @param blancoSqlDirectory
     *            blancoSqli[ꂽfBNg.nullw̍ۂɂ͏XLbv܂.
     * @throws SQLException
     * @throws ParserConfigurationException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws SAXException
     * @throws ClassNotFoundException
     */
    public void process(final BlancoDbDatabaseConnectionSettingDef connDef,
            final File blancoSqlDirectory) throws SQLException, SAXException,
            IOException, ParserConfigurationException, ClassNotFoundException {
        System.out.println(BlancoDbConstants.PRODUCT_NAME + " ("
                + BlancoDbConstants.VERSION + ") P\ANZTSQL: Jn.");

        final BlancoDbDatabaseConnection dbInfoCollector = new BlancoDbDatabaseConnection();
        try {
            dbInfoCollector.connect(connDef);
            dbInfoCollector.getDatabaseVersionInfo();

            final DatabaseService service = new DatabaseService(connDef,
                    dbInfoCollector);
            final GatewayCollector collector = new GatewayCollector(service);

            final BlancoDbMetadata metadata = new BlancoDbMetadata();
            collector.collect(metadata);

            enumTables(dbInfoCollector, service, collector, metadata,
                    blancoSqlDirectory.getAbsolutePath());

        } finally {
            dbInfoCollector.close();
            System.out.println("P\ANZTSQL: I.");
        }
    }

    private final void enumTables(
            final BlancoDbDatabaseConnection dbInfoCollector,
            final DatabaseService service, final GatewayCollector collector,
            final BlancoDbMetadata metadata, final String outputDirectoryName)
            throws SQLException {
        final DocumentBuilderFactory documentFactory = DocumentBuilderFactory
                .newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentFactory.newDocumentBuilder();
        } catch (ParserConfigurationException ex1) {
            System.out.println("hLg쐬ɗO܂.:" + ex1.toString());
            ex1.printStackTrace();
            return;
        }

        final int tableCount = metadata.getTableCount();
        for (int index = 0; index < tableCount; index++) {
            Table table = metadata.getTable(index);
            if (progress(index + 1, tableCount, table.getName()) == false) {
                break;
            }

            Document document = documentBuilder.newDocument();
            Element eleRoot = document.createElement("workbook");
            document.appendChild(eleRoot);

            try {
                System.out.println("\[" + table.getName() + "]܂");
                processEveryTable(service, collector, metadata, document,
                        eleRoot, table);
            } catch (StringIndexOutOfBoundsException ex) {
                System.out.println("\[" + table.getName()
                        + "]̏̉ߒŗO܂: " + ex.toString());
                ex.printStackTrace();
                // d̂ŁA̕\܂B
                dbInfoCollector.getConnection().rollback();
                continue;
                // throw ex;
            }

            OutputStream outStream = null;
            try {
                outStream = new BufferedOutputStream(new FileOutputStream(
                        outputDirectoryName
                                + "/SimpleTable"
                                + BlancoNameAdjuster.toClassName(table
                                        .getName()) + ".xml"));
                final TransformerFactory tf = TransformerFactory.newInstance();
                final Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("standalone", "yes");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty(
                        "{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(new DOMSource(document),
                        new StreamResult(outStream));
                outStream.flush();
                outStream.close();
            } catch (TransformerException ex) {
                System.out
                        .println("XMLhLgۑɕϊO܂.:" + ex.toString());
                ex.printStackTrace();
                return;
            } catch (IOException ex3) {
                System.out.println("XMLhLgۑɓo͗O܂.:"
                        + ex3.toString());
                ex3.printStackTrace();
                return;
            } finally {
                if (outStream != null) {
                    try {
                        outStream.close();
                    } catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    /**
     * ̂̂̃e[u܂B
     * 
     * @param service
     * @param collector
     * @param metadata
     * @param document
     * @param eleRoot
     * @param table
     * @throws SQLException
     */
    private void processEveryTable(final DatabaseService service,
            final GatewayCollector collector, final BlancoDbMetadata metadata,
            final Document document, final Element eleRoot, final Table table)
            throws SQLException {
        final GatewayCollector gatewayCollector = new GatewayCollector(service);
        final ArrayList listCol = gatewayCollector.getTableFields(table);

        generateSelect(collector, metadata, table, listCol, document, eleRoot);

        // XV\J[\p\ǂ̓\bhŔf܂B
        generateSelectUpdatable(service, collector, metadata, table, listCol,
                document, eleRoot);

        generateSelectColumn(collector, metadata, table, listCol, document,
                eleRoot);

        // 2005.11.11 SelectAll\bh͕܂B
        generateSelectAll(collector, metadata, table, listCol, document,
                eleRoot);

        generateInsert(collector, metadata, table, listCol, document, eleRoot,
                false);
        generateInsert(collector, metadata, table, listCol, document, eleRoot,
                true);

        generateUpdate(collector, metadata, table, listCol, document, eleRoot);

        generateDelete(collector, metadata, table, listCol, document, eleRoot);
    }

    /**
     * \݂̂ɂāA܂̓NXɕϊ܂B
     * 
     * @param table
     * @return
     */
    private final String getBaseClassName(final Table table) {
        return BlancoNameAdjuster.toClassName(table.getName());
    }

    /**
     * sANZT𐶐܂B
     * 
     * @param collector
     * @param metadata
     * @param table
     * @param listCol
     * @param document
     * @param eleRoot
     * @throws SQLException
     */
    private final void generateSelect(final GatewayCollector collector,
            final BlancoDbMetadata metadata, final Table table,
            final ArrayList listCol, final Document document,
            final Element eleRoot) throws SQLException {

        final String name = CLASS_PREFIX + getBaseClassName(table) + "Select";

        final Element eleQuery = document.createElement("sheet");
        final Element eleCommon = document.createElement("blancodb-common");
        eleQuery.appendChild(eleCommon);

        appendElementWithText(document, eleCommon, "name", name);
        appendElementWithText(document, eleCommon, "query-type", "iterator");
        appendElementWithText(document, eleCommon, "single", "true");
        appendElementWithText(document, eleCommon, "scroll", bundle
                .getSelectScroll());
        appendElementWithText(document, eleCommon, "updatable", "false");

        final Element queryRoot = document.createElement("blancodb-query");
        eleQuery.appendChild(queryRoot);
        final Element queryLine = document.createElement("query-line");
        queryRoot.appendChild(queryLine);

        final StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");

        boolean isFirstColumn = true;
        for (int indexCol = 0; indexCol < listCol.size(); indexCol++) {
            final TableField field = (TableField) listCol.get(indexCol);

            if (isSkipTypeForSimpleTable(field.getTypeName())) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                sql.append(", ");
            }
            sql.append(field.getName());

        }

        if (isFirstColumn) {
            // ЂƂ񂪏܂łBf܂B
            return;
        }

        sql.append("\n  FROM " + escapeSqlName(table.getName()));

        final Element parameters = document
                .createElement("blancodb-inparameters");
        boolean isFirstPrimaryKey = true;
        for (int indexCol = 0; indexCol < listCol.size(); indexCol++) {
            final TableField field = (TableField) listCol.get(indexCol);
            if (field.isPrimaryKey()) {
                if (isSkipTypeForSimpleTable(field.getTypeName())) {
                    // P\ƂĂ̓XLbvׂ^łB
                    // oCi⃊[_̓L[ƂĂ͗pł܂B
                    continue;
                }

                if (isFirstPrimaryKey) {
                    isFirstPrimaryKey = false;
                    sql.append("\n WHERE ");
                    eleQuery.appendChild(parameters);
                } else {
                    sql.append("\n   AND ");
                }
                sql.append(field.getName() + " = #"
                        + BlancoNameAdjuster.toParameterName(field.getName()));
                final Element parameter = document.createElement("inparameter");
                appendElementWithText(document, parameter, "name",
                        BlancoNameAdjuster.toParameterName(field.getName()));
                appendElementWithText(document, parameter, "type", field
                        .getTypeFullName());
                parameters.appendChild(parameter);
            }
        }

        if (isFirstPrimaryKey) {
            // vC}[L[ꌏĂȂۂɂ́A
            // WHERE쐬Ă܂B
            // s͊댯ƔfAf܂B
            return;
        }

        final CDATASection cdata = document.createCDATASection(sql.toString());
        queryLine.appendChild(cdata);

        // Ō̍ŌŃ[gm[hɒǉ܂B
        eleRoot.appendChild(eleQuery);
    }

    /**
     * XV\Ȍ𐶐܂B
     * 
     * @param collector
     * @param metadata
     * @param table
     * @param listCol
     * @param document
     * @param eleRoot
     * @throws SQLException
     */
    private final void generateSelectUpdatable(final DatabaseService service,
            final GatewayCollector collector, final BlancoDbMetadata metadata,
            final Table table, final ArrayList listCol,
            final Document document, final Element eleRoot) throws SQLException {

        if (BlancoDbDatabaseConnection.DRIVERNAME_SQLSERVER_2000.equals(service
                .getConnection().getDriverName())
                || BlancoDbDatabaseConnection.DRIVERNAME_SQLSERVER_2005
                        .equals(service.getConnection().getDriverName())
                || BlancoDbDatabaseConnection.DRIVERNAME_ORACLE.equals(service
                        .getConnection().getDriverName())
                || BlancoDbDatabaseConnection.DRIVERNAME_POSTGRESQL
                        .equals(service.getConnection().getDriverName())) {
            // blancoDbƂčXV\ȌɑΉĂf[^x[XłB\łB
        } else {
            return;
        }

        final String name = CLASS_PREFIX + getBaseClassName(table)
                + "SelectUpdatable";

        final Element eleQuery = document.createElement("sheet");
        final Element eleCommon = document.createElement("blancodb-common");
        eleQuery.appendChild(eleCommon);

        appendElementWithText(document, eleCommon, "name", name);
        appendElementWithText(document, eleCommon, "query-type", "iterator");
        appendElementWithText(document, eleCommon, "single", "false");
        appendElementWithText(document, eleCommon, "scroll", bundle
                .getSelectUpdatableScroll());
        appendElementWithText(document, eleCommon, "updatable", "true");

        final Element queryRoot = document.createElement("blancodb-query");
        eleQuery.appendChild(queryRoot);
        final Element queryLine = document.createElement("query-line");
        queryRoot.appendChild(queryLine);

        final StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");

        boolean isFirstColumn = true;
        for (int indexCol = 0; indexCol < listCol.size(); indexCol++) {
            TableField field = (TableField) listCol.get(indexCol);
            // XV\œ߂ɁAS擾Ă܂B

            if (isSkipTypeForSimpleTable(field.getTypeName())) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                sql.append(", ");
            }
            sql.append(field.getName());

        }

        if (isFirstColumn) {
            // ЂƂ񂪏܂łBf܂B
            return;
        }

        sql.append("\n  FROM " + escapeSqlName(table.getName()));

        if (BlancoDbDatabaseConnection.DRIVERNAME_SQLSERVER_2000.equals(service
                .getConnection().getDriverName())
                || BlancoDbDatabaseConnection.DRIVERNAME_SQLSERVER_2005
                        .equals(service.getConnection().getDriverName())) {
            sql.append(" WITH (UPDLOCK)");
        }

        final Element parameters = document
                .createElement("blancodb-inparameters");
        boolean isFirstPrimaryKey = true;
        for (int indexCol = 0; indexCol < listCol.size(); indexCol++) {
            TableField field = (TableField) listCol.get(indexCol);
            if (field.isPrimaryKey()) {
                if (isSkipTypeForSimpleTable(field.getTypeName())) {
                    // P\ƂĂ̓XLbvׂ^łB
                    // oCi͌L[ɗpł܂B
                    continue;
                }

                if (isFirstPrimaryKey) {
                    isFirstPrimaryKey = false;
                    sql.append("\n WHERE ");
                    eleQuery.appendChild(parameters);
                } else {
                    sql.append("\n   AND ");
                }
                sql.append(field.getName() + " = #"
                        + BlancoNameAdjuster.toParameterName(field.getName()));
                final Element parameter = document.createElement("inparameter");
                appendElementWithText(document, parameter, "name",
                        BlancoNameAdjuster.toParameterName(field.getName()));
                appendElementWithText(document, parameter, "type", field
                        .getTypeFullName());
                parameters.appendChild(parameter);
            }
        }

        if (isFirstPrimaryKey) {
            // vC}[L[ꌏĂȂۂɂ́A
            // WHERE쐬Ă܂B
            // s͊댯ƔfAf܂B
            return;
        }

        if (BlancoDbDatabaseConnection.DRIVERNAME_ORACLE.equals(service
                .getConnection().getDriverName())
                || BlancoDbDatabaseConnection.DRIVERNAME_POSTGRESQL
                        .equals(service.getConnection().getDriverName())) {
            sql.append(" FOR UPDATE");
        }

        final CDATASection cdata = document.createCDATASection(sql.toString());
        queryLine.appendChild(cdata);

        // Ō̍ŌŃ[gm[hɒǉ܂B
        eleRoot.appendChild(eleQuery);
    }

    /**
     * InputStreamReaderɃ}bv^ɂāAʂIterator𐶐܂B
     * 
     * IteratorȊOł InputStreamReaderɃ}bv^͍ڂƂĂ͐XLbv܂B
     * 
     * @param collector
     * @param metadata
     * @param table
     * @param listCol
     * @param document
     * @param eleRoot
     * @throws SQLException
     */
    private final void generateSelectColumn(final GatewayCollector collector,
            final BlancoDbMetadata metadata, final Table table,
            final ArrayList listCol, final Document document,
            final Element eleRoot) throws SQLException {

        for (int indexCol = 0; indexCol < listCol.size(); indexCol++) {
            final TableField field = (TableField) listCol.get(indexCol);

            if (isSkipTypeForSimpleTable(field.getTypeName()) == false) {
                // ł̓oCiу[_û݁v܂B
                // ̉ӏƔ]Ă_ɒڂĂB
                continue;
            }

            final String name = CLASS_PREFIX + getBaseClassName(table)
                    + "Column"
                    + BlancoNameAdjuster.toClassName(field.getName());

            final Element eleQuery = document.createElement("sheet");
            final Element eleCommon = document.createElement("blancodb-common");
            eleQuery.appendChild(eleCommon);

            appendElementWithText(document, eleCommon, "name", name);
            appendElementWithText(document, eleCommon, "query-type", "iterator");

            // BINARYASCIISTREAM̗ւ̃ANZTPstŏo͂邩ǂB
            // SQL Server 2000ɂẮAPstŐsƁAPsgetSingleRow\bh
            // next() { next() 2xĂяos_ŁAxڂ̌ʂ
            // Xg[Ă܂ƂmĂ܂B
            // ̂悤ȔwiAftHg false ł PsƂłB
            appendElementWithText(document, eleCommon, "single", bundle
                    .getSimpleColBinaryAsciiSelectSinglerow());

            appendElementWithText(document, eleCommon, "scroll", bundle
                    .getSelectScroll());
            appendElementWithText(document, eleCommon, "updatable", "false");

            final Element queryRoot = document.createElement("blancodb-query");
            eleQuery.appendChild(queryRoot);
            final Element queryLine = document.createElement("query-line");
            queryRoot.appendChild(queryLine);

            final StringBuffer sql = new StringBuffer();
            sql.append("SELECT ");
            sql.append(field.getName());
            sql.append("\n FROM " + escapeSqlName(table.getName()));

            final Element parameters = document
                    .createElement("blancodb-inparameters");
            boolean isFirstPrimaryKey = true;
            for (int indexPrimaryKey = 0; indexPrimaryKey < listCol.size(); indexPrimaryKey++) {
                final TableField fieldPrimaryKey = (TableField) listCol
                        .get(indexPrimaryKey);

                if (isSkipTypeForSimpleTable(fieldPrimaryKey.getTypeName())) {
                    // ƂĂ̓XLbvׂ^łB
                    continue;
                }

                if (fieldPrimaryKey.isPrimaryKey() == false) {
                    continue;
                }

                if (isFirstPrimaryKey) {
                    isFirstPrimaryKey = false;
                    sql.append("\n WHERE ");
                    eleQuery.appendChild(parameters);
                } else {
                    sql.append("\n   AND ");
                }

                sql.append(fieldPrimaryKey.getName()
                        + " = #"
                        + BlancoNameAdjuster.toParameterName(fieldPrimaryKey
                                .getName()));

                final Element parameter = document.createElement("inparameter");
                appendElementWithText(document, parameter, "name",
                        BlancoNameAdjuster.toParameterName(fieldPrimaryKey
                                .getName()));
                appendElementWithText(document, parameter, "type",
                        fieldPrimaryKey.getTypeFullName());
                parameters.appendChild(parameter);
            }

            if (isFirstPrimaryKey) {
                // vC}[L[ꌏĂȂۂɂ́A
                // WHERE쐬Ă܂B
                // s͊댯ƔfAf܂B
                return;
            }

            final CDATASection cdata = document.createCDATASection(sql
                    .toString());
            queryLine.appendChild(cdata);

            // Ō̍ŌŃ[gm[hɒǉ܂B
            eleRoot.appendChild(eleQuery);
        }
    }

    /**
     * SڂIterator𐶐܂B
     * 
     * @param collector
     * @param metadata
     * @param table
     * @param listCol
     * @param document
     * @param eleRoot
     * @throws SQLException
     */
    private final void generateSelectAll(final GatewayCollector collector,
            final BlancoDbMetadata metadata, final Table table,
            final ArrayList listCol, final Document document,
            final Element eleRoot) throws SQLException {

        final String name = CLASS_PREFIX + getBaseClassName(table)
                + "SelectAll";

        final Element eleQuery = document.createElement("sheet");
        final Element eleCommon = document.createElement("blancodb-common");
        eleQuery.appendChild(eleCommon);

        appendElementWithText(document, eleCommon, "name", name);
        appendElementWithText(document, eleCommon, "query-type", "iterator");
        appendElementWithText(document, eleCommon, "single", "false");
        appendElementWithText(document, eleCommon, "scroll", bundle
                .getSelectAllScroll());
        appendElementWithText(document, eleCommon, "updatable", "false");

        final Element queryRoot = document.createElement("blancodb-query");
        eleQuery.appendChild(queryRoot);
        final Element queryLine = document.createElement("query-line");
        queryRoot.appendChild(queryLine);

        final StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");

        boolean isFirstColumn = true;
        for (int indexCol = 0; indexCol < listCol.size(); indexCol++) {
            final TableField field = (TableField) listCol.get(indexCol);

            if (isSkipTypeForSimpleTable(field.getTypeName())) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                sql.append(", ");
            }
            sql.append(field.getName());

        }

        if (isFirstColumn) {
            // ЂƂ񂪏܂łBf܂B
            return;
        }

        sql.append("\n  FROM " + escapeSqlName(table.getName()));

        boolean isFirstPrimaryKey = true;
        for (int indexCol = 0; indexCol < listCol.size(); indexCol++) {
            final TableField field = (TableField) listCol.get(indexCol);

            if (isSkipTypeForSimpleTable(field.getTypeName())) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (field.isPrimaryKey()) {
                if (isFirstPrimaryKey) {
                    isFirstPrimaryKey = false;
                    sql.append("\n ORDER BY ");
                } else {
                    sql.append(", ");
                }
                sql.append(field.getName());
            }
        }

        if (isFirstPrimaryKey) {
            // vC}[L[ꌏĂȂۂɂ́A
            // WHERE쐬Ă܂B
            // s͊댯ƔfAf܂B
            return;
        }

        final CDATASection cdata = document.createCDATASection(sql.toString());
        queryLine.appendChild(cdata);

        // Ō̍ŌŃ[gm[hɒǉ܂B
        eleRoot.appendChild(eleQuery);
    }

    /**
     * }sInvoker𐶐܂B
     * 
     * @param collector
     * @param metadata
     * @param table
     * @param listCol
     * @param document
     * @param eleRoot
     * @param isIgnoreNullable
     * @throws SQLException
     */
    private final void generateInsert(final GatewayCollector collector,
            final BlancoDbMetadata metadata, final Table table,
            final ArrayList listCol, final Document document,
            final Element eleRoot, final boolean isIgnoreNullable)
            throws SQLException {

        final String name = CLASS_PREFIX + getBaseClassName(table) + "Insert"
                + (isIgnoreNullable ? "NoNulls" : "");

        final Element eleQuery = document.createElement("sheet");
        final Element eleCommon = document.createElement("blancodb-common");
        eleQuery.appendChild(eleCommon);

        appendElementWithText(document, eleCommon, "name", name);
        appendElementWithText(document, eleCommon, "query-type", "invoker");
        appendElementWithText(document, eleCommon, "single", "true");

        final Element queryRoot = document.createElement("blancodb-query");
        eleQuery.appendChild(queryRoot);
        final Element queryLine = document.createElement("query-line");
        queryRoot.appendChild(queryLine);

        final Element parameters = document
                .createElement("blancodb-inparameters");
        eleQuery.appendChild(parameters);

        final StringBuffer sql = new StringBuffer();
        sql.append("INSERT");
        sql.append("\n  INTO " + escapeSqlName(table.getName()));
        sql.append("\n       (");

        boolean isNullableColumnExist = false;
        boolean isFirstColumn = true;
        for (int indexCol = 0; indexCol < listCol.size(); indexCol++) {
            TableField field = (TableField) listCol.get(indexCol);
            if (isIgnoreNullable
                    && field.getNullable() == ResultSetMetaData.columnNullable) {
                isNullableColumnExist = true;
                continue;
            }

            if (isSkipTypeForSimpleTable(field.getTypeName())) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                sql.append(", ");
            }
            sql.append(field.getName());
        }

        if (isFirstColumn) {
            // ЂƂ񂪏Ă܂B
            // ̑gݍ킹͐XLbv܂B
            return;
        }

        sql.append(")");
        sql.append("\nVALUES");
        sql.append("\n       (");

        boolean isFirstPrimaryKey = true;
        for (int indexCol = 0; indexCol < listCol.size(); indexCol++) {
            final TableField field = (TableField) listCol.get(indexCol);
            if (isIgnoreNullable
                    && field.getNullable() == ResultSetMetaData.columnNullable) {
                continue;
            }

            if (isSkipTypeForSimpleTable(field.getTypeName())) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstPrimaryKey) {
                isFirstPrimaryKey = false;
            } else {
                sql.append(", ");
            }
            sql.append("#"
                    + BlancoNameAdjuster.toParameterName(field.getName()));

            final Element parameter = document.createElement("inparameter");
            appendElementWithText(document, parameter, "name",
                    BlancoNameAdjuster.toParameterName(field.getName()));
            appendElementWithText(document, parameter, "type", field
                    .getTypeFullName());
            parameters.appendChild(parameter);
        }
        sql.append(")");

        if (isFirstPrimaryKey) {
            // vC}[L[ꌏĂȂۂɂ́A
            // WHERE쐬Ă܂B
            // s͊댯ƔfAf܂B
            return;
        }

        final CDATASection cdata = document.createCDATASection(sql.toString());
        queryLine.appendChild(cdata);

        if (isIgnoreNullable == false || isNullableColumnExist) {
            // NULLe񂪏ꂽꍇɂ̂XMLɒǉ܂B
            eleRoot.appendChild(eleQuery);
        }
    }

    /**
     * XVsInvoker𐶐܂B
     * 
     * @param collector
     * @param metadata
     * @param table
     * @param listCol
     * @param document
     * @param eleRoot
     * @throws SQLException
     */
    private final void generateUpdate(final GatewayCollector collector,
            final BlancoDbMetadata metadata, final Table table,
            final ArrayList listCol, final Document document,
            final Element eleRoot) throws SQLException {

        final String name = CLASS_PREFIX + getBaseClassName(table) + "Update";

        final Element eleQuery = document.createElement("sheet");
        final Element eleCommon = document.createElement("blancodb-common");
        eleQuery.appendChild(eleCommon);

        appendElementWithText(document, eleCommon, "name", name);
        appendElementWithText(document, eleCommon, "query-type", "invoker");
        appendElementWithText(document, eleCommon, "single", "true");

        final Element queryRoot = document.createElement("blancodb-query");
        eleQuery.appendChild(queryRoot);
        final Element queryLine = document.createElement("query-line");
        queryRoot.appendChild(queryLine);

        final Element parameters = document
                .createElement("blancodb-inparameters");
        eleQuery.appendChild(parameters);

        final StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + escapeSqlName(table.getName()));
        sql.append("\n   SET ");

        boolean isFirstColumn = true;
        for (int indexCol = 0; indexCol < listCol.size(); indexCol++) {
            final TableField field = (TableField) listCol.get(indexCol);
            if (field.isPrimaryKey()) {
                continue;
            }

            if (isSkipTypeForSimpleTable(field.getTypeName())) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                sql.append(", ");
            }
            sql.append(field.getName() + " = #"
                    + BlancoNameAdjuster.toParameterName(field.getName()));

            final Element parameter = document.createElement("inparameter");
            appendElementWithText(document, parameter, "name",
                    BlancoNameAdjuster.toParameterName(field.getName()));
            appendElementWithText(document, parameter, "type", field
                    .getTypeFullName());
            parameters.appendChild(parameter);
        }

        if (isFirstColumn) {
            // ЂƂ񂪏Ă܂B
            // ̑gݍ킹͐XLbv܂B
            return;
        }

        sql.append("\n WHERE ");

        boolean isFirstPrimaryKey = true;
        for (int indexCol = 0; indexCol < listCol.size(); indexCol++) {
            final TableField field = (TableField) listCol.get(indexCol);
            if (field.isPrimaryKey() == false) {
                continue;
            }

            if (isSkipTypeForSimpleTable(field.getTypeName())) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstPrimaryKey) {
                isFirstPrimaryKey = false;
            } else {
                sql.append("\n   AND ");
            }
            sql.append(field.getName() + " = #" + "where"
                    + BlancoNameAdjuster.toClassName(field.getName()));

            final Element parameter = document.createElement("inparameter");
            appendElementWithText(document, parameter, "name", "where"
                    + BlancoNameAdjuster.toClassName(field.getName()));
            appendElementWithText(document, parameter, "type", field
                    .getTypeFullName());
            parameters.appendChild(parameter);
        }

        if (isFirstPrimaryKey) {
            // vC}[L[ꌏĂȂۂɂ́A
            // WHERE쐬Ă܂B
            // s͊댯ƔfAf܂B
            return;
        }

        final CDATASection cdata = document.createCDATASection(sql.toString());
        queryLine.appendChild(cdata);

        // Ō̍ŌŃ[gm[hɒǉ܂B
        eleRoot.appendChild(eleQuery);
    }

    /**
     * 폜sInvoker𐶐܂B
     * 
     * @param collector
     * @param metadata
     * @param table
     * @param listCol
     * @param document
     * @param eleRoot
     * @throws SQLException
     */
    private final void generateDelete(final GatewayCollector collector,
            final BlancoDbMetadata metadata, final Table table,
            final ArrayList listCol, final Document document,
            final Element eleRoot) throws SQLException {

        final String name = CLASS_PREFIX + getBaseClassName(table) + "Delete";

        final Element eleQuery = document.createElement("sheet");
        final Element eleCommon = document.createElement("blancodb-common");
        eleQuery.appendChild(eleCommon);

        appendElementWithText(document, eleCommon, "name", name);
        appendElementWithText(document, eleCommon, "query-type", "invoker");
        appendElementWithText(document, eleCommon, "single", "true");

        final Element queryRoot = document.createElement("blancodb-query");
        eleQuery.appendChild(queryRoot);
        final Element queryLine = document.createElement("query-line");
        queryRoot.appendChild(queryLine);

        final Element parameters = document
                .createElement("blancodb-inparameters");
        eleQuery.appendChild(parameters);

        final StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM " + escapeSqlName(table.getName()));
        sql.append("\n WHERE ");

        boolean isFirstColumn = true;
        for (int indexCol = 0; indexCol < listCol.size(); indexCol++) {
            final TableField field = (TableField) listCol.get(indexCol);
            if (field.isPrimaryKey() == false) {
                continue;
            }

            if (isSkipTypeForSimpleTable(field.getTypeName())) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                sql.append("\n   AND ");
            }
            sql.append(field.getName() + " = #"
                    + BlancoNameAdjuster.toParameterName(field.getName()));

            final Element parameter = document.createElement("inparameter");
            appendElementWithText(document, parameter, "name",
                    BlancoNameAdjuster.toParameterName(field.getName()));
            appendElementWithText(document, parameter, "type", field
                    .getTypeFullName());
            parameters.appendChild(parameter);
        }

        if (isFirstColumn) {
            // ЂƂ񂪏Ă܂B
            // ̑gݍ킹͐XLbv܂B
            return;
        }

        final CDATASection cdata = document.createCDATASection(sql.toString());
        queryLine.appendChild(cdata);

        // Ō̍ŌŃ[gm[hɒǉ܂B
        eleRoot.appendChild(eleQuery);
    }

    /**
     * ^ꂽSQL̖(\܂͗)ɃGXP[vׂ(Xy[X)܂܂ĂꍇɁA\̂̂_uNI[gŃGXP[v܂B
     * 
     * @param tableName
     * @return
     */
    public static final String escapeSqlName(final String tableName) {
        if (tableName.indexOf(" ") >= 0) {
            return "\"" + tableName + "\"";
        }
        return tableName;
    }

    /**
     * GgɃeLXgtŃGgǉ܂B
     * 
     * @param document
     * @param eleTarget
     * @param tagName
     * @param elementData
     */
    private static final void appendElementWithText(final Document document,
            final Element eleTarget, final String tagName,
            final String elementData) {
        final Element eleWork = document.createElement(tagName);
        eleTarget.appendChild(eleWork);
        eleWork.appendChild(document.createTextNode(elementData));
    }

    /**
     * P\̏ƂăXLbvׂ^ł邩ǂ肵܂B
     * 
     * @param argTypeName
     *            ^BpbP[WB
     * @return XLbvׂ^̏ꍇɂtrueB
     */
    private static final boolean isSkipTypeForSimpleTable(
            final String argTypeName) {
        if (argTypeName.equals("InputStream") || argTypeName.equals("Reader")) {
            return true;
        }
        return false;
    }
}