/*******************************************************************************
 benten.cat.glossary.engine.omegat - Benten default glossary engine.
 Copyright (C) 2009 Information-technology Promotion Agency, Japan.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, see <http://www.gnu.org/licenses>.
 *******************************************************************************/
package benten.cat.glossary.engine.omegat;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.omegat.core.data.StringEntry;
import org.omegat.gui.glossary.GlossaryEntry;

import benten.cat.glossary.core.BentenGlossaryEngine;
import benten.cat.glossary.core.BentenGlossarySearchResult;
import blanco.omegat.util.glossary.MyGlossaryManager;

/**
 * Benten システムのデフォルトの用語集エンジンです。
 * 
 * ★基本設計「共通機能: 用語対訳集エンジン機能」に対応します。
 * 
 * @author YAMAMOTO Koji
 */
public class DefaultGlossaryEngine implements BentenGlossaryEngine {
	/**
	 * OmegaT 用語集管理。
	 */
	private final MyGlossaryManager fGm = new MyGlossaryManager();

	/**
	 * {@inheritDoc}
	 */
	public synchronized void loadTsv(final File dirTsv) throws IOException {
		fGm.loadGlossaryFiles(dirTsv);
	}

	/**
	 * {@inheritDoc}
	 */
	public synchronized void unload() {
		fGm.clear();
	}

	/**
	 * {@inheritDoc}
	 */
	public synchronized List<BentenGlossarySearchResult> search(final String search) {
		final StringEntry strEntry = new StringEntry(search);
		final List<GlossaryEntry> glossaryEntryList = fGm.getGlossary(strEntry);

		final List<BentenGlossarySearchResult> result = new ArrayList<BentenGlossarySearchResult>();
		if (glossaryEntryList == null) {
			return result;
		}

		// 検索結果を API 形式に詰め替え。
		for (final GlossaryEntry glossaryEntry : glossaryEntryList) {
			final BentenGlossarySearchResult row = new BentenGlossarySearchResult();
			row.setSource(glossaryEntry.getSrcText());
			row.setTarget(glossaryEntry.getLocText());
			row.setNote(glossaryEntry.getCommentText());
			result.add(row);
		}
		return result;
	}
}
