/*******************************************************************************
 benten.cat.glossary.engine.omegat - Benten default glossary engine.
 Copyright (C) 2009 Information-technology Promotion Agency, Japan.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, see <http://www.gnu.org/licenses>.
 *******************************************************************************/
package benten.cat.glossary.engine.omegat;

import benten.cat.glossary.core.BentenGlossaryDriver;
import benten.cat.glossary.core.BentenGlossaryDriverManager;
import benten.cat.glossary.core.BentenGlossaryEngine;

/**
 * Benten システムのデフォルトの用語集ドライバーです。
 * 
 * @author YAMAMOTO Koji
 */
public class DefaultGlossaryDriver implements BentenGlossaryDriver {
	/**
	 * このエンジンのドライバー名。
	 */
	public static final String DRIVER_NAME = "omegat"; //$NON-NLS-1$

	static {
		// 自分を登録。
		BentenGlossaryDriverManager.registerDriver(new DefaultGlossaryDriver());
	}

	/**
	 * {@inheritDoc}
	 */
	public String getName() {
		return DRIVER_NAME;
	}

	/**
	 * {@inheritDoc}
	 */
	public BentenGlossaryEngine getEngineInstance() {
		return new DefaultGlossaryEngine();
	}
}
