/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.rdiffbackup.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class ZipCompresser {
    private File baseFile;
    private String baseFilePath;

    public ZipCompresser(File base) {
        this.baseFile = base;
        this.baseFilePath = base.getAbsolutePath();
    }

    public void archive() {
        File zipfile = new File(this.baseFile.getParent(), String.valueOf(this.baseFile.getName()) + ".zip");
        ZipOutputStream zos = null;
        try {
            try {
                zos = new ZipOutputStream((OutputStream)new FileOutputStream(zipfile));
                zos.setEncoding("Windows-31J");
                this.archive(zos, this.baseFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    zos.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                zos.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void archive(ZipOutputStream zos, File file) {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.archive(zos, f);
                ++n2;
            }
        } else {
            BufferedInputStream fis = null;
            try {
                try {
                    fis = new BufferedInputStream(new FileInputStream(file));
                    String entryName = file.getAbsolutePath().replace(this.baseFilePath, "").substring(1);
                    zos.putNextEntry(new ZipEntry(entryName));
                    int ava = 0;
                    while ((ava = fis.available()) > 0) {
                        byte[] bs = new byte[ava];
                        fis.read(bs);
                        zos.write(bs);
                    }
                    zos.closeEntry();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    try {
                        fis.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        fis.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

