/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.rdiffbackup.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sf.amateras.rdiffbackup.dto.ChangeDto;
import jp.sf.amateras.rdiffbackup.util.PathUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.seasar.struts.util.RequestUtil;

public class RDiffBackup {
    private static final String COMMAND = "rdiff-backup";
    private static final Pattern PATTERN = Pattern.compile("\\.([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}\\+09:00)\\.");

    public static List<String> list(String dir) {
        ArrayList<String> result = new ArrayList<String>();
        ProcessBuilder builder = new ProcessBuilder(COMMAND, "-l", dir);
        InputStream in = null;
        try {
            try {
                Process process = builder.start();
                in = process.getInputStream();
                String text = IOUtils.toString((InputStream)in, (String)"UTF-8");
                Matcher matcher = PATTERN.matcher(text);
                while (matcher.find()) {
                    result.add(matcher.group(1));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return result;
    }

    public static List<ChangeDto> changes(String path, String timestamp) {
        ArrayList<ChangeDto> result = new ArrayList<ChangeDto>();
        ProcessBuilder builder = new ProcessBuilder(COMMAND, "--list-changed-since", timestamp, path);
        InputStream in = null;
        try {
            try {
                String[] lines;
                Process process = builder.start();
                in = process.getInputStream();
                String text = IOUtils.toString((InputStream)in, (String)"UTF-8");
                String[] stringArray = lines = text.split("\n");
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    int index = line.indexOf(32);
                    if (index >= 0) {
                        String type = line.substring(0, index);
                        String file = line.substring(index + 1).trim();
                        ChangeDto changeDto = new ChangeDto();
                        changeDto.type = type;
                        changeDto.path = file;
                        result.add(changeDto);
                    }
                    ++n2;
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return result;
    }

    public static File restore(String path, String timestamp) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), RequestUtil.getRequest().getSession().getId());
        tmpDir.mkdir();
        ProcessBuilder builder = new ProcessBuilder(COMMAND, "-r", timestamp, path, new File(tmpDir, PathUtil.getFileName((String)path)).getAbsolutePath());
        InputStream in = null;
        try {
            try {
                Process process = builder.start();
                in = process.getInputStream();
                IOUtils.toString((InputStream)in, (String)"UTF-8");
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return tmpDir;
    }

    public static void removeTemporaryDirectory() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), RequestUtil.getRequest().getSession().getId());
        if (tmpDir.exists() && tmpDir.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)tmpDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

