/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.rdiffbackup.util;

import javax.servlet.http.HttpServletRequest;
import jp.sf.amateras.rdiffbackup.entity.BackupDir;
import jp.sf.amateras.rdiffbackup.service.ConfigService;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.util.RequestUtil;

public class PathUtil {
    public static void checkRoot(String root) {
        if (root == null) {
            throw new IllegalArgumentException();
        }
        ConfigService configService = (ConfigService)SingletonS2Container.getComponent(ConfigService.class);
        for (BackupDir backupDir : configService.getBackupDirList()) {
            if (!backupDir.directory.equals(root)) continue;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void checkPath(String path) {
        if (path != null && path.indexOf("..") >= 0) {
            throw new IllegalArgumentException();
        }
    }

    public static String buildPath(String root, String path) {
        String result = root;
        if (StringUtil.isNotEmpty((String)result)) {
            if (!result.endsWith("/")) {
                result = String.valueOf(result) + "/";
            }
        } else {
            result = "";
        }
        if (StringUtil.isNotEmpty((String)path)) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            result = String.valueOf(result) + path;
        }
        return result;
    }

    public static String getParentPath(String path) {
        int index;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((index = path.lastIndexOf(47)) >= 0) {
            return path.substring(0, index);
        }
        return "";
    }

    public static String getFileName(String path) {
        int index;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((index = path.lastIndexOf(47)) >= 0) {
            return path.substring(index + 1);
        }
        return null;
    }

    public static String getDownloadFileName(String fileName) {
        try {
            HttpServletRequest request = RequestUtil.getRequest();
            String userAgent = request.getHeader("USER-AGENT");
            if (userAgent != null) {
                fileName = userAgent.indexOf("MSIE") >= 0 && userAgent.indexOf("Opera") < 0 ? new String(fileName.getBytes("Windows-31J"), "ISO8859_1") : new String(fileName.getBytes("UTF-8"), "ISO8859_1");
            }
            return fileName;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

