/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.rdiffbackup.action;

import java.util.List;
import javax.annotation.Resource;
import jp.sf.amateras.rdiffbackup.entity.BackupDir;
import jp.sf.amateras.rdiffbackup.form.IndexForm;
import jp.sf.amateras.rdiffbackup.service.ConfigService;
import org.seasar.framework.util.LongConversionUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;

public class IndexAction {
    public List<BackupDir> backupDirList;
    @Resource
    @ActionForm
    protected IndexForm indexForm;
    @Resource
    protected ConfigService configService;

    @Execute(validator=false)
    public String index() {
        this.backupDirList = this.configService.getBackupDirList();
        return "index.jsp";
    }

    @Execute(validator=true, input="index/")
    public String add() {
        this.configService.addBackupDir(this.indexForm.directory, this.indexForm.description);
        return "index/?redirect=true";
    }

    @Execute(validator=true, input="index/")
    public String remove() {
        this.configService.removeBackupDir(LongConversionUtil.toLong((Object)this.indexForm.id));
        return "index/?redirect=true";
    }

    @Execute(validator=true, input="index/")
    public String edit() {
        BackupDir backupDir = this.configService.getBackupDir(LongConversionUtil.toLong((Object)this.indexForm.id));
        this.indexForm.id = backupDir.id.toString();
        this.indexForm.directory = backupDir.directory;
        this.indexForm.description = backupDir.description;
        return "edit.jsp";
    }

    @Execute(validator=true, input="edit.jsp")
    public String update() {
        this.configService.updateBackupDir(LongConversionUtil.toLong((Object)this.indexForm.id), this.indexForm.directory, this.indexForm.description);
        return "index/?redirect=true";
    }

    @Execute(validator=false)
    public String cancel() {
        return "index/?redirect=true";
    }
}

