/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.rdiffbackup.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Resource;
import jp.sf.amateras.rdiffbackup.dto.ChangeDto;
import jp.sf.amateras.rdiffbackup.form.HistoryForm;
import jp.sf.amateras.rdiffbackup.util.PathUtil;
import jp.sf.amateras.rdiffbackup.util.RDiffBackup;
import jp.sf.amateras.rdiffbackup.util.ZipCompresser;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.util.ResponseUtil;

public class HistoryAction {
    public List<String> historyList;
    public Integer historyCount;
    public String root;
    public String path;
    public String date;
    public List<ChangeDto> changeList;
    @Resource
    @ActionForm
    protected HistoryForm historyForm;

    @Execute(validator=true, input="/error.jsp")
    public String index() {
        PathUtil.checkRoot((String)this.historyForm.root);
        PathUtil.checkPath((String)this.historyForm.path);
        this.root = this.historyForm.root;
        this.path = this.historyForm.path;
        String path = PathUtil.buildPath((String)this.root, (String)this.path);
        this.historyList = RDiffBackup.list((String)path);
        this.historyCount = this.historyList.size();
        return "index.jsp";
    }

    @Execute(validator=true, input="/error.jsp")
    public String changes() {
        PathUtil.checkRoot((String)this.historyForm.root);
        PathUtil.checkPath((String)this.historyForm.path);
        this.root = this.historyForm.root;
        this.path = this.historyForm.path;
        this.date = this.historyForm.date;
        String path = PathUtil.buildPath((String)this.root, (String)this.path);
        this.changeList = RDiffBackup.changes((String)path, (String)this.date);
        return "changes.jsp";
    }

    @Execute(validator=true, input="/error.jsp")
    public String download() {
        PathUtil.checkRoot((String)this.historyForm.root);
        PathUtil.checkPath((String)this.historyForm.path);
        if (this.historyForm.path != null && this.historyForm.path.equals(".")) {
            this.historyForm.path = null;
        }
        String path = PathUtil.buildPath((String)this.historyForm.root, (String)this.historyForm.path);
        File tmpDir = RDiffBackup.restore((String)path, (String)this.historyForm.date);
        try {
            try {
                String fileName = PathUtil.getFileName((String)path);
                File file = new File(tmpDir, fileName);
                if (file.isFile()) {
                    ResponseUtil.download((String)fileName, (InputStream)new FileInputStream(file));
                } else {
                    ZipCompresser compresser = new ZipCompresser(file);
                    compresser.archive();
                    ResponseUtil.download((String)PathUtil.getDownloadFileName((String)(String.valueOf(fileName) + ".zip")), (InputStream)new FileInputStream(new File(tmpDir, String.valueOf(fileName) + ".zip")));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            RDiffBackup.removeTemporaryDirectory();
        }
        return null;
    }
}

