/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.rdiffbackup.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import jp.sf.amateras.rdiffbackup.dto.FileDto;
import jp.sf.amateras.rdiffbackup.form.BrowseForm;
import jp.sf.amateras.rdiffbackup.util.FileDtoComparator;
import jp.sf.amateras.rdiffbackup.util.IconManager;
import jp.sf.amateras.rdiffbackup.util.PathUtil;
import org.apache.commons.io.IOUtils;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.taglib.S2Functions;
import org.seasar.struts.util.ResponseUtil;

public class BrowseAction {
    public String root;
    public String path;
    public String parentPath;
    public List<FileDto> files;
    @Resource
    @ActionForm
    protected BrowseForm browseForm;

    @Execute(validator=true, input="/error.jsp")
    public String index() {
        PathUtil.checkRoot((String)this.browseForm.root);
        PathUtil.checkPath((String)this.browseForm.path);
        String path = PathUtil.buildPath((String)this.browseForm.root, (String)this.browseForm.path);
        this.root = this.browseForm.root;
        this.path = this.browseForm.path;
        this.parentPath = StringUtil.isEmpty((String)this.path) ? "" : String.format("browse/?root=%s&path=%s", S2Functions.u((String)this.root), S2Functions.u((String)PathUtil.getParentPath((String)this.path)));
        this.files = new ArrayList();
        File dir = new File(path);
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory() || !file.getName().equals("rdiff-backup-data")) {
                FileDto fileDto = new FileDto();
                fileDto.name = file.getName();
                fileDto.isFile = file.isFile();
                fileDto.path = PathUtil.buildPath((String)this.browseForm.path, (String)file.getName());
                fileDto.date = new Date(file.lastModified());
                fileDto.icon = IconManager.getIcon((File)file);
                if (!fileDto.isFile) {
                    fileDto.name = String.valueOf(fileDto.name) + "/";
                    fileDto.path = String.valueOf(fileDto.path) + "/";
                }
                this.files.add(fileDto);
            }
            ++n2;
        }
        Collections.sort(this.files, new FileDtoComparator());
        return "index.jsp";
    }

    @Execute(validator=true, input="/error.jsp")
    public String download() {
        PathUtil.checkRoot((String)this.browseForm.root);
        PathUtil.checkPath((String)this.browseForm.path);
        String path = PathUtil.buildPath((String)this.browseForm.root, (String)this.browseForm.path);
        FileInputStream in = null;
        try {
            try {
                File file = new File(path);
                in = new FileInputStream(file);
                ResponseUtil.download((String)PathUtil.getDownloadFileName((String)file.getName()), (InputStream)in);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return null;
    }
}

