--
-- Copyright (C) 2022  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (adagate)




procedure InitGlfw( 
	name: string; 
	--wid,hit,fwd,fht: out glint;
	hiDpiDesired: in boolean := true
	) is

	use system;
	use ada.strings.fixed;

	title : interfaces.c.strings.chars_ptr := new_string(name&ascii.nul);

	maj,min,rev : aliased glint;

	--wid,hit,fwd,fht: aliased glint;

	--axs, ays : aliased float;
	--awwid,awhit, afwid, afhit : aliased glint;

	refrate,ret: glint;
	--redhatKin: boolean := false;
	--idfilestr: constant string := "/etc/os-release";
	--ifile: file_type;
	--last: natural;
	--linestr: string(1..255);
begin

	put_line("...using fastrgv's Jan2020 Ada Binding to GLFW33X...");

	GlfwGetVersion(maj'access,min'access,rev'access); --naturals
	put("GLFW ver: ");
	put(glint'image(maj));
	put(":"&glint'image(min));
	put(":"&glint'image(rev));
	New_Line;



	ret:=glfwInit;
	if ret /= gl_true then
		new_line;
		put_line("glfwInit failed");
		raise program_error;
	else
		put("glfwInit Ok"); new_line;
	end if;


	-- use version here that your graphics card would support:
	GlfwWindowHint( glfw_context_version_major, 3);
	GlfwWindowHint( glfw_context_version_minor, 3);
	GlfwWindowHint( glfw_opengl_forward_compat, gl_true);
	GlfwWindowHint( glfw_opengl_profile, glfw_opengl_core_profile);

	GlfwWindowHint( glfw_samples, 4);
	GlfwWindowHint( glfw_client_api, glfw_opengl_api);


	if osx and not hiDpiDesired then
		GlfwWindowHint( glfw_cocoa_retina_framebuffer, glfw_false);
	end if;





	declare
		monit: access glfwMonitor := glfwGetPrimaryMonitor;
		vmode: access constant glfwVidMode 
			:= glfwGetVideoMode(monit);
	begin

		if monit=null then 
		put_line("null monitor");
		else 
		put_line("NoN-null monitor"); --mint
		end if;

		--get current video mode size [full screen]
		refrate:=vmode.refreshRate;

		mainWindow := glfwcreatewindow(
			vmode.width, vmode.height,
			title, monit, null );

	end;

	if mainWindow = null then
		new_line;
		put_line("glfwCreateWindow failed");
		raise program_error;
	end if;

	glfwmakecontextcurrent( mainWindow );

	--delay 1.0; --X11 needs extra time to set window before queries


	if glfwJoystickPresent(glfw_joystick_1)=glfw_true then

		if glfwJoystickIsGamepad(glfw_joystick_1)=glfw_true then
			put_line("Gamepad is present");
			gamepad:=true;
		else
			put_line("Joystick is present");
			joystik:=true;
		end if;

	end if;

	glfwSetInputMode(mainWindow, glfw_cursor, glfw_cursor_disabled);


	if    linux then put_line("system is linux");
	elsif mswin then put_line("system is MsWin");
	elsif   osx then put_line("system is OSX");
	end if;

end InitGlfw;





