# Linux
# gnu Ada compile script for adagate
#
# uses rpath to tell runtime to look also in
# ./libs/gnu/ for any needed *.so files 
# not found elsewhere, eg libglfw.so

#########################################################


# use this to ensure a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi



# first, create oal.o:
g++ src/adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-D obj \
-Isrc/adabindings/adaOpenAL/OalBinding \
-Isrc/adabindings/adaOpenAL/OalBinding/incoal




gnatmake adagate -o adagate_gnat \
-O3 -gnat12 \
-D obj \
-Isrc \
-Isrc/adautils \
-Isrc/adabindings/gl \
-Isrc/adabindings/glfwada \
-Isrc/adabindings/AdaPngLib \
-Isrc/adabindings/adaOpenAL \
-Isrc/adabindings/adaOpenAL/OalBinding \
-Isrc/adabindings/Tables \
-Isrc/adabindings/FreeTypeAda \
-largs \
oal.o \
-lGL -lX11 -lpthread -lstdc++ -lm -lz -ldl \
-lopenal \
-Wl,-rpath='$ORIGIN/libs/gnu' \
-Llibs/gnu \
-lglfw

#-lgnarl_pic -lgnat_pic \

# the runtime path to shared libs is given by rpath

# -- Copyright (C) 2022  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

