<?php
//  ------------------------------------------------------------------------ //
//                   This module; Copyright (c) 2005 gusagi                  //
//                        <http://good-tea.ddo.jp/dev>                       //
//  ------------------------------------------------------------------------ //

//*****************************************************************************/
// ľܸƤӽФ줿exit
//*****************************************************************************/
if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;

if( ! class_exists( 'Anywheressl' ) ) {

	class Anywheressl {

		var $current_url = '';
		var $ssl_url = '';
		var $non_ssl_url = '';
		var $awssl_config = array();
		var $cookie_path = '';

		/**
		 * Anywheressl
		 * 
		 * @param $awssl_config
		 * @return void
		 */
		function Anywheressl( $awssl_config ) {
			// SSLXOOPS_URL
			$this->ssl_url = urldecode( $awssl_config['ssl_url']['conf_value'] );
			// SSLXOOPS_URL
			$this->non_ssl_url = urldecode( $awssl_config['non_ssl_url']['conf_value'] );
			// ⥸塼ͤ¸
			$this->awssl_config = $awssl_config;
			// URL
			$this->setCurrentUrl();
		}

		/**
		 * isSSL
		 * 
		 * @param void
		 * @return void
		 */
		function isSSL() {
			// SSLݤΥե饰
			if ( !empty($_COOKIE['awssl_secure']) && $_COOKIE['awssl_secure'] === 'on' ) {
				return true;
			} else {
				return false;
			}
		}

		/**
		 * setCurrentUrl
		 * 
		 * @param void
		 * @return void
		 */
		function setCurrentUrl() {
			//*****************************************************************/
			// ߤURL
			//*****************************************************************/
			$replace_array = array( '\\' => '/', '\\.\\' => '/', '/./' => '/' );
			$current_path = strtr( $_SERVER['SCRIPT_FILENAME'], $replace_array );
			$query_string = !empty( $_SERVER['QUERY_STRING'] ) ? '?' .$_SERVER['QUERY_STRING'] : '';
			$xoops_root_path = strtr( XOOPS_ROOT_PATH, $replace_array );
			$current_url = urldecode( str_replace($xoops_root_path, XOOPS_URL, strtr($current_path, '\\', '/')) .$query_string );

			//*****************************************************************/
			// SSLݤˤ񤭴
			//*****************************************************************/
			if ( $this->isSSL() ) {
				$this->current_url = str_replace( $this->non_ssl_url, $this->ssl_url, $current_url );
			} else {
				$this->current_url = str_replace( $this->ssl_url, $this->non_ssl_url, $current_url );
			}
		}

		/**
		 * getCurrentUrl
		 * 
		 * @param void
		 * @return void
		 */
		function getCurrentUrl() {
			return $this->current_url;
		}

		/**
		 * setDestination
		 * 
		 * @param void
		 * @return void
		 */
		function setDestination() {
			//*****************************************************************/
			// ߤURL
			//*****************************************************************/
			$current_url = $this->current_url;

			//*****************************************************************/
			// URL
			//*****************************************************************/
			if ( $this->isSSL() ) {
				$destination_url = str_replace( $this->ssl_url, $this->non_ssl_url, $current_url );
			} else {
				$destination_url = str_replace( $this->non_ssl_url, $this->ssl_url, $current_url );
			}

			//*****************************************************************/
			// URL򥻥å˳Ǽ
			//*****************************************************************/
			$_SESSION['AWSSL_DESTINATION'] = $destination_url;
		
		}

		/**
		 * setSecureCookie
		 * 
		 * @param void
		 * @return void
		 */
		function setSecureCookie() {
			//*****************************************************************/
			// 
			//*****************************************************************/
			$ssl_url = $this->ssl_url;

			//*****************************************************************/
			// åΥå
			//*****************************************************************/
			$cookie_path = defined('XOOPS_COOKIE_PATH') ? XOOPS_COOKIE_PATH :
				preg_replace( '?https://[^/]+(/.*)$?' , "$1" , $ssl_url .'/' ) ;// thanks GIJ
			if( $cookie_path === XOOPS_URL ) $cookie_path = '/' ;
			setcookie('awssl_secure', 'on', 0, $cookie_path, '', 1);

			//*****************************************************************/
			// åѿΥå
			//*****************************************************************/
			$_SESSION['AWSSL_LOADED'] = 'on';
		}

		/**
		 * clearAwsslSession
		 * 
		 * @param void
		 * @return void
		 */
		function clearAwsslSession() {
			//*****************************************************************************/ 
			// 
			//*****************************************************************************/
			// DB󥹥󥹤
			$xoopsDB =& Database::getInstance();
			$awssl_tbl = $xoopsDB->prefix( 'anywheressl' );

			//*****************************************************************************/
			// ǡ¸(limit_time)Ķǡ
			//*****************************************************************************/
			$current_time = intval( time() );
			// SQL
			$sql = "DELETE FROM $awssl_tbl";
			$sql .= " WHERE `limit_time` < $current_time";
			$result = $xoopsDB->queryF( $sql );
			if ( ! $result ) {
				return false;
			}
			return true;
		}

		/**
		 * setAwsslSession
		 * 
		 * @param $session_id
		 * @return void
		 */
		function setAwsslSession( $session_id ) {
			//*****************************************************************************/ 
			// 
			//*****************************************************************************/
			// DB󥹥󥹤
			$xoopsDB =& Database::getInstance();
			$awssl_tbl = $xoopsDB->prefix( 'anywheressl' );
			// åμ
			$session_data = addslashes( session_encode() );
			$limit_time = intval( time() + 30 );

			//*****************************************************************************/
			// ǡ¸(limit_time)Ķǡ
			//*****************************************************************************/
			if ( ! $this->clearAwsslSession() ) {
				return false;
			}

			//*****************************************************************************/ 
			// ǡ١ؤξǼ
			//*****************************************************************************/
			// SQL
			$sql = "INSERT INTO $awssl_tbl";
			$sql .= " VALUES ( '$session_id', '$session_data', $limit_time )";
			$result = $xoopsDB->queryF( $sql );
			if ( ! $result ) {
				return false;
			}
			return true;
		}

		/**
		 * getAwsslSession
		 * 
		 * @param $session_id
		 * @return void
		 */
		function getAwsslSession( $session_id ) {
			//*****************************************************************/
			// 
			//*****************************************************************/
			// DB󥹥󥹤
			$xoopsDB =& Database::getInstance();
			$awssl_tbl = $xoopsDB->prefix( 'anywheressl' );
			$session_data = '';
			//*****************************************************************/
			// åμ
			//*****************************************************************/
			// SQL
			$sql = "SELECT `session_data` FROM $awssl_tbl";
			$sql .= " WHERE `session_id` = '$session_id'";
			$result = $xoopsDB->query( $sql );
			while( $myrow = $xoopsDB->fetchArray($result) ) {
				$session_data = $myrow['session_data'];
			}
			return session_decode( $session_data );
		}

		/**
		 * delAwsslSession
		 * 
		 * @param $session_id
		 * @return void
		 */
		function delAwsslSession( $session_id ) {
			//*****************************************************************/
			// 
			//*****************************************************************/
			// DB󥹥󥹤
			$xoopsDB =& Database::getInstance();
			$awssl_tbl = $xoopsDB->prefix( 'anywheressl' );
			//*****************************************************************/
			// åκ
			//*****************************************************************/
			// SQL
			$sql = "DELETE FROM $awssl_tbl";
			$sql .= " WHERE `session_id` = '$session_id'";
			$xoopsDB->queryF( $sql );
			//*****************************************************************/
			// ơ֥κŬ
			//*****************************************************************/
			$sql = "OPTIMIZE TABLE $awssl_tbl";
			$xoopsDB->queryF( $sql );
		}

		/**
		 * awsslSessionRegenerateId
		 * 
		 * @param void
		 * @return void
		 */
		function awsslSessionRegenerateId( $regenerate = true ) {
			//*****************************************************************/
			// 
			//*****************************************************************/
			global $xoopsConfig, $sess_handler;
			$session_cookie = array();
			$ssl_flg = $this->isSSL() ? 1 : 0;
			//*****************************************************************/
			// ȯԤCOOKIEΥѥ
			//*****************************************************************/
			if ( $ssl_flg ) {
				$cookie_path = defined('XOOPS_COOKIE_PATH') ? XOOPS_COOKIE_PATH :
					preg_replace( '?https://[^/]+(/.*)$?' , "$1" , $this->ssl_url .'/' ) ;// thanks GIJ
			} else {
				$cookie_path = defined('XOOPS_COOKIE_PATH') ? XOOPS_COOKIE_PATH :
					preg_replace( '?http://[^/]+(/.*)$?' , "$1" , $this->non_ssl_url .'/' ) ;// thanks GIJ
			}
			if( $cookie_path === XOOPS_URL ) $cookie_path = '/' ;
			//*****************************************************************/
			// ߤΥå
			//*****************************************************************/
			$old_session_id = session_id();
			$session_data = session_encode();
			$session_cookie = session_get_cookie_params();
			//*****************************************************************/
			// ߤΥå˴
			//*****************************************************************/
			session_destroy();
			if ( preg_match( '/^[a-zA-Z0-9]{32}$/', $old_session_id ) ) {
				$session_file = session_save_path() . '/sess_' . $old_session_id;
				if ( is_file($session_file) ) {
					unlink( $session_file );
				}
			}
			if ($xoopsConfig['use_mysession'] && $xoopsConfig['session_name'] != '') {
				setcookie( $xoopsConfig['session_name'], '', time()- 3600, '/',  '', $ssl_flg );
			}
			//*****************************************************************/
			// å
			//*****************************************************************/
			if ( $regenerate ) {
				session_id( md5(uniqid(rand(), 1)) );
			} else {
				session_id( $old_session_id );
			}
			session_set_save_handler(
				array(&$sess_handler, 'open'), 
				array(&$sess_handler, 'close'), 
				array(&$sess_handler, 'read'), 
				array(&$sess_handler, 'write'), 
				array(&$sess_handler, 'destroy'), 
				array(&$sess_handler, 'gc')
			);
			session_set_cookie_params( 
				$session_cookie['lifetime'], 
				$cookie_path, 
				$session_cookie['domain'], 
				$ssl_flg 
			);
			session_start();
			//*****************************************************************/
			// 򤷤åγǼ
			//*****************************************************************/
			session_decode( $session_data );
			if ($xoopsConfig['use_mysession'] && $xoopsConfig['session_name'] != '') {
				setcookie( 
					$xoopsConfig['session_name'], 
					session_id(), 
					time()+(60*$xoopsConfig['session_expire']), 
					$cookie_path, 
					$session_cookie['domain'], 
					$ssl_flg 
				);
			}
		}

	// end of class
	}

	//$Anywheressl = new Anywheressl();

}

?>