/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.engine;

public class MultiTable {
    public static final int NUM_TABLES = 8;
    public static final int CYCLE_SIZE = 1024;
    private static MultiTable instance = new MultiTable(8, 1024);
    private double phaseScalar;
    private float[][] tables;
    private static final double LOWEST_PHASE_INC_INV = 256.0;

    public MultiTable(int n, int n2) {
        int n3;
        int n4 = n2 + 1;
        this.tables = new float[n][n4];
        float[] fArray = this.tables[0];
        this.phaseScalar = (float)((double)n2 * 0.5);
        for (n3 = 0; n3 < n4; ++n3) {
            fArray[n3] = (float)Math.sin((double)n3 / (double)n2 * Math.PI * 2.0 - Math.PI);
        }
        for (n3 = 1; n3 < n; ++n3) {
            float[] fArray2 = this.tables[n3];
            int n5 = 1 << n3;
            double d = Math.PI / (double)(2 * n5);
            for (int i = 0; i < n5; ++i) {
                int n6 = 0;
                int n7 = i + 1;
                double d2 = Math.cos((double)i * d);
                double d3 = d2 * d2 / (double)n7;
                for (int j = 0; j < n4; ++j) {
                    int n8 = j;
                    fArray2[n8] = fArray2[n8] + (float)d3 * fArray[n6];
                    if ((n6 += n7) < n2) continue;
                    n6 -= n2;
                }
            }
        }
        for (n3 = 1; n3 < n; ++n3) {
            MultiTable.normalizeArray(this.tables[n3]);
        }
    }

    public static float normalizeArray(float[] fArray) {
        int n;
        float f = 0.0f;
        for (n = 0; n < fArray.length; ++n) {
            float f2 = Math.abs(fArray[n]);
            if (!(f2 > f)) continue;
            f = f2;
        }
        if (f < 1.0E-7f) {
            f = 1.0E-7f;
        }
        float f3 = 1.0f / f;
        n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = fArray[n2] * f3;
        }
        return f3;
    }

    public double calculateSawtooth(double d, double d2, double d3) {
        double d4;
        double d5 = this.phaseScalar * d + this.phaseScalar;
        int n = (int)d5;
        double d6 = d5 - (double)n;
        int n2 = (int)d3;
        if (n2 > 6) {
            double d7 = d2 * 256.0;
            float[] fArray = this.tables[7];
            double d8 = fArray[n];
            double d9 = fArray[n + 1];
            double d10 = d8 + d6 * (d9 - d8);
            d4 = d + d7 * (d10 - d);
        } else {
            double d11 = d3 - (double)n2;
            if (n2 < 0) {
                if (n2 < -1) {
                    d4 = 0.0;
                } else {
                    float[] fArray = this.tables[0];
                    double d12 = fArray[n];
                    double d13 = fArray[n + 1];
                    double d14 = d12 + d6 * (d13 - d12);
                    d4 = d11 * d14;
                }
            } else {
                float[] fArray = this.tables[n2 + 1];
                double d15 = fArray[n];
                double d16 = fArray[n + 1];
                double d17 = d15 + d6 * (d16 - d15);
                fArray = this.tables[n2];
                d15 = fArray[n];
                d16 = fArray[n + 1];
                double d18 = d15 + d6 * (d16 - d15);
                d4 = d18 + d11 * (d17 - d18);
            }
        }
        return d4;
    }

    public double convertPhaseIncrementToLevel(double d) {
        if (d < 1.0E-30) {
            d = 1.0E-30;
        }
        return -1.0 - Math.log(d) / Math.log(2.0);
    }

    public static MultiTable getInstance() {
        return instance;
    }
}

