/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.VMOption;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import sun.management.Flag;
import sun.management.Util;

public class HotSpotDiagnostic
implements HotSpotDiagnosticMXBean {
    @Override
    public void dumpHeap(String string, boolean bl) throws IOException {
        String string2 = "jdk.management.heapdump.allowAnyFileSuffix";
        PrivilegedAction<Boolean> privilegedAction = () -> Boolean.parseBoolean(System.getProperty(string2, "false"));
        boolean bl2 = AccessController.doPrivileged(privilegedAction);
        if (!bl2 && !string.endsWith(".hprof")) {
            throw new IllegalArgumentException("heapdump file must have .hprof extention");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
            Util.checkControlAccess();
        }
        this.dumpHeap0(string, bl);
    }

    private native void dumpHeap0(String var1, boolean var2) throws IOException;

    @Override
    public List<VMOption> getDiagnosticOptions() {
        List<Flag> list = Flag.getAllFlags();
        ArrayList<VMOption> arrayList = new ArrayList<VMOption>();
        for (Flag flag : list) {
            if (!flag.isWriteable() || !flag.isExternal()) continue;
            arrayList.add(flag.getVMOption());
        }
        return arrayList;
    }

    @Override
    public VMOption getVMOption(String string) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        Flag flag = Flag.getFlag(string);
        if (flag == null) {
            throw new IllegalArgumentException("VM option \"" + string + "\" does not exist");
        }
        return flag.getVMOption();
    }

    @Override
    public void setVMOption(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (string2 == null) {
            throw new NullPointerException("value cannot be null");
        }
        Util.checkControlAccess();
        Flag flag = Flag.getFlag(string);
        if (flag == null) {
            throw new IllegalArgumentException("VM option \"" + string + "\" does not exist");
        }
        if (!flag.isWriteable()) {
            throw new IllegalArgumentException("VM Option \"" + string + "\" is not writeable");
        }
        Object object = flag.getValue();
        if (object instanceof Long) {
            try {
                long l = Long.parseLong(string2);
                Flag.setLongValue(string, l);
            }
            catch (NumberFormatException numberFormatException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid value: VM Option \"" + string + "\" expects numeric value");
                illegalArgumentException.initCause(numberFormatException);
                throw illegalArgumentException;
            }
        } else if (object instanceof Boolean) {
            if (!string2.equalsIgnoreCase("true") && !string2.equalsIgnoreCase("false")) {
                throw new IllegalArgumentException("Invalid value: VM Option \"" + string + "\" expects \"true\" or \"false\".");
            }
            Flag.setBooleanValue(string, Boolean.parseBoolean(string2));
        } else if (object instanceof String) {
            Flag.setStringValue(string, string2);
        } else {
            throw new IllegalArgumentException("VM Option \"" + string + "\" is of an unsupported type: " + object.getClass().getName());
        }
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("com.sun.management:type=HotSpotDiagnostic");
    }
}

