/*
 * mutex.h
 *
 * Mutual exclusion thread synchronisation class.
 *
 * Portable Windows Library
 *
 * Copyright (c) 1993-1998 Equivalence Pty. Ltd.
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, eitF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Portable Windows Library.
 *
 * The Initial Developer of the Original Code is Equivalence Pty. Ltd.
 *
 * Portions are Copyright (C) 1993 Free Software Foundation, Inc.
 * All Rights Reserved.
 *
 * Contributor(s): ______________________________________.
 *
 * $Revision: 33488 $
 * $Author: rjongbloed $
 * $Date: 2015-04-07 11:21:59 +0100 (Tue, 07 Apr 2015) $
 */

///////////////////////////////////////////////////////////////////////////////
// PMutex

#if defined(P_PTHREADS) || defined(VX_TASKS)
  public:
    virtual ~PTimedMutex();
    static void InitialiseRecursiveMutex(pthread_mutex_t *mutex);
  protected:
    mutable pthread_mutex_t m_mutex;
    void Construct();
#endif


// End Of File ////////////////////////////////////////////////////////////////
