/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_7_1;

import java.lang.reflect.Array;
import java.util.List;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.XPCOMException;
import org.virtualbox_7_1.AccessMode;
import org.virtualbox_7_1.DeviceType;
import org.virtualbox_7_1.FirmwareType;
import org.virtualbox_7_1.Holder;
import org.virtualbox_7_1.IAppliance;
import org.virtualbox_7_1.ICloudNetwork;
import org.virtualbox_7_1.ICloudProviderManager;
import org.virtualbox_7_1.IDHCPServer;
import org.virtualbox_7_1.IEventSource;
import org.virtualbox_7_1.IExtPackManager;
import org.virtualbox_7_1.IGuestOSType;
import org.virtualbox_7_1.IHost;
import org.virtualbox_7_1.IHostOnlyNetwork;
import org.virtualbox_7_1.IMachine;
import org.virtualbox_7_1.IMedium;
import org.virtualbox_7_1.INATNetwork;
import org.virtualbox_7_1.IPerformanceCollector;
import org.virtualbox_7_1.IPlatformProperties;
import org.virtualbox_7_1.IProgress;
import org.virtualbox_7_1.ISharedFolder;
import org.virtualbox_7_1.ISystemProperties;
import org.virtualbox_7_1.IUnattended;
import org.virtualbox_7_1.MachineState;
import org.virtualbox_7_1.PlatformArchitecture;
import org.virtualbox_7_1.VBoxException;
import org.virtualbox_7_1.xpcom.Helper;
import org.virtualbox_7_1.xpcom.IUnknown;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IVirtualBox
extends IUnknown {
    public IVirtualBox(org.mozilla.interfaces.IVirtualBox iVirtualBox) {
        super(iVirtualBox);
    }

    public org.mozilla.interfaces.IVirtualBox getTypedWrapped() {
        return (org.mozilla.interfaces.IVirtualBox)this.getWrapped();
    }

    public String getVersion() {
        try {
            String string = this.getTypedWrapped().getVersion();
            return string;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public String getVersionNormalized() {
        try {
            String string = this.getTypedWrapped().getVersionNormalized();
            return string;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public Long getRevision() {
        try {
            long l = this.getTypedWrapped().getRevision();
            return l;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public String getPackageType() {
        try {
            String string = this.getTypedWrapped().getPackageType();
            return string;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public String getAPIVersion() {
        try {
            String string = this.getTypedWrapped().getAPIVersion();
            return string;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public Long getAPIRevision() {
        try {
            long l = this.getTypedWrapped().getAPIRevision();
            return l;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public String getHomeFolder() {
        try {
            String string = this.getTypedWrapped().getHomeFolder();
            return string;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public String getSettingsFilePath() {
        try {
            String string = this.getTypedWrapped().getSettingsFilePath();
            return string;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IHost getHost() {
        try {
            org.mozilla.interfaces.IHost iHost = this.getTypedWrapped().getHost();
            return iHost != null ? new IHost(iHost) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public ISystemProperties getSystemProperties() {
        try {
            org.mozilla.interfaces.ISystemProperties iSystemProperties = this.getTypedWrapped().getSystemProperties();
            return iSystemProperties != null ? new ISystemProperties(iSystemProperties) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<IMachine> getMachines() {
        try {
            org.mozilla.interfaces.IMachine[] iMachineArray = this.getTypedWrapped().getMachines(null);
            return Helper.wrap2(IMachine.class, org.mozilla.interfaces.IMachine.class, iMachineArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<String> getMachineGroups() {
        try {
            String[] stringArray = this.getTypedWrapped().getMachineGroups(null);
            return Helper.wrap(stringArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<IMedium> getHardDisks() {
        try {
            org.mozilla.interfaces.IMedium[] iMediumArray = this.getTypedWrapped().getHardDisks(null);
            return Helper.wrap2(IMedium.class, org.mozilla.interfaces.IMedium.class, iMediumArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<IMedium> getDVDImages() {
        try {
            org.mozilla.interfaces.IMedium[] iMediumArray = this.getTypedWrapped().getDVDImages(null);
            return Helper.wrap2(IMedium.class, org.mozilla.interfaces.IMedium.class, iMediumArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<IMedium> getFloppyImages() {
        try {
            org.mozilla.interfaces.IMedium[] iMediumArray = this.getTypedWrapped().getFloppyImages(null);
            return Helper.wrap2(IMedium.class, org.mozilla.interfaces.IMedium.class, iMediumArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<IProgress> getProgressOperations() {
        try {
            org.mozilla.interfaces.IProgress[] iProgressArray = this.getTypedWrapped().getProgressOperations(null);
            return Helper.wrap2(IProgress.class, org.mozilla.interfaces.IProgress.class, iProgressArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<IGuestOSType> getGuestOSTypes() {
        try {
            org.mozilla.interfaces.IGuestOSType[] iGuestOSTypeArray = this.getTypedWrapped().getGuestOSTypes(null);
            return Helper.wrap2(IGuestOSType.class, org.mozilla.interfaces.IGuestOSType.class, iGuestOSTypeArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<String> getGuestOSFamilies() {
        try {
            String[] stringArray = this.getTypedWrapped().getGuestOSFamilies(null);
            return Helper.wrap(stringArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<ISharedFolder> getSharedFolders() {
        try {
            org.mozilla.interfaces.ISharedFolder[] iSharedFolderArray = this.getTypedWrapped().getSharedFolders(null);
            return Helper.wrap2(ISharedFolder.class, org.mozilla.interfaces.ISharedFolder.class, iSharedFolderArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IPerformanceCollector getPerformanceCollector() {
        try {
            org.mozilla.interfaces.IPerformanceCollector iPerformanceCollector = this.getTypedWrapped().getPerformanceCollector();
            return iPerformanceCollector != null ? new IPerformanceCollector(iPerformanceCollector) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<IDHCPServer> getDHCPServers() {
        try {
            org.mozilla.interfaces.IDHCPServer[] iDHCPServerArray = this.getTypedWrapped().getDHCPServers(null);
            return Helper.wrap2(IDHCPServer.class, org.mozilla.interfaces.IDHCPServer.class, iDHCPServerArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<INATNetwork> getNATNetworks() {
        try {
            org.mozilla.interfaces.INATNetwork[] iNATNetworkArray = this.getTypedWrapped().getNATNetworks(null);
            return Helper.wrap2(INATNetwork.class, org.mozilla.interfaces.INATNetwork.class, iNATNetworkArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IEventSource getEventSource() {
        try {
            org.mozilla.interfaces.IEventSource iEventSource = this.getTypedWrapped().getEventSource();
            return iEventSource != null ? new IEventSource(iEventSource) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IExtPackManager getExtensionPackManager() {
        try {
            org.mozilla.interfaces.IExtPackManager iExtPackManager = this.getTypedWrapped().getExtensionPackManager();
            return iExtPackManager != null ? new IExtPackManager(iExtPackManager) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<String> getInternalNetworks() {
        try {
            String[] stringArray = this.getTypedWrapped().getInternalNetworks(null);
            return Helper.wrap(stringArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<IHostOnlyNetwork> getHostOnlyNetworks() {
        try {
            org.mozilla.interfaces.IHostOnlyNetwork[] iHostOnlyNetworkArray = this.getTypedWrapped().getHostOnlyNetworks(null);
            return Helper.wrap2(IHostOnlyNetwork.class, org.mozilla.interfaces.IHostOnlyNetwork.class, iHostOnlyNetworkArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<String> getGenericNetworkDrivers() {
        try {
            String[] stringArray = this.getTypedWrapped().getGenericNetworkDrivers(null);
            return Helper.wrap(stringArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<ICloudNetwork> getCloudNetworks() {
        try {
            org.mozilla.interfaces.ICloudNetwork[] iCloudNetworkArray = this.getTypedWrapped().getCloudNetworks(null);
            return Helper.wrap2(ICloudNetwork.class, org.mozilla.interfaces.ICloudNetwork.class, iCloudNetworkArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public ICloudProviderManager getCloudProviderManager() {
        try {
            org.mozilla.interfaces.ICloudProviderManager iCloudProviderManager = this.getTypedWrapped().getCloudProviderManager();
            return iCloudProviderManager != null ? new ICloudProviderManager(iCloudProviderManager) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public static IVirtualBox queryInterface(IUnknown iUnknown) {
        nsISupports nsISupports2;
        nsISupports nsISupports3 = nsISupports2 = iUnknown != null ? (nsISupports)iUnknown.getWrapped() : null;
        if (nsISupports2 == null) {
            return null;
        }
        org.mozilla.interfaces.IVirtualBox iVirtualBox = Helper.queryInterface(nsISupports2, "{d644ad1e-c501-4fc7-9ab6-aa6d763bc540}", org.mozilla.interfaces.IVirtualBox.class);
        return iVirtualBox == null ? null : new IVirtualBox(iVirtualBox);
    }

    public String composeMachineFilename(String string, String string2, String string3, String string4) {
        try {
            String string5 = this.getTypedWrapped().composeMachineFilename(string, string2, string3, string4);
            return string5;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IPlatformProperties getPlatformProperties(PlatformArchitecture platformArchitecture) {
        try {
            org.mozilla.interfaces.IPlatformProperties iPlatformProperties = this.getTypedWrapped().getPlatformProperties(platformArchitecture.value());
            return iPlatformProperties != null ? new IPlatformProperties(iPlatformProperties) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IMachine createMachine(String string, String string2, PlatformArchitecture platformArchitecture, List<String> list, String string3, String string4, String string5, String string6, String string7) {
        try {
            org.mozilla.interfaces.IMachine iMachine = this.getTypedWrapped().createMachine(string, string2, platformArchitecture.value(), list != null ? (long)list.size() : 0L, Helper.unwrapStr(list), string3, string4, string5, string6, string7);
            return iMachine != null ? new IMachine(iMachine) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IMachine openMachine(String string, String string2) {
        try {
            org.mozilla.interfaces.IMachine iMachine = this.getTypedWrapped().openMachine(string, string2);
            return iMachine != null ? new IMachine(iMachine) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void registerMachine(IMachine iMachine) {
        try {
            this.getTypedWrapped().registerMachine(iMachine != null ? iMachine.getTypedWrapped() : null);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IMachine findMachine(String string) {
        try {
            org.mozilla.interfaces.IMachine iMachine = this.getTypedWrapped().findMachine(string);
            return iMachine != null ? new IMachine(iMachine) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<IMachine> getMachinesByGroups(List<String> list) {
        try {
            org.mozilla.interfaces.IMachine[] iMachineArray = this.getTypedWrapped().getMachinesByGroups(list != null ? (long)list.size() : 0L, Helper.unwrapStr(list), null);
            return Helper.wrap2(IMachine.class, org.mozilla.interfaces.IMachine.class, iMachineArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<MachineState> getMachineStates(List<IMachine> list) {
        try {
            long[] lArray = this.getTypedWrapped().getMachineStates(list != null ? (long)list.size() : 0L, Helper.unwrap2(IMachine.class, org.mozilla.interfaces.IMachine.class, list), null);
            return Helper.wrapEnum(MachineState.class, lArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IAppliance createAppliance() {
        try {
            org.mozilla.interfaces.IAppliance iAppliance = this.getTypedWrapped().createAppliance();
            return iAppliance != null ? new IAppliance(iAppliance) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IUnattended createUnattendedInstaller() {
        try {
            org.mozilla.interfaces.IUnattended iUnattended = this.getTypedWrapped().createUnattendedInstaller();
            return iUnattended != null ? new IUnattended(iUnattended) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IMedium createMedium(String string, String string2, AccessMode accessMode, DeviceType deviceType) {
        try {
            org.mozilla.interfaces.IMedium iMedium = this.getTypedWrapped().createMedium(string, string2, accessMode.value(), deviceType.value());
            return iMedium != null ? new IMedium(iMedium) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IMedium openMedium(String string, DeviceType deviceType, AccessMode accessMode, Boolean bl) {
        try {
            org.mozilla.interfaces.IMedium iMedium = this.getTypedWrapped().openMedium(string, deviceType.value(), accessMode.value(), bl);
            return iMedium != null ? new IMedium(iMedium) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IGuestOSType getGuestOSType(String string) {
        try {
            org.mozilla.interfaces.IGuestOSType iGuestOSType = this.getTypedWrapped().getGuestOSType(string);
            return iGuestOSType != null ? new IGuestOSType(iGuestOSType) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<String> getGuestOSSubtypesByFamilyId(String string) {
        try {
            String[] stringArray = this.getTypedWrapped().getGuestOSSubtypesByFamilyId(string, null);
            return Helper.wrap(stringArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<String> getGuestOSDescsBySubtype(String string) {
        try {
            String[] stringArray = this.getTypedWrapped().getGuestOSDescsBySubtype(string, null);
            return Helper.wrap(stringArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void createSharedFolder(String string, String string2, Boolean bl, Boolean bl2, String string3) {
        try {
            this.getTypedWrapped().createSharedFolder(string, string2, bl, bl2, string3);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void removeSharedFolder(String string) {
        try {
            this.getTypedWrapped().removeSharedFolder(string);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public List<String> getExtraDataKeys() {
        try {
            String[] stringArray = this.getTypedWrapped().getExtraDataKeys(null);
            return Helper.wrap(stringArray);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public String getExtraData(String string) {
        try {
            String string2 = this.getTypedWrapped().getExtraData(string);
            return string2;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void setExtraData(String string, String string2) {
        try {
            this.getTypedWrapped().setExtraData(string, string2);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void setSettingsSecret(String string) {
        try {
            this.getTypedWrapped().setSettingsSecret(string);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IDHCPServer createDHCPServer(String string) {
        try {
            org.mozilla.interfaces.IDHCPServer iDHCPServer = this.getTypedWrapped().createDHCPServer(string);
            return iDHCPServer != null ? new IDHCPServer(iDHCPServer) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IDHCPServer findDHCPServerByNetworkName(String string) {
        try {
            org.mozilla.interfaces.IDHCPServer iDHCPServer = this.getTypedWrapped().findDHCPServerByNetworkName(string);
            return iDHCPServer != null ? new IDHCPServer(iDHCPServer) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void removeDHCPServer(IDHCPServer iDHCPServer) {
        try {
            this.getTypedWrapped().removeDHCPServer(iDHCPServer != null ? iDHCPServer.getTypedWrapped() : null);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public INATNetwork createNATNetwork(String string) {
        try {
            org.mozilla.interfaces.INATNetwork iNATNetwork = this.getTypedWrapped().createNATNetwork(string);
            return iNATNetwork != null ? new INATNetwork(iNATNetwork) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public INATNetwork findNATNetworkByName(String string) {
        try {
            org.mozilla.interfaces.INATNetwork iNATNetwork = this.getTypedWrapped().findNATNetworkByName(string);
            return iNATNetwork != null ? new INATNetwork(iNATNetwork) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void removeNATNetwork(INATNetwork iNATNetwork) {
        try {
            this.getTypedWrapped().removeNATNetwork(iNATNetwork != null ? iNATNetwork.getTypedWrapped() : null);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IHostOnlyNetwork createHostOnlyNetwork(String string) {
        try {
            org.mozilla.interfaces.IHostOnlyNetwork iHostOnlyNetwork = this.getTypedWrapped().createHostOnlyNetwork(string);
            return iHostOnlyNetwork != null ? new IHostOnlyNetwork(iHostOnlyNetwork) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IHostOnlyNetwork findHostOnlyNetworkByName(String string) {
        try {
            org.mozilla.interfaces.IHostOnlyNetwork iHostOnlyNetwork = this.getTypedWrapped().findHostOnlyNetworkByName(string);
            return iHostOnlyNetwork != null ? new IHostOnlyNetwork(iHostOnlyNetwork) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IHostOnlyNetwork findHostOnlyNetworkById(String string) {
        try {
            org.mozilla.interfaces.IHostOnlyNetwork iHostOnlyNetwork = this.getTypedWrapped().findHostOnlyNetworkById(string);
            return iHostOnlyNetwork != null ? new IHostOnlyNetwork(iHostOnlyNetwork) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void removeHostOnlyNetwork(IHostOnlyNetwork iHostOnlyNetwork) {
        try {
            this.getTypedWrapped().removeHostOnlyNetwork(iHostOnlyNetwork != null ? iHostOnlyNetwork.getTypedWrapped() : null);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public ICloudNetwork createCloudNetwork(String string) {
        try {
            org.mozilla.interfaces.ICloudNetwork iCloudNetwork = this.getTypedWrapped().createCloudNetwork(string);
            return iCloudNetwork != null ? new ICloudNetwork(iCloudNetwork) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public ICloudNetwork findCloudNetworkByName(String string) {
        try {
            org.mozilla.interfaces.ICloudNetwork iCloudNetwork = this.getTypedWrapped().findCloudNetworkByName(string);
            return iCloudNetwork != null ? new ICloudNetwork(iCloudNetwork) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public void removeCloudNetwork(ICloudNetwork iCloudNetwork) {
        try {
            this.getTypedWrapped().removeCloudNetwork(iCloudNetwork != null ? iCloudNetwork.getTypedWrapped() : null);
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public Boolean checkFirmwarePresent(PlatformArchitecture platformArchitecture, FirmwareType firmwareType, String string, Holder<String> holder, Holder<String> holder2) {
        try {
            String[] stringArray = (String[])Array.newInstance(String.class, 1);
            String[] stringArray2 = (String[])Array.newInstance(String.class, 1);
            boolean bl = this.getTypedWrapped().checkFirmwarePresent(platformArchitecture.value(), firmwareType.value(), string, stringArray, stringArray2);
            holder.value = stringArray[0];
            holder2.value = stringArray2[0];
            return bl;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }

    public IProgress findProgressById(String string) {
        try {
            org.mozilla.interfaces.IProgress iProgress = this.getTypedWrapped().findProgressById(string);
            return iProgress != null ? new IProgress(iProgress) : null;
        }
        catch (XPCOMException xPCOMException) {
            throw new VBoxException(xPCOMException.getMessage(), xPCOMException);
        }
    }
}

