// defaults, types, and shorthands

const {
  typeDefs: {
    semver: { type: semver },
    Umask: { type: Umask },
    url: { type: url },
    path: { type: path }
  }
} = require('@npmcli/config')

const ciDetect = require('@npmcli/ci-detect')

const isWindows = require('./is-windows.js')

const editor = process.env.EDITOR ||
  process.env.VISUAL ||
  (isWindows ? 'notepad.exe' : 'vi')

const shell = isWindows ? process.env.ComSpec || 'cmd'
  : process.env.SHELL || 'bash'

const { tmpdir, networkInterfaces } = require('os')
const getLocalAddresses = () => {
  try {
    return Object.values(networkInterfaces()).map(
      int => int.map(({ address }) => address)
    ).reduce((set, addrs) => set.concat(addrs), [undefined])
  } catch (e) {
    return [undefined]
  }
}

const unicode = /UTF-?8$/i.test(
  process.env.LC_ALL || process.env.LC_CTYPE || process.env.LANG
)

// use LOCALAPPDATA on Windows, if set
// https://github.com/npm/cli/pull/899
const cacheRoot = (isWindows && process.env.LOCALAPPDATA) || '~'
const cacheExtra = isWindows ? 'npm-cache' : '.npm'
const cache = `${cacheRoot}/${cacheExtra}`

const defaults = {
  access: null,
  all: false,
  'allow-same-version': false,
  'always-auth': false,
  also: null,
  audit: true,
  'audit-level': null,
  'auth-type': 'legacy',

  before: null,
  'bin-links': true,
  browser: null,

  ca: null,
  cafile: null,

  cache,

  'cache-lock-stale': 60000,
  'cache-lock-retries': 10,
  'cache-lock-wait': 10000,

  'cache-max': Infinity,
  'cache-min': 10,

  cert: null,

  cidr: null,

  color: process.env.NO_COLOR == null,
  call: '',
  depth: null,
  description: true,
  dev: false,
  'dry-run': false,
  editor,
  'engine-strict': false,
  force: false,
  'format-package-lock': true,

  fund: true,

  'fetch-retries': 2,
  'fetch-retry-factor': 10,
  'fetch-retry-mintimeout': 10000,
  'fetch-retry-maxtimeout': 60000,
  'fetch-timeout': 5 * 60 * 1000,

  git: 'git',
  'git-tag-version': true,
  'commit-hooks': true,

  global: false,
  'global-style': false,
  heading: 'npm',
  'if-present': false,
  include: [],
  'include-staged': false,
  'ignore-prepublish': false,
  'ignore-scripts': false,
  'init-module': '~/.npm-init.js',
  'init-author-name': '',
  'init-author-email': '',
  'init-author-url': '',
  'init-version': '1.0.0',
  'init-license': 'ISC',
  json: false,
  key: null,
  'legacy-bundling': false,
  'legacy-peer-deps': false,
  'strict-peer-deps': false,
  link: false,
  'local-address': undefined,
  loglevel: 'notice',
  'logs-max': 10,
  long: false,
  maxsockets: 50,
  message: '%s',
  'metrics-registry': null,
  'node-options': null,
  'node-version': process.version,
  offline: false,
  omit: [],
  only: null,
  optional: true,
  otp: null,
  package: [],
  'package-lock': true,
  'package-lock-only': false,
  parseable: false,
  'prefer-offline': false,
  'prefer-online': false,
  preid: '',
  production: process.env.NODE_ENV === 'production',
  progress: !ciDetect(),
  proxy: null,
  'https-proxy': null,
  noproxy: null,
  'user-agent': 'npm/{npm-version} ' +
                'node/{node-version} ' +
                '{platform} ' +
                '{arch} ' +
                '{ci}',
  'read-only': false,
  'rebuild-bundle': true,
  registry: 'https://registry.npmjs.org/',
  rollback: true,
  save: true,
  'save-bundle': false,
  'save-dev': false,
  'save-exact': false,
  'save-optional': false,
  'save-prefix': '^',
  'save-prod': false,
  scope: '',
  'script-shell': null,
  'scripts-prepend-node-path': 'warn-only',
  searchopts: '',
  searchexclude: null,
  searchlimit: 20,
  searchstaleness: 15 * 60,
  'send-metrics': false,
  shell,
  shrinkwrap: true,
  'sign-git-commit': false,
  'sign-git-tag': false,
  'sso-poll-frequency': 500,
  'sso-type': 'oauth',
  'strict-ssl': true,
  tag: 'latest',
  'tag-version-prefix': 'v',
  timing: false,
  tmp: tmpdir(),
  unicode,
  'update-notifier': true,
  usage: false,
  userconfig: '~/.npmrc',
  umask: process.umask ? process.umask() : 0o22,
  version: false,
  versions: false,
  viewer: isWindows ? 'browser' : 'man'
}

const types = {
  access: [null, 'restricted', 'public'],
  all: Boolean,
  'allow-same-version': Boolean,
  'always-auth': Boolean,
  also: [null, 'dev', 'development'],
  audit: Boolean,
  'audit-level': ['low', 'moderate', 'high', 'critical', 'none', null],
  'auth-type': ['legacy', 'sso', 'saml', 'oauth'],
  before: [null, Date],
  'bin-links': Boolean,
  browser: [null, Boolean, String],
  ca: [null, String, Array],
  cafile: path,
  cache: path,
  'cache-lock-stale': Number,
  'cache-lock-retries': Number,
  'cache-lock-wait': Number,
  'cache-max': Number,
  'cache-min': Number,
  cert: [null, String],
  cidr: [null, String, Array],
  color: ['always', Boolean],
  call: String,
  depth: [null, Number],
  description: Boolean,
  dev: Boolean,
  'dry-run': Boolean,
  editor: String,
  'engine-strict': Boolean,
  force: Boolean,
  fund: Boolean,
  'format-package-lock': Boolean,
  'fetch-retries': Number,
  'fetch-retry-factor': Number,
  'fetch-retry-mintimeout': Number,
  'fetch-retry-maxtimeout': Number,
  'fetch-timeout': Number,
  git: String,
  'git-tag-version': Boolean,
  'commit-hooks': Boolean,
  global: Boolean,
  globalconfig: path,
  'global-style': Boolean,
  group: [Number, String],
  'https-proxy': [null, url],
  'user-agent': String,
  heading: String,
  'if-present': Boolean,
  include: [Array, 'prod', 'dev', 'optional', 'peer'],
  'include-staged': Boolean,
  'ignore-prepublish': Boolean,
  'ignore-scripts': Boolean,
  'init-module': path,
  'init-author-name': String,
  'init-author-email': String,
  'init-author-url': ['', url],
  'init-license': String,
  'init-version': semver,
  json: Boolean,
  key: [null, String],
  'legacy-bundling': Boolean,
  'legacy-peer-deps': Boolean,
  'strict-peer-deps': Boolean,
  link: Boolean,
  'local-address': getLocalAddresses(),
  loglevel: [
    'silent',
    'error',
    'warn',
    'notice',
    'http',
    'timing',
    'info',
    'verbose',
    'silly'
  ],
  'logs-max': Number,
  long: Boolean,
  maxsockets: Number,
  message: String,
  'metrics-registry': [null, String],
  'node-options': [null, String],
  'node-version': [null, semver],
  noproxy: [null, String, Array],
  offline: Boolean,
  omit: [Array, 'dev', 'optional', 'peer'],
  only: [null, 'dev', 'development', 'prod', 'production'],
  optional: Boolean,
  otp: [null, String],
  package: [String, Array],
  'package-lock': Boolean,
  'package-lock-only': Boolean,
  parseable: Boolean,
  'prefer-offline': Boolean,
  'prefer-online': Boolean,
  prefix: path,
  preid: String,
  production: Boolean,
  progress: Boolean,
  proxy: [null, false, url], // allow proxy to be disabled explicitly
  'read-only': Boolean,
  'rebuild-bundle': Boolean,
  registry: [null, url],
  rollback: Boolean,
  save: Boolean,
  'save-bundle': Boolean,
  'save-dev': Boolean,
  'save-exact': Boolean,
  'save-optional': Boolean,
  'save-prefix': String,
  'save-prod': Boolean,
  scope: String,
  'script-shell': [null, String],
  'scripts-prepend-node-path': [Boolean, 'auto', 'warn-only'],
  searchopts: String,
  searchexclude: [null, String],
  searchlimit: Number,
  searchstaleness: Number,
  'send-metrics': Boolean,
  shell: String,
  shrinkwrap: Boolean,
  'sign-git-commit': Boolean,
  'sign-git-tag': Boolean,
  'sso-poll-frequency': Number,
  'sso-type': [null, 'oauth', 'saml'],
  'strict-ssl': Boolean,
  tag: String,
  timing: Boolean,
  tmp: path,
  unicode: Boolean,
  'update-notifier': Boolean,
  usage: Boolean,
  userconfig: path,
  umask: Umask,
  version: Boolean,
  'tag-version-prefix': String,
  versions: Boolean,
  viewer: String
}

const shorthands = {
  a: ['--all'],
  'enjoy-by': ['--before'],
  c: ['--call'],
  s: ['--loglevel', 'silent'],
  d: ['--loglevel', 'info'],
  dd: ['--loglevel', 'verbose'],
  ddd: ['--loglevel', 'silly'],
  noreg: ['--no-registry'],
  N: ['--no-registry'],
  reg: ['--registry'],
  'no-reg': ['--no-registry'],
  silent: ['--loglevel', 'silent'],
  verbose: ['--loglevel', 'verbose'],
  quiet: ['--loglevel', 'warn'],
  q: ['--loglevel', 'warn'],
  h: ['--usage'],
  H: ['--usage'],
  '?': ['--usage'],
  help: ['--usage'],
  v: ['--version'],
  f: ['--force'],
  desc: ['--description'],
  'no-desc': ['--no-description'],
  local: ['--no-global'],
  l: ['--long'],
  m: ['--message'],
  p: ['--parseable'],
  porcelain: ['--parseable'],
  readonly: ['--read-only'],
  g: ['--global'],
  S: ['--save'],
  D: ['--save-dev'],
  E: ['--save-exact'],
  O: ['--save-optional'],
  P: ['--save-prod'],
  y: ['--yes'],
  n: ['--no-yes'],
  B: ['--save-bundle'],
  C: ['--prefix']
}

module.exports = { defaults, types, shorthands }
