/* 
 * Copyright (c) 2009, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef __FINDDIALOGBE_H__
#define __FINDDIALOGBE_H__

#include "wb_config.h"

#include "workbench/wb_find_dialog.h"
#include "GrtTemplates.h"

#ifdef _MSC_VER
using namespace MySQL::Grt;
using namespace System;
using namespace System::Collections::Generic;
#endif

namespace MySQL {
namespace Workbench {


  public enum class FindResult
  {
    NotFound= ::wb::NotFound,
    FoundMatch= ::wb::FoundMatch,
    NoMoreMatches= ::wb::NoMoreMatches
  };




  public ref class FindDialogBE
  {
  public:
    FindDialogBE(::wb::FindDialogBE *be)
      : inner(be)
    {
    }

    void set_text(String ^text)
    {
      inner->set_text(NativeToCppString(text));
    }


    void set_match_case(bool flag)
    {
      inner->set_match_case(flag);
    }


    void set_search_in_comments(bool flag)
    {
      inner->set_search_in_comments(flag);
    }

    void set_search_in_sql(bool flag)
    {
      inner->set_search_in_sql(flag);
    }

    FindResult find_next()
    {
      return (FindResult)inner->find_next();
    }

    FindResult find_previous()
    {
      return (FindResult)inner->find_previous();
    }


  protected:
    ::wb::FindDialogBE *inner;
  };

} // namespace Workbench
} // namespace MySQL



#endif // __FINDDIALOGBE_H__
