/**
 * Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_TOOLBAR_H_
#define _WF_TOOLBAR_H_

using namespace System;
using namespace System::Windows::Forms::Layout;

namespace MySQL {
  namespace Forms {

    ref class MformsToolStrip;

    /**
     * Specialized separator item that makes all following items appear right aligned.
     */
    private ref class ToolStripExpander : public ToolStripSeparator
    {

    };

    /**
     * Specialized button that visually forms a group with neighbor segmented buttons
     * without any spacing between them, appearing so as one big button with several areas.
     */
    private ref class ToolStripSegmentedButton : public ToolStripButton
    {
    };
      
    /**
     * Custom layout engine to allow to use expander and segmented tool strip items.
     * This engine only supports horizontal toolstrips.
     */
    private ref class MformsToolStripLayout : public LayoutEngine
    {
    public:
      System::Drawing::Size ComputeLayout(MformsToolStrip^ toolstrip, System::Drawing::Size proposedSize,
        bool preferredSizeOnly);
      virtual bool Layout(Object^ container, LayoutEventArgs^ arguments) override;
    };

    private ref class MformsToolStrip : public ToolStrip
    {
    private:
      MformsToolStripLayout^ layoutEngine;
    public:
      virtual System::Drawing::Size GetPreferredSize(System::Drawing::Size proposedSize) override;
      void ApplyLocation(ToolStripItem^ item, Point location);

      virtual property Windows::Forms::Layout::LayoutEngine^ LayoutEngine
      {
        Windows::Forms::Layout::LayoutEngine^ get() override
        {
          if (layoutEngine == nullptr)
            layoutEngine = gcnew MformsToolStripLayout();
          return layoutEngine;
        }
      }

    };

    /**
     * Managed wrapper for an mforms ToolBarItem.
     */
    public ref class ToolBarItemImpl : public ObjectImpl
    {
    private:
      Image^ normalImage;
      Image^ activeImage;

      void UpdateItemImage();
    public:
      ToolBarItemImpl(mforms::ToolBarItem* item);
      ~ToolBarItemImpl();
      
      void set_item_checked(bool state);
      void focus();
        
      void OnItemActivation(Object^ sender, System::EventArgs^ e);
      void OnColorItemActivation(Object^ sender, System::EventArgs^ e);
      void OnKeyPress(Object^ sender, KeyPressEventArgs^ e);

      property Image^ NormalImage
      {
        Image^ get() { return normalImage; }
        void set(Image^ value)
        {
          normalImage = value;
          UpdateItemImage();
        }
      }

      property Image^ ActiveImage
      {
        Image^ get() { return activeImage; }
        void set(Image^ value)
        {
          activeImage = value;
          UpdateItemImage();
        }
      }

    };

    /**
     * Managed wrapper for an mforms ToolBar.
     */
    public ref class ToolBarImpl : public ViewImpl
    {
    protected:
      ToolBarImpl(mforms::ToolBar* toolbar);
      ~ToolBarImpl();

      static bool create_tool_bar(mforms::ToolBar* item, mforms::ToolBarType type);
      static void insert_item(mforms::ToolBar* toolbar, int index, mforms::ToolBarItem* item);
      static void remove_item(mforms::ToolBar* toolbar, mforms::ToolBarItem* item);

      static bool create_tool_item(mforms::ToolBarItem* item, mforms::ToolBarItemType type);
      static void set_item_icon(mforms::ToolBarItem* item, const std::string& path);
      static void set_item_alt_icon(mforms::ToolBarItem* item, const std::string& path);
      static void set_item_text(mforms::ToolBarItem* item, const std::string& text);
      static std::string get_item_text(mforms::ToolBarItem* item);
      static void set_item_enabled(mforms::ToolBarItem* item, bool state);
      static bool get_item_enabled(mforms::ToolBarItem* item);
      static void set_item_checked(mforms::ToolBarItem* item, bool state);
      static bool get_item_checked(mforms::ToolBarItem* item);
      static void set_item_tooltip(mforms::ToolBarItem* item, const std::string& text);

      // For selector items only.
      static void set_selector_items(mforms::ToolBarItem* item, const std::vector<std::string>& values);

      static Bitmap^ create_color_image(String^ color);
    public:
      static void init(Manager^ mgr)
      {
        mforms::ControlFactory* f= mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, mforms::ToolBar*, mforms::ToolBarType, mgr, f->_tool_bar_impl, ToolBarImpl, create_tool_bar);
        DEF_CALLBACK3(void, mforms::ToolBar*, int, mforms::ToolBarItem*, mgr, f->_tool_bar_impl, ToolBarImpl, insert_item);
        DEF_CALLBACK2(void, mforms::ToolBar*, mforms::ToolBarItem*, mgr, f->_tool_bar_impl, ToolBarImpl, remove_item);
        DEF_CALLBACK2(bool, mforms::ToolBarItem*, mforms::ToolBarItemType, mgr, f->_tool_bar_impl, ToolBarImpl, create_tool_item);
        DEF_CALLBACK2(void, mforms::ToolBarItem*, const std::string&, mgr, f->_tool_bar_impl, ToolBarImpl, set_item_icon);
        DEF_CALLBACK2(void, mforms::ToolBarItem*, const std::string&, mgr, f->_tool_bar_impl, ToolBarImpl, set_item_alt_icon);
        DEF_CALLBACK2(void, mforms::ToolBarItem*, const std::string&, mgr, f->_tool_bar_impl, ToolBarImpl, set_item_text);
        DEF_CALLBACK1(std::string, mforms::ToolBarItem*, mgr, f->_tool_bar_impl, ToolBarImpl, get_item_text);
        DEF_CALLBACK2(void, mforms::ToolBarItem*, bool, mgr, f->_tool_bar_impl, ToolBarImpl, set_item_enabled);
        DEF_CALLBACK1(bool, mforms::ToolBarItem*, mgr, f->_tool_bar_impl, ToolBarImpl, get_item_enabled);
        DEF_CALLBACK2(void, mforms::ToolBarItem*, bool, mgr, f->_tool_bar_impl, ToolBarImpl, set_item_checked);
        DEF_CALLBACK1(bool, mforms::ToolBarItem*, mgr, f->_tool_bar_impl, ToolBarImpl, get_item_checked);
        DEF_CALLBACK2(void, mforms::ToolBarItem*, const std::string&, mgr, f->_tool_bar_impl, ToolBarImpl, set_item_tooltip);
        DEF_CALLBACK2(void, mforms::ToolBarItem*, const std::vector<std::string>&, mgr, f->_tool_bar_impl, ToolBarImpl, set_selector_items);
      }
    };

  };
};

#endif // _WF_TOOLBAR_H_
