/* 
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _MFORMS_IMAGEBOX_H_
#define _MFORMS_IMAGEBOX_H_

#include <mforms/base.h>
#include <mforms/view.h>

namespace mforms 
{
  class ImageBox;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#ifndef SWIG
  struct ImageBoxImplPtrs
  {
    bool (__stdcall *create)(ImageBox *);
    void (__stdcall *set_image)(ImageBox *, const std::string&);
    void (__stdcall *set_scale_contents)(ImageBox *, bool);
    void (__stdcall *set_image_align)(ImageBox *, Alignment);
  };
#endif
#endif

  /** Shows an image file. */
  class MFORMS_EXPORT ImageBox : public View
  {
  public:
    ImageBox();
    
    /** Sets the path to the image file. 
     
     Image formats accepted depend on platform, but usually png and jpeg will work. */
    void set_image(const std::string &file);

    /** Whether image should be scaled to fit the imagebox. */
    void set_scale_contents(bool flag);

    /** How the image should be aligned in case there's space left in the image box */
    void set_image_align(Alignment alignment);

  protected:
    ImageBoxImplPtrs *_imagebox_impl;
  };
};

#endif
