/* 
 * Copyright (c) 2007, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef __MODELVIEWFORM_H__
#define __MODELVIEWFORM_H__

#include "model/wb_model_diagram_form.h"
#include "GrtTemplates.h"

using namespace System::Collections::Generic;
using namespace System::Windows::Forms;

using namespace Aga::Controls::Tree;

namespace MySQL {
  namespace Workbench {

    public ref class ModelDiagramFormWrapper : public MySQL::Base::UIForm
    {
      MySQL::GUI::Mdc::BaseWindowsCanvasView^ mini_view;

    public:
      ModelDiagramFormWrapper(wb::ModelDiagramForm *inn);
      ~ModelDiagramFormWrapper();

      wb::ModelDiagramForm* get_unmanaged_object();

      void OnMouseMove(MouseEventArgs^ e, int X, int Y, Keys keystate, MouseButtons buttons);
      void OnMouseDown(MouseEventArgs^ e, int X, int Y, Keys keystate, MouseButtons buttons);
      void OnMouseUp(MouseEventArgs^ e, int X, int Y, Keys keystate, MouseButtons buttons);
      void OnMouseDoubleClick(MouseEventArgs^ e, int X, int Y, Keys keystate, MouseButtons buttons);
      void OnKeyDown(KeyEventArgs^ e, Keys keystate);
      void OnKeyUp(KeyEventArgs^ e, Keys keystate);
      
      String^ get_tool_cursor();
      
      bool accepts_drop(int x, int y, String^ type, List<MySQL::Grt::GrtValue^>^ objects);
      bool accepts_drop(int x, int y, String^ type, String^ text);
      bool perform_drop(int x, int y, String^ type, List<MySQL::Grt::GrtValue^>^ objects);
      bool perform_drop(int x, int y, String^ type, String^ text);

      void set_closed(bool flag);
      bool is_closed();
      void setup_mini_view(MySQL::GUI::Mdc::BaseWindowsCanvasView^ view);
      void update_mini_view_size(int w, int h);
      void update_options_toolbar();
      
      double get_zoom();
      void set_zoom(double zoom);

      String^ get_title();
      ToolStrip^ get_tools_toolbar();
      ToolStrip^ get_options_toolbar();
      TreeViewAdv^ get_layer_tree();
    };

  } // namespace Workbench
} // namespace MySQL

#endif // __MODELVIEWFORM_H__
