/* 
 * Copyright (c) 2007, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

using namespace System;
using namespace System::Collections::Generic;

#include "ConvUtils.h"
#include "GrtTemplates.h"
#include "DelegateWrapper.h"
#include "IconManager.h"
#include "Grt.h"
#include "ModelWrappers.h"
#include "var_grid_model_wr.h"
#include "ActionList.h"
#include "GrtThreadedTaskWrapper.h"

#include "recordset_wr.h"

#include "mforms/menubar.h"

using namespace MySQL::Grt;
using namespace MySQL::Grt::Db;

//--------------------------------------------------------------------------------------------------

RecordsetWrapper::RecordsetWrapper(Ref ref)
  : VarGridModelWrapper(Ref_N2M<::VarGridModel>(&ref)), _ref(ref), 
  task(gcnew GrtThreadedTaskWrapper(_ref->task.get())), action_list(gcnew ActionList(&_ref->action_list()))
{
  _refresh_ui_status_bar_conn= new boost::signals2::connection();
}

//--------------------------------------------------------------------------------------------------

RecordsetWrapper::RecordsetWrapper(IntPtr nref_ptr)
  : _ref(gcnew ManagedRef<::Recordset>(nref_ptr)), VarGridModelWrapper(Ref_N2M<::VarGridModel>(&_ref)),
  task(gcnew GrtThreadedTaskWrapper(_ref->task.get())), action_list(gcnew ActionList(&_ref->action_list()))
{
  _refresh_ui_status_bar_conn= new boost::signals2::connection();
}

//--------------------------------------------------------------------------------------------------

RecordsetWrapper::~RecordsetWrapper()
{
  if (!(void*)~_ref)
    return;
  _refresh_ui_status_bar_conn->disconnect();
  delete _refresh_ui_status_bar_conn;
  _refresh_ui_status_bar_conn = nullptr;
  delete _refresh_ui_status_bar_cb;
  _refresh_ui_status_bar_cb = nullptr;
  delete action_list;
  delete task;
  delete _ref;
}

//--------------------------------------------------------------------------------------------------

void RecordsetWrapper::refresh_ui_status_bar_cb(Refresh_ui_cb::ManagedDelegate ^cb)
{
  if (_refresh_ui_status_bar_conn != nullptr)
    _refresh_ui_status_bar_conn->disconnect();
  
  if (cb != nullptr)
  {
    _refresh_ui_status_bar_cb= gcnew Refresh_ui_cb(cb);
    *_refresh_ui_status_bar_conn = _ref->refresh_ui_status_bar_signal.connect(_refresh_ui_status_bar_cb->get_slot());
  }
  else
    _refresh_ui_status_bar_cb= nullptr;
}

//--------------------------------------------------------------------------------------------------

void RecordsetWrapper::pending_changes(int %upd_count, int %ins_count, int %del_count)
{
  int upd_count_, ins_count_, del_count_;
  _ref->pending_changes(upd_count_, ins_count_, del_count_);
  upd_count=upd_count_; ins_count=ins_count_; del_count=del_count_;
}

//--------------------------------------------------------------------------------------------------

void RecordsetWrapper::copy_rows_to_clipboard(List<int> ^indexes)
{
  std::vector<int> row_indexes = IntListToCppVector(indexes);
  _ref->copy_rows_to_clipboard(row_indexes);
}

//--------------------------------------------------------------------------------------------------

List<MySQL::Base::ToolbarItem^> ^RecordsetWrapper::get_toolbar_items()
{
  bec::ToolbarItemList items = _ref->get_toolbar_items();
  return CppVectorToObjectList<bec::ToolbarItem, MySQL::Base::ToolbarItem>(items);
}

//--------------------------------------------------------------------------------------------------

ContextMenuStrip ^RecordsetWrapper::get_context_menu(List<int> ^indexes, int clicked_column)
{
  std::vector<int> row_indexes = IntListToCppVector(indexes);
  _ref->update_selection_for_menu(row_indexes, clicked_column);
  return dynamic_cast<ContextMenuStrip^>(MySQL::Forms::MenuBarImpl::GetNativeControl(_ref->get_context_menu()));
}

//--------------------------------------------------------------------------------------------------

bool RecordsetWrapper::delete_nodes(List<NodeId^> ^nodes)
{
  std::vector<bec::NodeId> nodes_= convert_node_list(nodes);
  return _ref->delete_nodes(nodes_);
}

//--------------------------------------------------------------------------------------------------
