# coding: utf-8
# Modified Work: Copyright (c) 2018, 2021, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# Original Work: Copyright (c) 2018 Character Encoding Detector contributors.  https://github.com/chardet

#!/usr/bin/env python
# -*- coding: utf-8 -*-

from .sbcharsetprober import SingleByteCharSetModel


# 3: Positive
# 2: Likely
# 1: Unlikely
# 0: Negative

HUNGARIAN_LANG_MODEL = {
    28: {  # 'A'
        28: 0,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 2,  # 'D'
        32: 1,  # 'E'
        50: 1,  # 'F'
        49: 2,  # 'G'
        38: 1,  # 'H'
        39: 2,  # 'I'
        53: 1,  # 'J'
        36: 2,  # 'K'
        41: 2,  # 'L'
        34: 1,  # 'M'
        35: 2,  # 'N'
        47: 1,  # 'O'
        46: 2,  # 'P'
        43: 2,  # 'R'
        33: 2,  # 'S'
        37: 2,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 1,  # 'Y'
        52: 2,  # 'Z'
        2: 0,  # 'a'
        18: 1,  # 'b'
        26: 1,  # 'c'
        17: 2,  # 'd'
        1: 1,  # 'e'
        27: 1,  # 'f'
        12: 1,  # 'g'
        20: 1,  # 'h'
        9: 1,  # 'i'
        22: 1,  # 'j'
        7: 2,  # 'k'
        6: 2,  # 'l'
        13: 2,  # 'm'
        4: 2,  # 'n'
        8: 0,  # 'o'
        23: 2,  # 'p'
        10: 2,  # 'r'
        5: 1,  # 's'
        3: 1,  # 't'
        21: 1,  # 'u'
        19: 1,  # 'v'
        62: 1,  # 'x'
        16: 0,  # 'y'
        11: 3,  # 'z'
        51: 1,  # 'Á'
        44: 0,  # 'É'
        61: 1,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    40: {  # 'B'
        28: 2,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 2,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 1,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 0,  # 'M'
        35: 1,  # 'N'
        47: 2,  # 'O'
        46: 0,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 2,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 3,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 0,  # 'h'
        9: 2,  # 'i'
        22: 1,  # 'j'
        7: 0,  # 'k'
        6: 1,  # 'l'
        13: 0,  # 'm'
        4: 0,  # 'n'
        8: 2,  # 'o'
        23: 1,  # 'p'
        10: 2,  # 'r'
        5: 0,  # 's'
        3: 0,  # 't'
        21: 3,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 0,  # 'z'
        51: 1,  # 'Á'
        44: 1,  # 'É'
        61: 1,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 2,  # 'á'
        15: 2,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 1,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 1,  # 'ő'
        56: 1,  # 'ű'
    },
    54: {  # 'C'
        28: 1,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 1,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 1,  # 'H'
        39: 2,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 0,  # 'N'
        47: 1,  # 'O'
        46: 1,  # 'P'
        43: 1,  # 'R'
        33: 2,  # 'S'
        37: 1,  # 'T'
        57: 1,  # 'U'
        48: 0,  # 'V'
        55: 1,  # 'Y'
        52: 1,  # 'Z'
        2: 2,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 1,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 1,  # 'h'
        9: 1,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 1,  # 'l'
        13: 0,  # 'm'
        4: 0,  # 'n'
        8: 2,  # 'o'
        23: 0,  # 'p'
        10: 1,  # 'r'
        5: 3,  # 's'
        3: 0,  # 't'
        21: 1,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 1,  # 'z'
        51: 1,  # 'Á'
        44: 1,  # 'É'
        61: 1,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 1,  # 'á'
        15: 1,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    45: {  # 'D'
        28: 2,  # 'A'
        40: 1,  # 'B'
        54: 0,  # 'C'
        45: 1,  # 'D'
        32: 2,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 2,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 0,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 2,  # 'O'
        46: 0,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 1,  # 'Y'
        52: 1,  # 'Z'
        2: 2,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 3,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 0,  # 'h'
        9: 1,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 0,  # 'l'
        13: 0,  # 'm'
        4: 0,  # 'n'
        8: 1,  # 'o'
        23: 0,  # 'p'
        10: 2,  # 'r'
        5: 0,  # 's'
        3: 0,  # 't'
        21: 2,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 1,  # 'z'
        51: 1,  # 'Á'
        44: 1,  # 'É'
        61: 1,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 1,  # 'á'
        15: 1,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 1,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 1,  # 'ő'
        56: 0,  # 'ű'
    },
    32: {  # 'E'
        28: 1,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 1,  # 'E'
        50: 1,  # 'F'
        49: 2,  # 'G'
        38: 1,  # 'H'
        39: 1,  # 'I'
        53: 1,  # 'J'
        36: 2,  # 'K'
        41: 2,  # 'L'
        34: 2,  # 'M'
        35: 2,  # 'N'
        47: 1,  # 'O'
        46: 1,  # 'P'
        43: 2,  # 'R'
        33: 2,  # 'S'
        37: 2,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 1,  # 'Y'
        52: 1,  # 'Z'
        2: 1,  # 'a'
        18: 1,  # 'b'
        26: 1,  # 'c'
        17: 2,  # 'd'
        1: 1,  # 'e'
        27: 1,  # 'f'
        12: 3,  # 'g'
        20: 1,  # 'h'
        9: 1,  # 'i'
        22: 1,  # 'j'
        7: 1,  # 'k'
        6: 2,  # 'l'
        13: 2,  # 'm'
        4: 2,  # 'n'
        8: 0,  # 'o'
        23: 1,  # 'p'
        10: 2,  # 'r'
        5: 2,  # 's'
        3: 1,  # 't'
        21: 2,  # 'u'
        19: 1,  # 'v'
        62: 1,  # 'x'
        16: 0,  # 'y'
        11: 3,  # 'z'
        51: 1,  # 'Á'
        44: 1,  # 'É'
        61: 0,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 0,  # 'Ú'
        63: 1,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 1,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    50: {  # 'F'
        28: 1,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 1,  # 'E'
        50: 1,  # 'F'
        49: 0,  # 'G'
        38: 1,  # 'H'
        39: 1,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 1,  # 'O'
        46: 0,  # 'P'
        43: 1,  # 'R'
        33: 0,  # 'S'
        37: 1,  # 'T'
        57: 1,  # 'U'
        48: 0,  # 'V'
        55: 1,  # 'Y'
        52: 0,  # 'Z'
        2: 2,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 2,  # 'e'
        27: 1,  # 'f'
        12: 0,  # 'g'
        20: 0,  # 'h'
        9: 2,  # 'i'
        22: 1,  # 'j'
        7: 0,  # 'k'
        6: 1,  # 'l'
        13: 0,  # 'm'
        4: 0,  # 'n'
        8: 2,  # 'o'
        23: 0,  # 'p'
        10: 2,  # 'r'
        5: 0,  # 's'
        3: 0,  # 't'
        21: 1,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 0,  # 'z'
        51: 1,  # 'Á'
        44: 1,  # 'É'
        61: 0,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 0,  # 'Ú'
        63: 1,  # 'Ü'
        14: 1,  # 'á'
        15: 1,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 2,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 1,  # 'ő'
        56: 1,  # 'ű'
    },
    49: {  # 'G'
        28: 2,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 2,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 1,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 1,  # 'O'
        46: 1,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 2,  # 'Y'
        52: 1,  # 'Z'
        2: 2,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 2,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 0,  # 'h'
        9: 1,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 1,  # 'l'
        13: 0,  # 'm'
        4: 0,  # 'n'
        8: 2,  # 'o'
        23: 0,  # 'p'
        10: 2,  # 'r'
        5: 0,  # 's'
        3: 0,  # 't'
        21: 1,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 2,  # 'y'
        11: 0,  # 'z'
        51: 1,  # 'Á'
        44: 1,  # 'É'
        61: 1,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 1,  # 'á'
        15: 1,  # 'é'
        30: 0,  # 'í'
        25: 1,  # 'ó'
        24: 1,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 1,  # 'ő'
        56: 0,  # 'ű'
    },
    38: {  # 'H'
        28: 2,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 0,  # 'D'
        32: 1,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 1,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 1,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 1,  # 'O'
        46: 0,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 1,  # 'U'
        48: 0,  # 'V'
        55: 1,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 2,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 0,  # 'h'
        9: 2,  # 'i'
        22: 1,  # 'j'
        7: 0,  # 'k'
        6: 1,  # 'l'
        13: 1,  # 'm'
        4: 0,  # 'n'
        8: 3,  # 'o'
        23: 0,  # 'p'
        10: 1,  # 'r'
        5: 0,  # 's'
        3: 0,  # 't'
        21: 2,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 0,  # 'z'
        51: 2,  # 'Á'
        44: 2,  # 'É'
        61: 1,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 2,  # 'á'
        15: 1,  # 'é'
        30: 2,  # 'í'
        25: 1,  # 'ó'
        24: 1,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 1,  # 'ő'
        56: 1,  # 'ű'
    },
    39: {  # 'I'
        28: 2,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 1,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 2,  # 'I'
        53: 1,  # 'J'
        36: 2,  # 'K'
        41: 2,  # 'L'
        34: 1,  # 'M'
        35: 2,  # 'N'
        47: 1,  # 'O'
        46: 1,  # 'P'
        43: 1,  # 'R'
        33: 2,  # 'S'
        37: 1,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 0,  # 'Y'
        52: 2,  # 'Z'
        2: 0,  # 'a'
        18: 1,  # 'b'
        26: 1,  # 'c'
        17: 2,  # 'd'
        1: 0,  # 'e'
        27: 1,  # 'f'
        12: 2,  # 'g'
        20: 1,  # 'h'
        9: 0,  # 'i'
        22: 1,  # 'j'
        7: 1,  # 'k'
        6: 2,  # 'l'
        13: 2,  # 'm'
        4: 1,  # 'n'
        8: 0,  # 'o'
        23: 1,  # 'p'
        10: 2,  # 'r'
        5: 2,  # 's'
        3: 2,  # 't'
        21: 0,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 1,  # 'z'
        51: 1,  # 'Á'
        44: 1,  # 'É'
        61: 0,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    53: {  # 'J'
        28: 2,  # 'A'
        40: 0,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 2,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 1,  # 'H'
        39: 1,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 1,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 1,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 1,  # 'Z'
        2: 2,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 2,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 0,  # 'h'
        9: 1,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 0,  # 'l'
        13: 0,  # 'm'
        4: 0,  # 'n'
        8: 1,  # 'o'
        23: 0,  # 'p'
        10: 0,  # 'r'
        5: 0,  # 's'
        3: 0,  # 't'
        21: 2,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 0,  # 'z'
        51: 1,  # 'Á'
        44: 1,  # 'É'
        61: 0,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 2,  # 'á'
        15: 1,  # 'é'
        30: 0,  # 'í'
        25: 2,  # 'ó'
        24: 2,  # 'ö'
        31: 1,  # 'ú'
        29: 0,  # 'ü'
        42: 1,  # 'ő'
        56: 0,  # 'ű'
    },
    36: {  # 'K'
        28: 2,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 2,  # 'E'
        50: 1,  # 'F'
        49: 0,  # 'G'
        38: 1,  # 'H'
        39: 2,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 2,  # 'O'
        46: 0,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 1,  # 'Y'
        52: 0,  # 'Z'
        2: 2,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 2,  # 'e'
        27: 1,  # 'f'
        12: 0,  # 'g'
        20: 1,  # 'h'
        9: 3,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 1,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        8: 2,  # 'o'
        23: 0,  # 'p'
        10: 2,  # 'r'
        5: 0,  # 's'
        3: 0,  # 't'
        21: 1,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 0,  # 'z'
        51: 1,  # 'Á'
        44: 1,  # 'É'
        61: 1,  # 'Í'
        58: 1,  # 'Ó'
        59: 2,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 2,  # 'á'
        15: 2,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 2,  # 'ö'
        31: 1,  # 'ú'
        29: 2,  # 'ü'
        42: 1,  # 'ő'
        56: 0,  # 'ű'
    },
    41: {  # 'L'
        28: 2,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 2,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 2,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 2,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 2,  # 'O'
        46: 0,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 2,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 1,  # 'Y'
        52: 1,  # 'Z'
        2: 2,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 3,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 0,  # 'h'
        9: 2,  # 'i'
        22: 1,  # 'j'
        7: 0,  # 'k'
        6: 1,  # 'l'
        13: 0,  # 'm'
        4: 0,  # 'n'
        8: 2,  # 'o'
        23: 0,  # 'p'
        10: 0,  # 'r'
        5: 0,  # 's'
        3: 0,  # 't'
        21: 2,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 0,  # 'z'
        51: 2,  # 'Á'
        44: 1,  # 'É'
        61: 1,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 2,  # 'á'
        15: 1,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 1,  # 'ö'
        31: 0,  # 'ú'
        29: 1,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    34: {  # 'M'
        28: 2,  # 'A'
        40: 1,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 2,  # 'E'
        50: 1,  # 'F'
        49: 0,  # 'G'
        38: 1,  # 'H'
        39: 2,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 1,  # 'O'
        46: 1,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 1,  # 'Y'
        52: 1,  # 'Z'
        2: 3,  # 'a'
        18: 0,  # 'b'
        26: 1,  # 'c'
        17: 0,  # 'd'
        1: 3,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 0,  # 'h'
        9: 3,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 0,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        8: 3,  # 'o'
        23: 0,  # 'p'
        10: 1,  # 'r'
        5: 0,  # 's'
        3: 0,  # 't'
        21: 2,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 0,  # 'z'
        51: 2,  # 'Á'
        44: 1,  # 'É'
        61: 1,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 2,  # 'á'
        15: 2,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 1,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 0,  # 'ő'
        56: 1,  # 'ű'
    },
    35: {  # 'N'
        28: 2,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 2,  # 'D'
        32: 2,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 1,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 1,  # 'O'
        46: 1,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 2,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 2,  # 'Y'
        52: 1,  # 'Z'
        2: 3,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 3,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 0,  # 'h'
        9: 2,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 0,  # 'l'
        13: 0,  # 'm'
        4: 1,  # 'n'
        8: 2,  # 'o'
        23: 0,  # 'p'
        10: 0,  # 'r'
        5: 0,  # 's'
        3: 0,  # 't'
        21: 1,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 2,  # 'y'
        11: 0,  # 'z'
        51: 1,  # 'Á'
        44: 1,  # 'É'
        61: 1,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 1,  # 'á'
        15: 2,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 1,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 1,  # 'ő'
        56: 0,  # 'ű'
    },
    47: {  # 'O'
        28: 1,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 1,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 1,  # 'I'
        53: 1,  # 'J'
        36: 2,  # 'K'
        41: 2,  # 'L'
        34: 2,  # 'M'
        35: 2,  # 'N'
        47: 1,  # 'O'
        46: 1,  # 'P'
        43: 2,  # 'R'
        33: 2,  # 'S'
        37: 2,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 1,  # 'Y'
        52: 1,  # 'Z'
        2: 0,  # 'a'
        18: 1,  # 'b'
        26: 1,  # 'c'
        17: 1,  # 'd'
        1: 1,  # 'e'
        27: 1,  # 'f'
        12: 1,  # 'g'
        20: 1,  # 'h'
        9: 1,  # 'i'
        22: 1,  # 'j'
        7: 2,  # 'k'
        6: 2,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        8: 1,  # 'o'
        23: 1,  # 'p'
        10: 2,  # 'r'
        5: 1,  # 's'
        3: 2,  # 't'
        21: 1,  # 'u'
        19: 0,  # 'v'
        62: 1,  # 'x'
        16: 0,  # 'y'
        11: 1,  # 'z'
        51: 1,  # 'Á'
        44: 1,  # 'É'
        61: 0,  # 'Í'
        58: 1,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    46: {  # 'P'
        28: 1,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 1,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 1,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 0,  # 'M'
        35: 1,  # 'N'
        47: 1,  # 'O'
        46: 1,  # 'P'
        43: 2,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 0,  # 'Y'
        52: 1,  # 'Z'
        2: 2,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 2,  # 'e'
        27: 1,  # 'f'
        12: 0,  # 'g'
        20: 1,  # 'h'
        9: 2,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 1,  # 'l'
        13: 0,  # 'm'
        4: 1,  # 'n'
        8: 2,  # 'o'
        23: 0,  # 'p'
        10: 2,  # 'r'
        5: 1,  # 's'
        3: 0,  # 't'
        21: 1,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 0,  # 'z'
        51: 2,  # 'Á'
        44: 1,  # 'É'
        61: 1,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 0,  # 'Ú'
        63: 1,  # 'Ü'
        14: 3,  # 'á'
        15: 2,  # 'é'
        30: 0,  # 'í'
        25: 1,  # 'ó'
        24: 1,  # 'ö'
        31: 0,  # 'ú'
        29: 1,  # 'ü'
        42: 1,  # 'ő'
        56: 0,  # 'ű'
    },
    43: {  # 'R'
        28: 2,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 2,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 2,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 2,  # 'O'
        46: 1,  # 'P'
        43: 1,  # 'R'
        33: 2,  # 'S'
        37: 2,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 1,  # 'Y'
        52: 1,  # 'Z'
        2: 2,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 2,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 1,  # 'h'
        9: 2,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 0,  # 'l'
        13: 0,  # 'm'
        4: 0,  # 'n'
        8: 2,  # 'o'
        23: 0,  # 'p'
        10: 0,  # 'r'
        5: 0,  # 's'
        3: 0,  # 't'
        21: 1,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 0,  # 'z'
        51: 2,  # 'Á'
        44: 1,  # 'É'
        61: 1,  # 'Í'
        58: 2,  # 'Ó'
        59: 1,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 2,  # 'á'
        15: 2,  # 'é'
        30: 1,  # 'í'
        25: 2,  # 'ó'
        24: 1,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    33: {  # 'S'
        28: 2,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 2,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 2,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 2,  # 'O'
        46: 1,  # 'P'
        43: 1,  # 'R'
        33: 2,  # 'S'
        37: 2,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 1,  # 'Y'
        52: 3,  # 'Z'
        2: 2,  # 'a'
        18: 0,  # 'b'
        26: 1,  # 'c'
        17: 0,  # 'd'
        1: 2,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 1,  # 'h'
        9: 2,  # 'i'
        22: 0,  # 'j'
        7: 1,  # 'k'
        6: 1,  # 'l'
        13: 1,  # 'm'
        4: 0,  # 'n'
        8: 2,  # 'o'
        23: 1,  # 'p'
        10: 0,  # 'r'
        5: 0,  # 's'
        3: 1,  # 't'
        21: 1,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 3,  # 'z'
        51: 2,  # 'Á'
        44: 1,  # 'É'
        61: 1,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 2,  # 'á'
        15: 1,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 1,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 1,  # 'ő'
        56: 1,  # 'ű'
    },
    37: {  # 'T'
        28: 2,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 2,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 2,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 2,  # 'O'
        46: 1,  # 'P'
        43: 2,  # 'R'
        33: 1,  # 'S'
        37: 2,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 1,  # 'Y'
        52: 1,  # 'Z'
        2: 2,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 2,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 1,  # 'h'
        9: 2,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 0,  # 'l'
        13: 0,  # 'm'
        4: 0,  # 'n'
        8: 2,  # 'o'
        23: 0,  # 'p'
        10: 1,  # 'r'
        5: 1,  # 's'
        3: 0,  # 't'
        21: 2,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 1,  # 'z'
        51: 2,  # 'Á'
        44: 2,  # 'É'
        61: 1,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 2,  # 'á'
        15: 1,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 2,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 1,  # 'ő'
        56: 1,  # 'ű'
    },
    57: {  # 'U'
        28: 1,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 1,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 1,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 1,  # 'O'
        46: 1,  # 'P'
        43: 1,  # 'R'
        33: 2,  # 'S'
        37: 1,  # 'T'
        57: 0,  # 'U'
        48: 1,  # 'V'
        55: 0,  # 'Y'
        52: 1,  # 'Z'
        2: 0,  # 'a'
        18: 1,  # 'b'
        26: 1,  # 'c'
        17: 1,  # 'd'
        1: 1,  # 'e'
        27: 0,  # 'f'
        12: 2,  # 'g'
        20: 0,  # 'h'
        9: 0,  # 'i'
        22: 1,  # 'j'
        7: 1,  # 'k'
        6: 1,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        8: 0,  # 'o'
        23: 1,  # 'p'
        10: 1,  # 'r'
        5: 1,  # 's'
        3: 1,  # 't'
        21: 0,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 1,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 1,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    48: {  # 'V'
        28: 2,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 1,  # 'D'
        32: 2,  # 'E'
        50: 1,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 2,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 0,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 1,  # 'O'
        46: 1,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 1,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 2,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 0,  # 'h'
        9: 2,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 1,  # 'l'
        13: 0,  # 'm'
        4: 0,  # 'n'
        8: 2,  # 'o'
        23: 0,  # 'p'
        10: 0,  # 'r'
        5: 0,  # 's'
        3: 0,  # 't'
        21: 1,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 0,  # 'z'
        51: 2,  # 'Á'
        44: 2,  # 'É'
        61: 1,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 0,  # 'Ú'
        63: 1,  # 'Ü'
        14: 2,  # 'á'
        15: 2,  # 'é'
        30: 1,  # 'í'
        25: 0,  # 'ó'
        24: 1,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    55: {  # 'Y'
        28: 2,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 2,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 1,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 1,  # 'O'
        46: 1,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 0,  # 'Y'
        52: 2,  # 'Z'
        2: 1,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 1,  # 'd'
        1: 1,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 0,  # 'h'
        9: 0,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 0,  # 'l'
        13: 0,  # 'm'
        4: 0,  # 'n'
        8: 1,  # 'o'
        23: 1,  # 'p'
        10: 0,  # 'r'
        5: 0,  # 's'
        3: 0,  # 't'
        21: 0,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 0,  # 'z'
        51: 1,  # 'Á'
        44: 1,  # 'É'
        61: 1,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    52: {  # 'Z'
        28: 2,  # 'A'
        40: 1,  # 'B'
        54: 0,  # 'C'
        45: 1,  # 'D'
        32: 2,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 2,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 2,  # 'O'
        46: 1,  # 'P'
        43: 1,  # 'R'
        33: 2,  # 'S'
        37: 1,  # 'T'
        57: 1,  # 'U'
        48: 1,  # 'V'
        55: 1,  # 'Y'
        52: 1,  # 'Z'
        2: 1,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 1,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 0,  # 'h'
        9: 1,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 0,  # 'l'
        13: 0,  # 'm'
        4: 1,  # 'n'
        8: 1,  # 'o'
        23: 0,  # 'p'
        10: 1,  # 'r'
        5: 2,  # 's'
        3: 0,  # 't'
        21: 1,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 0,  # 'z'
        51: 2,  # 'Á'
        44: 1,  # 'É'
        61: 1,  # 'Í'
        58: 1,  # 'Ó'
        59: 1,  # 'Ö'
        60: 1,  # 'Ú'
        63: 1,  # 'Ü'
        14: 1,  # 'á'
        15: 1,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 1,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    2: {  # 'a'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 1,  # 'a'
        18: 3,  # 'b'
        26: 3,  # 'c'
        17: 3,  # 'd'
        1: 2,  # 'e'
        27: 2,  # 'f'
        12: 3,  # 'g'
        20: 3,  # 'h'
        9: 3,  # 'i'
        22: 3,  # 'j'
        7: 3,  # 'k'
        6: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        8: 2,  # 'o'
        23: 3,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 3,  # 'u'
        19: 3,  # 'v'
        62: 1,  # 'x'
        16: 2,  # 'y'
        11: 3,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 1,  # 'á'
        15: 1,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 1,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    18: {  # 'b'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 3,  # 'b'
        26: 1,  # 'c'
        17: 1,  # 'd'
        1: 3,  # 'e'
        27: 1,  # 'f'
        12: 1,  # 'g'
        20: 1,  # 'h'
        9: 3,  # 'i'
        22: 2,  # 'j'
        7: 2,  # 'k'
        6: 2,  # 'l'
        13: 1,  # 'm'
        4: 2,  # 'n'
        8: 3,  # 'o'
        23: 1,  # 'p'
        10: 3,  # 'r'
        5: 2,  # 's'
        3: 1,  # 't'
        21: 3,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 1,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 2,  # 'í'
        25: 3,  # 'ó'
        24: 2,  # 'ö'
        31: 2,  # 'ú'
        29: 2,  # 'ü'
        42: 2,  # 'ő'
        56: 1,  # 'ű'
    },
    26: {  # 'c'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 1,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 1,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 2,  # 'a'
        18: 1,  # 'b'
        26: 2,  # 'c'
        17: 1,  # 'd'
        1: 3,  # 'e'
        27: 1,  # 'f'
        12: 1,  # 'g'
        20: 3,  # 'h'
        9: 3,  # 'i'
        22: 1,  # 'j'
        7: 2,  # 'k'
        6: 1,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        8: 3,  # 'o'
        23: 1,  # 'p'
        10: 2,  # 'r'
        5: 3,  # 's'
        3: 2,  # 't'
        21: 2,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 2,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 2,  # 'á'
        15: 2,  # 'é'
        30: 2,  # 'í'
        25: 1,  # 'ó'
        24: 1,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    17: {  # 'd'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 2,  # 'b'
        26: 1,  # 'c'
        17: 2,  # 'd'
        1: 3,  # 'e'
        27: 1,  # 'f'
        12: 1,  # 'g'
        20: 2,  # 'h'
        9: 3,  # 'i'
        22: 3,  # 'j'
        7: 2,  # 'k'
        6: 1,  # 'l'
        13: 2,  # 'm'
        4: 3,  # 'n'
        8: 3,  # 'o'
        23: 1,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 3,  # 'u'
        19: 3,  # 'v'
        62: 0,  # 'x'
        16: 2,  # 'y'
        11: 2,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 3,  # 'í'
        25: 3,  # 'ó'
        24: 3,  # 'ö'
        31: 2,  # 'ú'
        29: 2,  # 'ü'
        42: 2,  # 'ő'
        56: 1,  # 'ű'
    },
    1: {  # 'e'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 2,  # 'a'
        18: 3,  # 'b'
        26: 3,  # 'c'
        17: 3,  # 'd'
        1: 2,  # 'e'
        27: 3,  # 'f'
        12: 3,  # 'g'
        20: 3,  # 'h'
        9: 3,  # 'i'
        22: 3,  # 'j'
        7: 3,  # 'k'
        6: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        8: 2,  # 'o'
        23: 3,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 2,  # 'u'
        19: 3,  # 'v'
        62: 2,  # 'x'
        16: 2,  # 'y'
        11: 3,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 1,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 1,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    27: {  # 'f'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 1,  # 'b'
        26: 1,  # 'c'
        17: 1,  # 'd'
        1: 3,  # 'e'
        27: 2,  # 'f'
        12: 1,  # 'g'
        20: 1,  # 'h'
        9: 3,  # 'i'
        22: 2,  # 'j'
        7: 1,  # 'k'
        6: 1,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        8: 3,  # 'o'
        23: 0,  # 'p'
        10: 3,  # 'r'
        5: 1,  # 's'
        3: 1,  # 't'
        21: 2,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 0,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 3,  # 'ö'
        31: 1,  # 'ú'
        29: 2,  # 'ü'
        42: 1,  # 'ő'
        56: 1,  # 'ű'
    },
    12: {  # 'g'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 3,  # 'b'
        26: 2,  # 'c'
        17: 2,  # 'd'
        1: 3,  # 'e'
        27: 2,  # 'f'
        12: 3,  # 'g'
        20: 3,  # 'h'
        9: 3,  # 'i'
        22: 3,  # 'j'
        7: 2,  # 'k'
        6: 3,  # 'l'
        13: 2,  # 'm'
        4: 3,  # 'n'
        8: 3,  # 'o'
        23: 1,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 3,  # 'u'
        19: 3,  # 'v'
        62: 0,  # 'x'
        16: 3,  # 'y'
        11: 2,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 2,  # 'í'
        25: 3,  # 'ó'
        24: 2,  # 'ö'
        31: 2,  # 'ú'
        29: 2,  # 'ü'
        42: 2,  # 'ő'
        56: 1,  # 'ű'
    },
    20: {  # 'h'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 1,  # 'b'
        26: 1,  # 'c'
        17: 0,  # 'd'
        1: 3,  # 'e'
        27: 0,  # 'f'
        12: 1,  # 'g'
        20: 2,  # 'h'
        9: 3,  # 'i'
        22: 1,  # 'j'
        7: 1,  # 'k'
        6: 1,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        8: 3,  # 'o'
        23: 0,  # 'p'
        10: 1,  # 'r'
        5: 2,  # 's'
        3: 1,  # 't'
        21: 3,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 2,  # 'y'
        11: 0,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 3,  # 'í'
        25: 2,  # 'ó'
        24: 2,  # 'ö'
        31: 2,  # 'ú'
        29: 1,  # 'ü'
        42: 1,  # 'ő'
        56: 1,  # 'ű'
    },
    9: {  # 'i'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 3,  # 'b'
        26: 3,  # 'c'
        17: 3,  # 'd'
        1: 3,  # 'e'
        27: 3,  # 'f'
        12: 3,  # 'g'
        20: 3,  # 'h'
        9: 2,  # 'i'
        22: 2,  # 'j'
        7: 3,  # 'k'
        6: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        8: 2,  # 'o'
        23: 2,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 3,  # 'u'
        19: 3,  # 'v'
        62: 1,  # 'x'
        16: 1,  # 'y'
        11: 3,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 2,  # 'é'
        30: 1,  # 'í'
        25: 3,  # 'ó'
        24: 1,  # 'ö'
        31: 2,  # 'ú'
        29: 1,  # 'ü'
        42: 0,  # 'ő'
        56: 1,  # 'ű'
    },
    22: {  # 'j'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 2,  # 'b'
        26: 1,  # 'c'
        17: 3,  # 'd'
        1: 3,  # 'e'
        27: 1,  # 'f'
        12: 1,  # 'g'
        20: 2,  # 'h'
        9: 1,  # 'i'
        22: 2,  # 'j'
        7: 2,  # 'k'
        6: 2,  # 'l'
        13: 1,  # 'm'
        4: 2,  # 'n'
        8: 3,  # 'o'
        23: 1,  # 'p'
        10: 2,  # 'r'
        5: 2,  # 's'
        3: 3,  # 't'
        21: 3,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 2,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 1,  # 'í'
        25: 3,  # 'ó'
        24: 3,  # 'ö'
        31: 3,  # 'ú'
        29: 2,  # 'ü'
        42: 1,  # 'ő'
        56: 1,  # 'ű'
    },
    7: {  # 'k'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 3,  # 'b'
        26: 2,  # 'c'
        17: 1,  # 'd'
        1: 3,  # 'e'
        27: 1,  # 'f'
        12: 1,  # 'g'
        20: 2,  # 'h'
        9: 3,  # 'i'
        22: 2,  # 'j'
        7: 3,  # 'k'
        6: 3,  # 'l'
        13: 1,  # 'm'
        4: 3,  # 'n'
        8: 3,  # 'o'
        23: 1,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 3,  # 'u'
        19: 2,  # 'v'
        62: 0,  # 'x'
        16: 2,  # 'y'
        11: 1,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 3,  # 'í'
        25: 2,  # 'ó'
        24: 3,  # 'ö'
        31: 1,  # 'ú'
        29: 3,  # 'ü'
        42: 1,  # 'ő'
        56: 1,  # 'ű'
    },
    6: {  # 'l'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 1,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 1,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 2,  # 'b'
        26: 3,  # 'c'
        17: 3,  # 'd'
        1: 3,  # 'e'
        27: 3,  # 'f'
        12: 3,  # 'g'
        20: 3,  # 'h'
        9: 3,  # 'i'
        22: 3,  # 'j'
        7: 3,  # 'k'
        6: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        8: 3,  # 'o'
        23: 2,  # 'p'
        10: 2,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 3,  # 'u'
        19: 3,  # 'v'
        62: 0,  # 'x'
        16: 3,  # 'y'
        11: 2,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 3,  # 'í'
        25: 3,  # 'ó'
        24: 3,  # 'ö'
        31: 2,  # 'ú'
        29: 2,  # 'ü'
        42: 3,  # 'ő'
        56: 1,  # 'ű'
    },
    13: {  # 'm'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 3,  # 'b'
        26: 2,  # 'c'
        17: 1,  # 'd'
        1: 3,  # 'e'
        27: 1,  # 'f'
        12: 1,  # 'g'
        20: 2,  # 'h'
        9: 3,  # 'i'
        22: 2,  # 'j'
        7: 1,  # 'k'
        6: 3,  # 'l'
        13: 3,  # 'm'
        4: 2,  # 'n'
        8: 3,  # 'o'
        23: 3,  # 'p'
        10: 2,  # 'r'
        5: 2,  # 's'
        3: 2,  # 't'
        21: 3,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 2,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 2,  # 'í'
        25: 2,  # 'ó'
        24: 2,  # 'ö'
        31: 2,  # 'ú'
        29: 2,  # 'ü'
        42: 1,  # 'ő'
        56: 2,  # 'ű'
    },
    4: {  # 'n'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 3,  # 'b'
        26: 3,  # 'c'
        17: 3,  # 'd'
        1: 3,  # 'e'
        27: 2,  # 'f'
        12: 3,  # 'g'
        20: 3,  # 'h'
        9: 3,  # 'i'
        22: 2,  # 'j'
        7: 3,  # 'k'
        6: 2,  # 'l'
        13: 2,  # 'm'
        4: 3,  # 'n'
        8: 3,  # 'o'
        23: 2,  # 'p'
        10: 2,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 3,  # 'u'
        19: 2,  # 'v'
        62: 1,  # 'x'
        16: 3,  # 'y'
        11: 3,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 2,  # 'í'
        25: 2,  # 'ó'
        24: 3,  # 'ö'
        31: 2,  # 'ú'
        29: 3,  # 'ü'
        42: 2,  # 'ő'
        56: 1,  # 'ű'
    },
    8: {  # 'o'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 1,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 2,  # 'a'
        18: 3,  # 'b'
        26: 3,  # 'c'
        17: 3,  # 'd'
        1: 2,  # 'e'
        27: 2,  # 'f'
        12: 3,  # 'g'
        20: 3,  # 'h'
        9: 2,  # 'i'
        22: 2,  # 'j'
        7: 3,  # 'k'
        6: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        8: 1,  # 'o'
        23: 3,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 2,  # 'u'
        19: 3,  # 'v'
        62: 1,  # 'x'
        16: 1,  # 'y'
        11: 3,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 1,  # 'á'
        15: 2,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 1,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    23: {  # 'p'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 1,  # 'b'
        26: 2,  # 'c'
        17: 1,  # 'd'
        1: 3,  # 'e'
        27: 1,  # 'f'
        12: 1,  # 'g'
        20: 2,  # 'h'
        9: 3,  # 'i'
        22: 2,  # 'j'
        7: 2,  # 'k'
        6: 3,  # 'l'
        13: 1,  # 'm'
        4: 2,  # 'n'
        8: 3,  # 'o'
        23: 3,  # 'p'
        10: 3,  # 'r'
        5: 2,  # 's'
        3: 2,  # 't'
        21: 3,  # 'u'
        19: 2,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 2,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 2,  # 'í'
        25: 2,  # 'ó'
        24: 2,  # 'ö'
        31: 1,  # 'ú'
        29: 2,  # 'ü'
        42: 1,  # 'ő'
        56: 1,  # 'ű'
    },
    10: {  # 'r'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 3,  # 'b'
        26: 3,  # 'c'
        17: 3,  # 'd'
        1: 3,  # 'e'
        27: 2,  # 'f'
        12: 3,  # 'g'
        20: 2,  # 'h'
        9: 3,  # 'i'
        22: 3,  # 'j'
        7: 3,  # 'k'
        6: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        8: 3,  # 'o'
        23: 2,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 3,  # 'u'
        19: 3,  # 'v'
        62: 1,  # 'x'
        16: 2,  # 'y'
        11: 3,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 2,  # 'í'
        25: 3,  # 'ó'
        24: 3,  # 'ö'
        31: 3,  # 'ú'
        29: 3,  # 'ü'
        42: 2,  # 'ő'
        56: 2,  # 'ű'
    },
    5: {  # 's'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 3,  # 'b'
        26: 2,  # 'c'
        17: 2,  # 'd'
        1: 3,  # 'e'
        27: 2,  # 'f'
        12: 2,  # 'g'
        20: 2,  # 'h'
        9: 3,  # 'i'
        22: 1,  # 'j'
        7: 3,  # 'k'
        6: 2,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        8: 3,  # 'o'
        23: 2,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 3,  # 'u'
        19: 2,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 3,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 3,  # 'í'
        25: 3,  # 'ó'
        24: 3,  # 'ö'
        31: 3,  # 'ú'
        29: 3,  # 'ü'
        42: 2,  # 'ő'
        56: 1,  # 'ű'
    },
    3: {  # 't'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 3,  # 'b'
        26: 2,  # 'c'
        17: 1,  # 'd'
        1: 3,  # 'e'
        27: 2,  # 'f'
        12: 1,  # 'g'
        20: 3,  # 'h'
        9: 3,  # 'i'
        22: 3,  # 'j'
        7: 3,  # 'k'
        6: 3,  # 'l'
        13: 2,  # 'm'
        4: 3,  # 'n'
        8: 3,  # 'o'
        23: 1,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 3,  # 'u'
        19: 3,  # 'v'
        62: 0,  # 'x'
        16: 3,  # 'y'
        11: 1,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 2,  # 'í'
        25: 3,  # 'ó'
        24: 3,  # 'ö'
        31: 3,  # 'ú'
        29: 3,  # 'ü'
        42: 3,  # 'ő'
        56: 2,  # 'ű'
    },
    21: {  # 'u'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 1,  # 'a'
        18: 2,  # 'b'
        26: 2,  # 'c'
        17: 3,  # 'd'
        1: 2,  # 'e'
        27: 1,  # 'f'
        12: 3,  # 'g'
        20: 2,  # 'h'
        9: 2,  # 'i'
        22: 2,  # 'j'
        7: 3,  # 'k'
        6: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        8: 1,  # 'o'
        23: 2,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 1,  # 'u'
        19: 3,  # 'v'
        62: 1,  # 'x'
        16: 1,  # 'y'
        11: 2,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 2,  # 'á'
        15: 1,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 0,  # 'ö'
        31: 1,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    19: {  # 'v'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 2,  # 'b'
        26: 1,  # 'c'
        17: 1,  # 'd'
        1: 3,  # 'e'
        27: 1,  # 'f'
        12: 1,  # 'g'
        20: 1,  # 'h'
        9: 3,  # 'i'
        22: 1,  # 'j'
        7: 1,  # 'k'
        6: 1,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        8: 3,  # 'o'
        23: 1,  # 'p'
        10: 1,  # 'r'
        5: 2,  # 's'
        3: 2,  # 't'
        21: 2,  # 'u'
        19: 2,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 1,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 2,  # 'í'
        25: 2,  # 'ó'
        24: 2,  # 'ö'
        31: 1,  # 'ú'
        29: 2,  # 'ü'
        42: 1,  # 'ő'
        56: 1,  # 'ű'
    },
    62: {  # 'x'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 1,  # 'a'
        18: 1,  # 'b'
        26: 1,  # 'c'
        17: 0,  # 'd'
        1: 1,  # 'e'
        27: 1,  # 'f'
        12: 0,  # 'g'
        20: 0,  # 'h'
        9: 1,  # 'i'
        22: 0,  # 'j'
        7: 1,  # 'k'
        6: 1,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        8: 1,  # 'o'
        23: 1,  # 'p'
        10: 1,  # 'r'
        5: 1,  # 's'
        3: 1,  # 't'
        21: 1,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 0,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 1,  # 'á'
        15: 1,  # 'é'
        30: 1,  # 'í'
        25: 1,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    16: {  # 'y'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 2,  # 'b'
        26: 1,  # 'c'
        17: 1,  # 'd'
        1: 3,  # 'e'
        27: 2,  # 'f'
        12: 2,  # 'g'
        20: 2,  # 'h'
        9: 3,  # 'i'
        22: 2,  # 'j'
        7: 2,  # 'k'
        6: 2,  # 'l'
        13: 2,  # 'm'
        4: 3,  # 'n'
        8: 3,  # 'o'
        23: 2,  # 'p'
        10: 2,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 3,  # 'u'
        19: 3,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 2,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 2,  # 'í'
        25: 2,  # 'ó'
        24: 3,  # 'ö'
        31: 2,  # 'ú'
        29: 2,  # 'ü'
        42: 1,  # 'ő'
        56: 2,  # 'ű'
    },
    11: {  # 'z'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 3,  # 'a'
        18: 2,  # 'b'
        26: 1,  # 'c'
        17: 3,  # 'd'
        1: 3,  # 'e'
        27: 1,  # 'f'
        12: 2,  # 'g'
        20: 2,  # 'h'
        9: 3,  # 'i'
        22: 1,  # 'j'
        7: 3,  # 'k'
        6: 2,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        8: 3,  # 'o'
        23: 1,  # 'p'
        10: 2,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 3,  # 'u'
        19: 2,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 3,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 3,  # 'á'
        15: 3,  # 'é'
        30: 3,  # 'í'
        25: 3,  # 'ó'
        24: 3,  # 'ö'
        31: 2,  # 'ú'
        29: 3,  # 'ü'
        42: 2,  # 'ő'
        56: 1,  # 'ű'
    },
    51: {  # 'Á'
        28: 0,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 0,  # 'E'
        50: 1,  # 'F'
        49: 2,  # 'G'
        38: 1,  # 'H'
        39: 1,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 2,  # 'L'
        34: 1,  # 'M'
        35: 2,  # 'N'
        47: 0,  # 'O'
        46: 1,  # 'P'
        43: 2,  # 'R'
        33: 2,  # 'S'
        37: 1,  # 'T'
        57: 0,  # 'U'
        48: 1,  # 'V'
        55: 0,  # 'Y'
        52: 1,  # 'Z'
        2: 0,  # 'a'
        18: 1,  # 'b'
        26: 1,  # 'c'
        17: 1,  # 'd'
        1: 0,  # 'e'
        27: 0,  # 'f'
        12: 1,  # 'g'
        20: 1,  # 'h'
        9: 0,  # 'i'
        22: 1,  # 'j'
        7: 1,  # 'k'
        6: 2,  # 'l'
        13: 2,  # 'm'
        4: 0,  # 'n'
        8: 0,  # 'o'
        23: 1,  # 'p'
        10: 1,  # 'r'
        5: 1,  # 's'
        3: 1,  # 't'
        21: 0,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 1,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 1,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    44: {  # 'É'
        28: 0,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 1,  # 'E'
        50: 0,  # 'F'
        49: 2,  # 'G'
        38: 1,  # 'H'
        39: 1,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 2,  # 'L'
        34: 1,  # 'M'
        35: 2,  # 'N'
        47: 0,  # 'O'
        46: 1,  # 'P'
        43: 2,  # 'R'
        33: 2,  # 'S'
        37: 2,  # 'T'
        57: 0,  # 'U'
        48: 1,  # 'V'
        55: 0,  # 'Y'
        52: 1,  # 'Z'
        2: 0,  # 'a'
        18: 1,  # 'b'
        26: 1,  # 'c'
        17: 1,  # 'd'
        1: 0,  # 'e'
        27: 0,  # 'f'
        12: 1,  # 'g'
        20: 1,  # 'h'
        9: 0,  # 'i'
        22: 1,  # 'j'
        7: 1,  # 'k'
        6: 2,  # 'l'
        13: 1,  # 'm'
        4: 2,  # 'n'
        8: 0,  # 'o'
        23: 1,  # 'p'
        10: 2,  # 'r'
        5: 3,  # 's'
        3: 1,  # 't'
        21: 0,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 0,  # 'z'
        51: 0,  # 'Á'
        44: 1,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    61: {  # 'Í'
        28: 0,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 0,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 1,  # 'J'
        36: 0,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 0,  # 'O'
        46: 1,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 0,  # 'U'
        48: 1,  # 'V'
        55: 0,  # 'Y'
        52: 1,  # 'Z'
        2: 0,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 0,  # 'e'
        27: 0,  # 'f'
        12: 2,  # 'g'
        20: 0,  # 'h'
        9: 0,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 0,  # 'l'
        13: 1,  # 'm'
        4: 0,  # 'n'
        8: 0,  # 'o'
        23: 0,  # 'p'
        10: 1,  # 'r'
        5: 0,  # 's'
        3: 1,  # 't'
        21: 0,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 1,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    58: {  # 'Ó'
        28: 1,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 0,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 1,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 2,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 0,  # 'O'
        46: 1,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 0,  # 'U'
        48: 1,  # 'V'
        55: 0,  # 'Y'
        52: 1,  # 'Z'
        2: 0,  # 'a'
        18: 1,  # 'b'
        26: 1,  # 'c'
        17: 1,  # 'd'
        1: 0,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 2,  # 'h'
        9: 0,  # 'i'
        22: 0,  # 'j'
        7: 1,  # 'k'
        6: 1,  # 'l'
        13: 0,  # 'm'
        4: 1,  # 'n'
        8: 0,  # 'o'
        23: 1,  # 'p'
        10: 1,  # 'r'
        5: 1,  # 's'
        3: 0,  # 't'
        21: 0,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 1,  # 'z'
        51: 0,  # 'Á'
        44: 1,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    59: {  # 'Ö'
        28: 0,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 0,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 0,  # 'O'
        46: 1,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 0,  # 'U'
        48: 1,  # 'V'
        55: 0,  # 'Y'
        52: 1,  # 'Z'
        2: 0,  # 'a'
        18: 0,  # 'b'
        26: 1,  # 'c'
        17: 1,  # 'd'
        1: 0,  # 'e'
        27: 0,  # 'f'
        12: 0,  # 'g'
        20: 0,  # 'h'
        9: 0,  # 'i'
        22: 0,  # 'j'
        7: 1,  # 'k'
        6: 1,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        8: 0,  # 'o'
        23: 0,  # 'p'
        10: 2,  # 'r'
        5: 1,  # 's'
        3: 1,  # 't'
        21: 0,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 1,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    60: {  # 'Ú'
        28: 0,  # 'A'
        40: 1,  # 'B'
        54: 1,  # 'C'
        45: 1,  # 'D'
        32: 0,  # 'E'
        50: 1,  # 'F'
        49: 1,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 0,  # 'U'
        48: 1,  # 'V'
        55: 0,  # 'Y'
        52: 1,  # 'Z'
        2: 0,  # 'a'
        18: 0,  # 'b'
        26: 0,  # 'c'
        17: 0,  # 'd'
        1: 0,  # 'e'
        27: 0,  # 'f'
        12: 2,  # 'g'
        20: 0,  # 'h'
        9: 0,  # 'i'
        22: 2,  # 'j'
        7: 0,  # 'k'
        6: 0,  # 'l'
        13: 0,  # 'm'
        4: 1,  # 'n'
        8: 0,  # 'o'
        23: 0,  # 'p'
        10: 1,  # 'r'
        5: 1,  # 's'
        3: 1,  # 't'
        21: 0,  # 'u'
        19: 0,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 0,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    63: {  # 'Ü'
        28: 0,  # 'A'
        40: 1,  # 'B'
        54: 0,  # 'C'
        45: 1,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 1,  # 'G'
        38: 1,  # 'H'
        39: 0,  # 'I'
        53: 1,  # 'J'
        36: 1,  # 'K'
        41: 1,  # 'L'
        34: 1,  # 'M'
        35: 1,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 1,  # 'R'
        33: 1,  # 'S'
        37: 1,  # 'T'
        57: 0,  # 'U'
        48: 1,  # 'V'
        55: 0,  # 'Y'
        52: 1,  # 'Z'
        2: 0,  # 'a'
        18: 1,  # 'b'
        26: 0,  # 'c'
        17: 1,  # 'd'
        1: 0,  # 'e'
        27: 0,  # 'f'
        12: 1,  # 'g'
        20: 0,  # 'h'
        9: 0,  # 'i'
        22: 0,  # 'j'
        7: 0,  # 'k'
        6: 1,  # 'l'
        13: 0,  # 'm'
        4: 1,  # 'n'
        8: 0,  # 'o'
        23: 0,  # 'p'
        10: 1,  # 'r'
        5: 1,  # 's'
        3: 1,  # 't'
        21: 0,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 1,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    14: {  # 'á'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 1,  # 'a'
        18: 3,  # 'b'
        26: 3,  # 'c'
        17: 3,  # 'd'
        1: 1,  # 'e'
        27: 2,  # 'f'
        12: 3,  # 'g'
        20: 2,  # 'h'
        9: 2,  # 'i'
        22: 3,  # 'j'
        7: 3,  # 'k'
        6: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        8: 1,  # 'o'
        23: 2,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 2,  # 'u'
        19: 3,  # 'v'
        62: 0,  # 'x'
        16: 1,  # 'y'
        11: 3,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 1,  # 'á'
        15: 2,  # 'é'
        30: 1,  # 'í'
        25: 0,  # 'ó'
        24: 1,  # 'ö'
        31: 0,  # 'ú'
        29: 1,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    15: {  # 'é'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 1,  # 'a'
        18: 3,  # 'b'
        26: 2,  # 'c'
        17: 3,  # 'd'
        1: 1,  # 'e'
        27: 1,  # 'f'
        12: 3,  # 'g'
        20: 3,  # 'h'
        9: 2,  # 'i'
        22: 2,  # 'j'
        7: 3,  # 'k'
        6: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        8: 1,  # 'o'
        23: 3,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 0,  # 'u'
        19: 3,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 3,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 1,  # 'á'
        15: 1,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 1,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    30: {  # 'í'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 0,  # 'a'
        18: 1,  # 'b'
        26: 2,  # 'c'
        17: 1,  # 'd'
        1: 0,  # 'e'
        27: 1,  # 'f'
        12: 3,  # 'g'
        20: 0,  # 'h'
        9: 0,  # 'i'
        22: 1,  # 'j'
        7: 1,  # 'k'
        6: 2,  # 'l'
        13: 2,  # 'm'
        4: 3,  # 'n'
        8: 0,  # 'o'
        23: 1,  # 'p'
        10: 3,  # 'r'
        5: 2,  # 's'
        3: 3,  # 't'
        21: 0,  # 'u'
        19: 3,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 2,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    25: {  # 'ó'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 2,  # 'a'
        18: 3,  # 'b'
        26: 2,  # 'c'
        17: 3,  # 'd'
        1: 1,  # 'e'
        27: 2,  # 'f'
        12: 2,  # 'g'
        20: 2,  # 'h'
        9: 2,  # 'i'
        22: 2,  # 'j'
        7: 3,  # 'k'
        6: 3,  # 'l'
        13: 2,  # 'm'
        4: 3,  # 'n'
        8: 1,  # 'o'
        23: 2,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 1,  # 'u'
        19: 2,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 3,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 1,  # 'á'
        15: 1,  # 'é'
        30: 1,  # 'í'
        25: 0,  # 'ó'
        24: 1,  # 'ö'
        31: 1,  # 'ú'
        29: 1,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    24: {  # 'ö'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 0,  # 'a'
        18: 3,  # 'b'
        26: 1,  # 'c'
        17: 2,  # 'd'
        1: 0,  # 'e'
        27: 1,  # 'f'
        12: 2,  # 'g'
        20: 1,  # 'h'
        9: 0,  # 'i'
        22: 1,  # 'j'
        7: 3,  # 'k'
        6: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        8: 0,  # 'o'
        23: 2,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 3,  # 't'
        21: 0,  # 'u'
        19: 3,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 3,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    31: {  # 'ú'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 1,  # 'a'
        18: 1,  # 'b'
        26: 2,  # 'c'
        17: 1,  # 'd'
        1: 1,  # 'e'
        27: 2,  # 'f'
        12: 3,  # 'g'
        20: 1,  # 'h'
        9: 1,  # 'i'
        22: 3,  # 'j'
        7: 1,  # 'k'
        6: 3,  # 'l'
        13: 1,  # 'm'
        4: 2,  # 'n'
        8: 0,  # 'o'
        23: 1,  # 'p'
        10: 3,  # 'r'
        5: 3,  # 's'
        3: 2,  # 't'
        21: 1,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 2,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 1,  # 'á'
        15: 1,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    29: {  # 'ü'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 1,  # 'a'
        18: 1,  # 'b'
        26: 1,  # 'c'
        17: 2,  # 'd'
        1: 1,  # 'e'
        27: 1,  # 'f'
        12: 3,  # 'g'
        20: 2,  # 'h'
        9: 1,  # 'i'
        22: 1,  # 'j'
        7: 3,  # 'k'
        6: 3,  # 'l'
        13: 1,  # 'm'
        4: 3,  # 'n'
        8: 0,  # 'o'
        23: 1,  # 'p'
        10: 2,  # 'r'
        5: 2,  # 's'
        3: 2,  # 't'
        21: 0,  # 'u'
        19: 2,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 2,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 1,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    42: {  # 'ő'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 1,  # 'a'
        18: 2,  # 'b'
        26: 1,  # 'c'
        17: 2,  # 'd'
        1: 1,  # 'e'
        27: 1,  # 'f'
        12: 1,  # 'g'
        20: 1,  # 'h'
        9: 1,  # 'i'
        22: 1,  # 'j'
        7: 2,  # 'k'
        6: 3,  # 'l'
        13: 1,  # 'm'
        4: 2,  # 'n'
        8: 1,  # 'o'
        23: 1,  # 'p'
        10: 2,  # 'r'
        5: 2,  # 's'
        3: 2,  # 't'
        21: 1,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 2,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 1,  # 'é'
        30: 1,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 1,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
    56: {  # 'ű'
        28: 0,  # 'A'
        40: 0,  # 'B'
        54: 0,  # 'C'
        45: 0,  # 'D'
        32: 0,  # 'E'
        50: 0,  # 'F'
        49: 0,  # 'G'
        38: 0,  # 'H'
        39: 0,  # 'I'
        53: 0,  # 'J'
        36: 0,  # 'K'
        41: 0,  # 'L'
        34: 0,  # 'M'
        35: 0,  # 'N'
        47: 0,  # 'O'
        46: 0,  # 'P'
        43: 0,  # 'R'
        33: 0,  # 'S'
        37: 0,  # 'T'
        57: 0,  # 'U'
        48: 0,  # 'V'
        55: 0,  # 'Y'
        52: 0,  # 'Z'
        2: 1,  # 'a'
        18: 1,  # 'b'
        26: 0,  # 'c'
        17: 1,  # 'd'
        1: 1,  # 'e'
        27: 1,  # 'f'
        12: 1,  # 'g'
        20: 1,  # 'h'
        9: 1,  # 'i'
        22: 1,  # 'j'
        7: 1,  # 'k'
        6: 1,  # 'l'
        13: 0,  # 'm'
        4: 2,  # 'n'
        8: 0,  # 'o'
        23: 0,  # 'p'
        10: 1,  # 'r'
        5: 1,  # 's'
        3: 1,  # 't'
        21: 0,  # 'u'
        19: 1,  # 'v'
        62: 0,  # 'x'
        16: 0,  # 'y'
        11: 2,  # 'z'
        51: 0,  # 'Á'
        44: 0,  # 'É'
        61: 0,  # 'Í'
        58: 0,  # 'Ó'
        59: 0,  # 'Ö'
        60: 0,  # 'Ú'
        63: 0,  # 'Ü'
        14: 0,  # 'á'
        15: 0,  # 'é'
        30: 0,  # 'í'
        25: 0,  # 'ó'
        24: 0,  # 'ö'
        31: 0,  # 'ú'
        29: 0,  # 'ü'
        42: 0,  # 'ő'
        56: 0,  # 'ű'
    },
}

# 255: Undefined characters that did not exist in training text
# 254: Carriage/Return
# 253: symbol (punctuation) that does not belong to word
# 252: 0 - 9
# 251: Control characters

# Character Mapping Table(s):
WINDOWS_1250_HUNGARIAN_CHAR_TO_ORDER = {
     0: 255,  # '\x00'
     1: 255,  # '\x01'
     2: 255,  # '\x02'
     3: 255,  # '\x03'
     4: 255,  # '\x04'
     5: 255,  # '\x05'
     6: 255,  # '\x06'
     7: 255,  # '\x07'
     8: 255,  # '\x08'
     9: 255,  # '\t'
     10: 254,  # '\n'
     11: 255,  # '\x0b'
     12: 255,  # '\x0c'
     13: 254,  # '\r'
     14: 255,  # '\x0e'
     15: 255,  # '\x0f'
     16: 255,  # '\x10'
     17: 255,  # '\x11'
     18: 255,  # '\x12'
     19: 255,  # '\x13'
     20: 255,  # '\x14'
     21: 255,  # '\x15'
     22: 255,  # '\x16'
     23: 255,  # '\x17'
     24: 255,  # '\x18'
     25: 255,  # '\x19'
     26: 255,  # '\x1a'
     27: 255,  # '\x1b'
     28: 255,  # '\x1c'
     29: 255,  # '\x1d'
     30: 255,  # '\x1e'
     31: 255,  # '\x1f'
     32: 253,  # ' '
     33: 253,  # '!'
     34: 253,  # '"'
     35: 253,  # '#'
     36: 253,  # '$'
     37: 253,  # '%'
     38: 253,  # '&'
     39: 253,  # "'"
     40: 253,  # '('
     41: 253,  # ')'
     42: 253,  # '*'
     43: 253,  # '+'
     44: 253,  # ','
     45: 253,  # '-'
     46: 253,  # '.'
     47: 253,  # '/'
     48: 252,  # '0'
     49: 252,  # '1'
     50: 252,  # '2'
     51: 252,  # '3'
     52: 252,  # '4'
     53: 252,  # '5'
     54: 252,  # '6'
     55: 252,  # '7'
     56: 252,  # '8'
     57: 252,  # '9'
     58: 253,  # ':'
     59: 253,  # ';'
     60: 253,  # '<'
     61: 253,  # '='
     62: 253,  # '>'
     63: 253,  # '?'
     64: 253,  # '@'
     65: 28,  # 'A'
     66: 40,  # 'B'
     67: 54,  # 'C'
     68: 45,  # 'D'
     69: 32,  # 'E'
     70: 50,  # 'F'
     71: 49,  # 'G'
     72: 38,  # 'H'
     73: 39,  # 'I'
     74: 53,  # 'J'
     75: 36,  # 'K'
     76: 41,  # 'L'
     77: 34,  # 'M'
     78: 35,  # 'N'
     79: 47,  # 'O'
     80: 46,  # 'P'
     81: 72,  # 'Q'
     82: 43,  # 'R'
     83: 33,  # 'S'
     84: 37,  # 'T'
     85: 57,  # 'U'
     86: 48,  # 'V'
     87: 64,  # 'W'
     88: 68,  # 'X'
     89: 55,  # 'Y'
     90: 52,  # 'Z'
     91: 253,  # '['
     92: 253,  # '\\'
     93: 253,  # ']'
     94: 253,  # '^'
     95: 253,  # '_'
     96: 253,  # '`'
     97: 2,  # 'a'
     98: 18,  # 'b'
     99: 26,  # 'c'
     100: 17,  # 'd'
     101: 1,  # 'e'
     102: 27,  # 'f'
     103: 12,  # 'g'
     104: 20,  # 'h'
     105: 9,  # 'i'
     106: 22,  # 'j'
     107: 7,  # 'k'
     108: 6,  # 'l'
     109: 13,  # 'm'
     110: 4,  # 'n'
     111: 8,  # 'o'
     112: 23,  # 'p'
     113: 67,  # 'q'
     114: 10,  # 'r'
     115: 5,  # 's'
     116: 3,  # 't'
     117: 21,  # 'u'
     118: 19,  # 'v'
     119: 65,  # 'w'
     120: 62,  # 'x'
     121: 16,  # 'y'
     122: 11,  # 'z'
     123: 253,  # '{'
     124: 253,  # '|'
     125: 253,  # '}'
     126: 253,  # '~'
     127: 253,  # '\x7f'
     128: 161,  # '€'
     129: 162,  # None
     130: 163,  # '‚'
     131: 164,  # None
     132: 165,  # '„'
     133: 166,  # '…'
     134: 167,  # '†'
     135: 168,  # '‡'
     136: 169,  # None
     137: 170,  # '‰'
     138: 171,  # 'Š'
     139: 172,  # '‹'
     140: 173,  # 'Ś'
     141: 174,  # 'Ť'
     142: 175,  # 'Ž'
     143: 176,  # 'Ź'
     144: 177,  # None
     145: 178,  # '‘'
     146: 179,  # '’'
     147: 180,  # '“'
     148: 78,  # '”'
     149: 181,  # '•'
     150: 69,  # '–'
     151: 182,  # '—'
     152: 183,  # None
     153: 184,  # '™'
     154: 185,  # 'š'
     155: 186,  # '›'
     156: 187,  # 'ś'
     157: 188,  # 'ť'
     158: 189,  # 'ž'
     159: 190,  # 'ź'
     160: 191,  # '\xa0'
     161: 192,  # 'ˇ'
     162: 193,  # '˘'
     163: 194,  # 'Ł'
     164: 195,  # '¤'
     165: 196,  # 'Ą'
     166: 197,  # '¦'
     167: 76,  # '§'
     168: 198,  # '¨'
     169: 199,  # '©'
     170: 200,  # 'Ş'
     171: 201,  # '«'
     172: 202,  # '¬'
     173: 203,  # '\xad'
     174: 204,  # '®'
     175: 205,  # 'Ż'
     176: 81,  # '°'
     177: 206,  # '±'
     178: 207,  # '˛'
     179: 208,  # 'ł'
     180: 209,  # '´'
     181: 210,  # 'µ'
     182: 211,  # '¶'
     183: 212,  # '·'
     184: 213,  # '¸'
     185: 214,  # 'ą'
     186: 215,  # 'ş'
     187: 216,  # '»'
     188: 217,  # 'Ľ'
     189: 218,  # '˝'
     190: 219,  # 'ľ'
     191: 220,  # 'ż'
     192: 221,  # 'Ŕ'
     193: 51,  # 'Á'
     194: 83,  # 'Â'
     195: 222,  # 'Ă'
     196: 80,  # 'Ä'
     197: 223,  # 'Ĺ'
     198: 224,  # 'Ć'
     199: 225,  # 'Ç'
     200: 226,  # 'Č'
     201: 44,  # 'É'
     202: 227,  # 'Ę'
     203: 228,  # 'Ë'
     204: 229,  # 'Ě'
     205: 61,  # 'Í'
     206: 230,  # 'Î'
     207: 231,  # 'Ď'
     208: 232,  # 'Đ'
     209: 233,  # 'Ń'
     210: 234,  # 'Ň'
     211: 58,  # 'Ó'
     212: 235,  # 'Ô'
     213: 66,  # 'Ő'
     214: 59,  # 'Ö'
     215: 236,  # '×'
     216: 237,  # 'Ř'
     217: 238,  # 'Ů'
     218: 60,  # 'Ú'
     219: 70,  # 'Ű'
     220: 63,  # 'Ü'
     221: 239,  # 'Ý'
     222: 240,  # 'Ţ'
     223: 241,  # 'ß'
     224: 84,  # 'ŕ'
     225: 14,  # 'á'
     226: 75,  # 'â'
     227: 242,  # 'ă'
     228: 71,  # 'ä'
     229: 82,  # 'ĺ'
     230: 243,  # 'ć'
     231: 73,  # 'ç'
     232: 244,  # 'č'
     233: 15,  # 'é'
     234: 85,  # 'ę'
     235: 79,  # 'ë'
     236: 86,  # 'ě'
     237: 30,  # 'í'
     238: 77,  # 'î'
     239: 87,  # 'ď'
     240: 245,  # 'đ'
     241: 246,  # 'ń'
     242: 247,  # 'ň'
     243: 25,  # 'ó'
     244: 74,  # 'ô'
     245: 42,  # 'ő'
     246: 24,  # 'ö'
     247: 248,  # '÷'
     248: 249,  # 'ř'
     249: 250,  # 'ů'
     250: 31,  # 'ú'
     251: 56,  # 'ű'
     252: 29,  # 'ü'
     253: 251,  # 'ý'
     254: 252,  # 'ţ'
     255: 253,  # '˙'
}

WINDOWS_1250_HUNGARIAN_MODEL = SingleByteCharSetModel(charset_name='windows-1250',
                                                      language='Hungarian',
                                                      char_to_order_map=WINDOWS_1250_HUNGARIAN_CHAR_TO_ORDER,
                                                      language_model=HUNGARIAN_LANG_MODEL,
                                                      typical_positive_ratio=0.947368,
                                                      keep_ascii_letters=True,
                                                      alphabet='ABCDEFGHIJKLMNOPRSTUVZabcdefghijklmnoprstuvzÁÉÍÓÖÚÜáéíóöúüŐőŰű')

ISO_8859_2_HUNGARIAN_CHAR_TO_ORDER = {
     0: 255,  # '\x00'
     1: 255,  # '\x01'
     2: 255,  # '\x02'
     3: 255,  # '\x03'
     4: 255,  # '\x04'
     5: 255,  # '\x05'
     6: 255,  # '\x06'
     7: 255,  # '\x07'
     8: 255,  # '\x08'
     9: 255,  # '\t'
     10: 254,  # '\n'
     11: 255,  # '\x0b'
     12: 255,  # '\x0c'
     13: 254,  # '\r'
     14: 255,  # '\x0e'
     15: 255,  # '\x0f'
     16: 255,  # '\x10'
     17: 255,  # '\x11'
     18: 255,  # '\x12'
     19: 255,  # '\x13'
     20: 255,  # '\x14'
     21: 255,  # '\x15'
     22: 255,  # '\x16'
     23: 255,  # '\x17'
     24: 255,  # '\x18'
     25: 255,  # '\x19'
     26: 255,  # '\x1a'
     27: 255,  # '\x1b'
     28: 255,  # '\x1c'
     29: 255,  # '\x1d'
     30: 255,  # '\x1e'
     31: 255,  # '\x1f'
     32: 253,  # ' '
     33: 253,  # '!'
     34: 253,  # '"'
     35: 253,  # '#'
     36: 253,  # '$'
     37: 253,  # '%'
     38: 253,  # '&'
     39: 253,  # "'"
     40: 253,  # '('
     41: 253,  # ')'
     42: 253,  # '*'
     43: 253,  # '+'
     44: 253,  # ','
     45: 253,  # '-'
     46: 253,  # '.'
     47: 253,  # '/'
     48: 252,  # '0'
     49: 252,  # '1'
     50: 252,  # '2'
     51: 252,  # '3'
     52: 252,  # '4'
     53: 252,  # '5'
     54: 252,  # '6'
     55: 252,  # '7'
     56: 252,  # '8'
     57: 252,  # '9'
     58: 253,  # ':'
     59: 253,  # ';'
     60: 253,  # '<'
     61: 253,  # '='
     62: 253,  # '>'
     63: 253,  # '?'
     64: 253,  # '@'
     65: 28,  # 'A'
     66: 40,  # 'B'
     67: 54,  # 'C'
     68: 45,  # 'D'
     69: 32,  # 'E'
     70: 50,  # 'F'
     71: 49,  # 'G'
     72: 38,  # 'H'
     73: 39,  # 'I'
     74: 53,  # 'J'
     75: 36,  # 'K'
     76: 41,  # 'L'
     77: 34,  # 'M'
     78: 35,  # 'N'
     79: 47,  # 'O'
     80: 46,  # 'P'
     81: 71,  # 'Q'
     82: 43,  # 'R'
     83: 33,  # 'S'
     84: 37,  # 'T'
     85: 57,  # 'U'
     86: 48,  # 'V'
     87: 64,  # 'W'
     88: 68,  # 'X'
     89: 55,  # 'Y'
     90: 52,  # 'Z'
     91: 253,  # '['
     92: 253,  # '\\'
     93: 253,  # ']'
     94: 253,  # '^'
     95: 253,  # '_'
     96: 253,  # '`'
     97: 2,  # 'a'
     98: 18,  # 'b'
     99: 26,  # 'c'
     100: 17,  # 'd'
     101: 1,  # 'e'
     102: 27,  # 'f'
     103: 12,  # 'g'
     104: 20,  # 'h'
     105: 9,  # 'i'
     106: 22,  # 'j'
     107: 7,  # 'k'
     108: 6,  # 'l'
     109: 13,  # 'm'
     110: 4,  # 'n'
     111: 8,  # 'o'
     112: 23,  # 'p'
     113: 67,  # 'q'
     114: 10,  # 'r'
     115: 5,  # 's'
     116: 3,  # 't'
     117: 21,  # 'u'
     118: 19,  # 'v'
     119: 65,  # 'w'
     120: 62,  # 'x'
     121: 16,  # 'y'
     122: 11,  # 'z'
     123: 253,  # '{'
     124: 253,  # '|'
     125: 253,  # '}'
     126: 253,  # '~'
     127: 253,  # '\x7f'
     128: 159,  # '\x80'
     129: 160,  # '\x81'
     130: 161,  # '\x82'
     131: 162,  # '\x83'
     132: 163,  # '\x84'
     133: 164,  # '\x85'
     134: 165,  # '\x86'
     135: 166,  # '\x87'
     136: 167,  # '\x88'
     137: 168,  # '\x89'
     138: 169,  # '\x8a'
     139: 170,  # '\x8b'
     140: 171,  # '\x8c'
     141: 172,  # '\x8d'
     142: 173,  # '\x8e'
     143: 174,  # '\x8f'
     144: 175,  # '\x90'
     145: 176,  # '\x91'
     146: 177,  # '\x92'
     147: 178,  # '\x93'
     148: 179,  # '\x94'
     149: 180,  # '\x95'
     150: 181,  # '\x96'
     151: 182,  # '\x97'
     152: 183,  # '\x98'
     153: 184,  # '\x99'
     154: 185,  # '\x9a'
     155: 186,  # '\x9b'
     156: 187,  # '\x9c'
     157: 188,  # '\x9d'
     158: 189,  # '\x9e'
     159: 190,  # '\x9f'
     160: 191,  # '\xa0'
     161: 192,  # 'Ą'
     162: 193,  # '˘'
     163: 194,  # 'Ł'
     164: 195,  # '¤'
     165: 196,  # 'Ľ'
     166: 197,  # 'Ś'
     167: 75,  # '§'
     168: 198,  # '¨'
     169: 199,  # 'Š'
     170: 200,  # 'Ş'
     171: 201,  # 'Ť'
     172: 202,  # 'Ź'
     173: 203,  # '\xad'
     174: 204,  # 'Ž'
     175: 205,  # 'Ż'
     176: 79,  # '°'
     177: 206,  # 'ą'
     178: 207,  # '˛'
     179: 208,  # 'ł'
     180: 209,  # '´'
     181: 210,  # 'ľ'
     182: 211,  # 'ś'
     183: 212,  # 'ˇ'
     184: 213,  # '¸'
     185: 214,  # 'š'
     186: 215,  # 'ş'
     187: 216,  # 'ť'
     188: 217,  # 'ź'
     189: 218,  # '˝'
     190: 219,  # 'ž'
     191: 220,  # 'ż'
     192: 221,  # 'Ŕ'
     193: 51,  # 'Á'
     194: 81,  # 'Â'
     195: 222,  # 'Ă'
     196: 78,  # 'Ä'
     197: 223,  # 'Ĺ'
     198: 224,  # 'Ć'
     199: 225,  # 'Ç'
     200: 226,  # 'Č'
     201: 44,  # 'É'
     202: 227,  # 'Ę'
     203: 228,  # 'Ë'
     204: 229,  # 'Ě'
     205: 61,  # 'Í'
     206: 230,  # 'Î'
     207: 231,  # 'Ď'
     208: 232,  # 'Đ'
     209: 233,  # 'Ń'
     210: 234,  # 'Ň'
     211: 58,  # 'Ó'
     212: 235,  # 'Ô'
     213: 66,  # 'Ő'
     214: 59,  # 'Ö'
     215: 236,  # '×'
     216: 237,  # 'Ř'
     217: 238,  # 'Ů'
     218: 60,  # 'Ú'
     219: 69,  # 'Ű'
     220: 63,  # 'Ü'
     221: 239,  # 'Ý'
     222: 240,  # 'Ţ'
     223: 241,  # 'ß'
     224: 82,  # 'ŕ'
     225: 14,  # 'á'
     226: 74,  # 'â'
     227: 242,  # 'ă'
     228: 70,  # 'ä'
     229: 80,  # 'ĺ'
     230: 243,  # 'ć'
     231: 72,  # 'ç'
     232: 244,  # 'č'
     233: 15,  # 'é'
     234: 83,  # 'ę'
     235: 77,  # 'ë'
     236: 84,  # 'ě'
     237: 30,  # 'í'
     238: 76,  # 'î'
     239: 85,  # 'ď'
     240: 245,  # 'đ'
     241: 246,  # 'ń'
     242: 247,  # 'ň'
     243: 25,  # 'ó'
     244: 73,  # 'ô'
     245: 42,  # 'ő'
     246: 24,  # 'ö'
     247: 248,  # '÷'
     248: 249,  # 'ř'
     249: 250,  # 'ů'
     250: 31,  # 'ú'
     251: 56,  # 'ű'
     252: 29,  # 'ü'
     253: 251,  # 'ý'
     254: 252,  # 'ţ'
     255: 253,  # '˙'
}

ISO_8859_2_HUNGARIAN_MODEL = SingleByteCharSetModel(charset_name='ISO-8859-2',
                                                    language='Hungarian',
                                                    char_to_order_map=ISO_8859_2_HUNGARIAN_CHAR_TO_ORDER,
                                                    language_model=HUNGARIAN_LANG_MODEL,
                                                    typical_positive_ratio=0.947368,
                                                    keep_ascii_letters=True,
                                                    alphabet='ABCDEFGHIJKLMNOPRSTUVZabcdefghijklmnoprstuvzÁÉÍÓÖÚÜáéíóöúüŐőŰű')

