/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.metadata;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.DynamicObject;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.core.CacheManager;
import com.mysql.clusterj.core.metadata.AbstractDomainFieldHandlerImpl;
import com.mysql.clusterj.core.metadata.AbstractDomainTypeHandlerImpl;
import com.mysql.clusterj.core.metadata.DomainFieldHandlerImpl;
import com.mysql.clusterj.core.metadata.IndexHandlerImpl;
import com.mysql.clusterj.core.metadata.InvocationHandlerImpl;
import com.mysql.clusterj.core.metadata.KeyValueHandlerImpl;
import com.mysql.clusterj.core.spi.DomainFieldHandler;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.spi.ValueHandlerFactory;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ResultData;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DomainTypeHandlerImpl<T>
extends AbstractDomainTypeHandlerImpl<T> {
    Class<T> cls;
    boolean dynamic = false;
    private Map<String, Method> unmatchedGetMethods = new HashMap<String, Method>();
    private Map<String, Method> unmatchedSetMethods = new HashMap<String, Method>();
    protected Class<T> proxyClass;
    Constructor<T> ctor;
    PersistenceCapable persistenceCapable;
    ValueHandlerFactory valueHandlerFactory;
    private int[] fieldNumberToColumnNumberMap;
    private int numberOfTransientFields;
    private DomainFieldHandlerImpl[] transientFieldHandlers;
    protected static final Class<?>[] invocationHandlerClassArray = new Class[]{InvocationHandler.class};
    protected ValueHandlerFactory defaultInvocationHandlerFactory = new ValueHandlerFactory(){

        public <V> ValueHandler getValueHandler(DomainTypeHandlerImpl<V> domainTypeHandlerImpl, Db db) {
            return new InvocationHandlerImpl<V>(domainTypeHandlerImpl);
        }

        public <V> ValueHandler getKeyValueHandler(DomainTypeHandlerImpl<V> domainTypeHandlerImpl, Db db, Object object) {
            Object[] objectArray = DomainTypeHandlerImpl.this.expandKeyValues(object);
            return new KeyValueHandlerImpl(objectArray);
        }

        public <V> ValueHandler getValueHandler(DomainTypeHandlerImpl<V> domainTypeHandlerImpl, Db db, ResultData resultData) {
            InvocationHandlerImpl<V> invocationHandlerImpl = new InvocationHandlerImpl<V>(domainTypeHandlerImpl);
            DomainTypeHandlerImpl.this.objectSetValues(resultData, invocationHandlerImpl);
            return invocationHandlerImpl;
        }
    };

    public DomainTypeHandlerImpl(Class<T> clazz, Dictionary dictionary) {
        this(clazz, dictionary, null);
    }

    /*
     * WARNING - void declaration
     */
    public DomainTypeHandlerImpl(Class<T> clazz, Dictionary dictionary, ValueHandlerFactory valueHandlerFactory) {
        void var12_24;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.valueHandlerFactory = valueHandlerFactory != null ? valueHandlerFactory : this.defaultInvocationHandlerFactory;
        this.cls = clazz;
        this.name = clazz.getName();
        if (DynamicObject.class.isAssignableFrom(clazz)) {
            this.dynamic = true;
            this.tableName = DomainTypeHandlerImpl.getTableNameForDynamicObject(clazz);
        } else {
            this.proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), clazz, Finalizable.class);
            this.ctor = this.getConstructorForInvocationHandler(this.proxyClass);
            this.persistenceCapable = clazz.getAnnotation(PersistenceCapable.class);
            if (this.persistenceCapable == null) {
                throw new ClusterJUserException(local.message("ERR_No_Persistence_Capable_Annotation", (Object)this.name));
            }
            this.tableName = this.persistenceCapable.table();
        }
        this.table = this.getTable(dictionary);
        if (this.table == null) {
            throw new ClusterJUserException(local.message("ERR_Get_NdbTable", (Object)this.name, (Object)this.tableName));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found Table for " + this.tableName);
        }
        this.primaryKeyColumnNames = this.table.getPrimaryKeyColumnNames();
        this.numberOfIdFields = this.primaryKeyColumnNames.length;
        this.idFieldHandlers = new DomainFieldHandlerImpl[this.numberOfIdFields];
        this.idFieldNumbers = new int[this.numberOfIdFields];
        this.partitionKeyColumnNames = this.table.getPartitionKeyColumnNames();
        this.numberOfPartitionKeyColumns = this.partitionKeyColumnNames.length;
        this.partitionKeyFieldHandlers = new DomainFieldHandlerImpl[this.numberOfPartitionKeyColumns];
        Index index = dictionary.getIndex("PRIMARY$KEY", this.tableName, "PRIMARY");
        IndexHandlerImpl indexHandlerImpl = new IndexHandlerImpl(this, dictionary, index, this.primaryKeyColumnNames);
        this.indexHandlerImpls.add(indexHandlerImpl);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String[] stringArray = this.table.getIndexNames();
        for (String string : stringArray) {
            String object6 = this.removeUniqueSuffix(string);
            object5 = dictionary.getIndex(string, this.tableName, object6);
            object4 = object5.getColumnNames();
            object3 = new IndexHandlerImpl(this, dictionary, (Index)object5, (String[])object4);
            this.indexHandlerImpls.add(object3);
        }
        if (this.dynamic) {
            object2 = new ArrayList();
            for (String i : this.table.getColumnNames()) {
                object5 = this.table.getColumn(i);
                object4 = null;
                object4 = new DomainFieldHandlerImpl(this, this.table, this.numberOfFields++, (Column)object5);
                object3 = ((AbstractDomainFieldHandlerImpl)object4).getName();
                object2.add(object3);
                this.fieldNameToNumber.put(((AbstractDomainFieldHandlerImpl)object4).getName(), ((AbstractDomainFieldHandlerImpl)object4).getFieldNumber());
                this.persistentFieldHandlers.add(object4);
                arrayList.add(object4);
                if (object5.isPrimaryKey()) continue;
                this.nonPKFieldHandlers.add(object4);
            }
            this.fieldNames = object2.toArray(new String[object2.size()]);
        } else {
            void var12_22;
            object2 = new ArrayList();
            object = clazz.getMethods();
            Object[] objectArray = object;
            int n = objectArray.length;
            boolean bl = false;
            while (var12_22 < n) {
                Object object6;
                object5 = objectArray[var12_22];
                object4 = ((Method)object5).getName();
                object3 = this.convertMethodName((String)object4);
                Class<?> clazz2 = this.getType((Method)object5);
                AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl = null;
                if (((String)object4).startsWith("get")) {
                    object6 = this.unmatchedSetMethods.get(object3);
                    if (object6 == null) {
                        this.unmatchedGetMethods.put((String)object3, (Method)object5);
                    } else if (this.getType((Method)object6).equals(clazz2)) {
                        this.unmatchedSetMethods.remove(object3);
                        abstractDomainFieldHandlerImpl = new DomainFieldHandlerImpl(this, this.table, this.numberOfFields++, (String)object3, clazz2, (Method)object5, (Method)object6);
                    } else {
                        this.unmatchedGetMethods.put((String)object3, (Method)object5);
                    }
                } else if (((String)object4).startsWith("set")) {
                    object6 = this.unmatchedGetMethods.get(object3);
                    if (object6 == null) {
                        this.unmatchedSetMethods.put((String)object3, (Method)object5);
                    } else if (this.getType((Method)object6).equals(clazz2)) {
                        this.unmatchedGetMethods.remove(object3);
                        abstractDomainFieldHandlerImpl = new DomainFieldHandlerImpl(this, this.table, this.numberOfFields++, (String)object3, clazz2, (Method)object6, (Method)object5);
                    } else {
                        this.unmatchedSetMethods.put((String)object3, (Method)object5);
                    }
                }
                if (abstractDomainFieldHandlerImpl != null) {
                    object6 = abstractDomainFieldHandlerImpl.getName();
                    object2.add(object6);
                    this.fieldNameToNumber.put(abstractDomainFieldHandlerImpl.getName(), abstractDomainFieldHandlerImpl.getFieldNumber());
                    if (((DomainFieldHandlerImpl)abstractDomainFieldHandlerImpl).isPersistent()) {
                        this.persistentFieldHandlers.add(abstractDomainFieldHandlerImpl);
                        if (!abstractDomainFieldHandlerImpl.isPrimaryKey()) {
                            this.nonPKFieldHandlers.add(abstractDomainFieldHandlerImpl);
                        }
                    }
                    if (abstractDomainFieldHandlerImpl.isPrimitive()) {
                        this.primitiveFieldHandlers.add(abstractDomainFieldHandlerImpl);
                    }
                    arrayList.add(abstractDomainFieldHandlerImpl);
                }
                ++var12_22;
            }
            this.fieldNames = object2.toArray(new String[object2.size()]);
            if (!this.unmatchedGetMethods.isEmpty() || !this.unmatchedSetMethods.isEmpty()) {
                this.setUnsupported(local.message("ERR_Unmatched_Methods", (Object)this.unmatchedGetMethods, (Object)this.unmatchedSetMethods));
            }
        }
        object2 = this.getUnsupported();
        if (object2 != null) {
            throw new ClusterJUserException(local.message("ERR_Field_Construction", (Object)this.name, (Object)((String)object2).toString()));
        }
        for (IndexHandlerImpl indexHandlerImpl2 : this.indexHandlerImpls) {
            indexHandlerImpl2.assertAllColumnsHaveFields();
        }
        if (!((IndexHandlerImpl)this.indexHandlerImpls.get(0)).isUsable()) {
            object = local.message("ERR_Primary_Field_Missing", (Object)this.name);
            logger.warn((String)object);
            throw new ClusterJUserException((String)object);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.toString());
            logger.debug("DomainTypeHandlerImpl " + this.name + "Indices " + this.indexHandlerImpls);
        }
        this.fieldNumberToColumnNumberMap = new int[this.numberOfFields];
        object = this.table.getColumnNames();
        this.fieldHandlers = arrayList.toArray(new DomainFieldHandlerImpl[this.numberOfFields]);
        int n = 0;
        ArrayList<DomainFieldHandlerImpl> arrayList2 = new ArrayList<DomainFieldHandlerImpl>();
        boolean bl = false;
        while (var12_24 < this.numberOfFields) {
            object5 = (DomainFieldHandler)arrayList.get((int)var12_24);
            object4 = object5.getColumnName();
            boolean bl2 = false;
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (!((String)object[i]).equals(object4)) continue;
                this.fieldNumberToColumnNumberMap[var12_24] = i;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.fieldNumberToColumnNumberMap[var12_24] = --n;
                arrayList2.add((DomainFieldHandlerImpl)object5);
            }
            ++var12_24;
        }
        this.numberOfTransientFields = 0 - n;
        this.transientFieldHandlers = arrayList2.toArray(new DomainFieldHandlerImpl[arrayList2.size()]);
    }

    protected static String getTableName(Class<?> clazz) {
        String string = null;
        if (DynamicObject.class.isAssignableFrom(clazz)) {
            string = DomainTypeHandlerImpl.getTableNameForDynamicObject(clazz);
        } else {
            PersistenceCapable persistenceCapable = clazz.getAnnotation(PersistenceCapable.class);
            if (persistenceCapable != null) {
                string = persistenceCapable.table();
            }
        }
        return string;
    }

    protected static <O extends DynamicObject> String getTableNameForDynamicObject(Class<O> clazz) {
        PersistenceCapable persistenceCapable = clazz.getAnnotation(PersistenceCapable.class);
        String string = null;
        try {
            DynamicObject dynamicObject = (DynamicObject)clazz.newInstance();
            string = dynamicObject.table();
            if (string == null && persistenceCapable != null) {
                string = persistenceCapable.table();
            }
        }
        catch (InstantiationException instantiationException) {
            throw new ClusterJUserException(local.message("ERR_Dynamic_Object_Instantiation", (Object)clazz.getName()), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ClusterJUserException(local.message("ERR_Dynamic_Object_Illegal_Access", (Object)clazz.getName()), illegalAccessException);
        }
        if (string == null) {
            throw new ClusterJUserException(local.message("ERR_Dynamic_Object_Null_Table_Name", (Object)clazz.getName()));
        }
        return string;
    }

    @Override
    public boolean isSupportedType() {
        return true;
    }

    @Override
    public ValueHandler getValueHandler(Object object) throws IllegalArgumentException {
        ValueHandler valueHandler = null;
        if (object instanceof ValueHandler) {
            valueHandler = (ValueHandler)object;
        } else if (object instanceof DynamicObject) {
            DynamicObject dynamicObject = (DynamicObject)object;
            valueHandler = (ValueHandler)dynamicObject.delegate();
        } else {
            valueHandler = (ValueHandler)Proxy.getInvocationHandler(object);
        }
        if (valueHandler.wasReleased()) {
            throw new ClusterJUserException(local.message("ERR_Cannot_Access_Object_After_Release"));
        }
        return valueHandler;
    }

    @Override
    public void objectMarkModified(ValueHandler valueHandler, String string) {
        int n = (Integer)this.fieldNameToNumber.get(string);
        valueHandler.markModified(n);
    }

    @Override
    public Class<T> getProxyClass() {
        return this.proxyClass;
    }

    public Class<T> getDomainClass() {
        return this.cls;
    }

    public void operationSetValues(Object object, Operation operation) {
        ValueHandler valueHandler = this.getValueHandler(object);
        for (DomainFieldHandler domainFieldHandler : this.persistentFieldHandlers) {
            domainFieldHandler.operationSetValue(valueHandler, operation);
        }
    }

    @Override
    public void objectSetKeys(Object object, Object object2) {
        ValueHandler valueHandler = this.getValueHandler(object2);
        this.objectSetKeys(object, valueHandler);
    }

    public void objectSetKeys(Object object, ValueHandler valueHandler) {
        int n = this.idFieldHandlers.length;
        if (n == 1) {
            this.idFieldHandlers[0].objectSetKeyValue(object, valueHandler);
        } else if (object instanceof Object[]) {
            if (logger.isDetailEnabled()) {
                logger.detail(object.toString());
            }
            for (int i = 0; i < this.idFieldHandlers.length; ++i) {
                this.idFieldHandlers[i].objectSetKeyValue(((Object[])object)[i], valueHandler);
            }
        } else {
            throw new ClusterJUserException(local.message("ERR_Composite_Key_Parameter"));
        }
    }

    @Override
    public void objectResetModified(ValueHandler valueHandler) {
        valueHandler.resetModified();
    }

    @Override
    public void objectSetCacheManager(CacheManager cacheManager, Object object) {
        this.getValueHandler(object).setCacheManager(cacheManager);
    }

    @Override
    public T newInstance(Db db) {
        ValueHandler valueHandler = this.valueHandlerFactory.getValueHandler(this, db);
        return this.newInstance(valueHandler);
    }

    @Override
    public T newInstance(ResultData resultData, Db db) {
        ValueHandler valueHandler = this.valueHandlerFactory.getValueHandler(this, db, resultData);
        T t = this.newInstance(valueHandler);
        return t;
    }

    @Override
    public T newInstance(ValueHandler valueHandler) {
        try {
            T t;
            if (this.dynamic) {
                t = this.cls.newInstance();
                ((DynamicObject)t).delegate(valueHandler);
            } else {
                t = this.ctor.newInstance(valueHandler);
                valueHandler.setProxy(t);
            }
            return t;
        }
        catch (InstantiationException instantiationException) {
            throw new ClusterJException(local.message("ERR_Create_Instance", (Object)this.cls.getName()), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ClusterJException(local.message("ERR_Create_Instance", (Object)this.cls.getName()), illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClusterJException(local.message("ERR_Create_Instance", (Object)this.cls.getName()), illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ClusterJException(local.message("ERR_Create_Instance", (Object)this.cls.getName()), invocationTargetException);
        }
        catch (SecurityException securityException) {
            throw new ClusterJException(local.message("ERR_Create_Instance", (Object)this.cls.getName()), securityException);
        }
    }

    public void initializePrimitiveFields(ValueHandler valueHandler) {
        for (DomainFieldHandler domainFieldHandler : this.primitiveFieldHandlers) {
            ((AbstractDomainFieldHandlerImpl)domainFieldHandler).objectSetDefaultValue(valueHandler);
        }
        valueHandler.resetModified();
    }

    private String convertMethodName(String string) {
        String string2 = string.substring(3, 4).toLowerCase();
        String string3 = string.substring(4);
        return string2 + string3;
    }

    @Override
    public T getInstance(ValueHandler valueHandler) {
        Object object = valueHandler.getProxy();
        return (T)object;
    }

    private Class<?> getType(Method method) {
        Class<?> clazz = null;
        if (method.getName().startsWith("get")) {
            clazz = method.getReturnType();
        } else if (method.getName().startsWith("set")) {
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                throw new ClusterJUserException(local.message("ERR_Set_Method_Parameters", (Object)method.getName(), (Object)classArray.length));
            }
            clazz = classArray[0];
        } else {
            throw new ClusterJFatalInternalException(local.message("ERR_Method_Name", (Object)method.getName()));
        }
        if (clazz == null) {
            throw new ClusterJUserException(local.message("ERR_Unmatched_Method" + method.getName()));
        }
        return clazz;
    }

    protected Constructor<T> getConstructorForInvocationHandler(Class<T> clazz) {
        try {
            return clazz.getConstructor(invocationHandlerClassArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ClusterJFatalInternalException(local.message("ERR_Get_Constructor", (Object)clazz), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new ClusterJFatalInternalException(local.message("ERR_Get_Constructor", (Object)clazz), securityException);
        }
    }

    @Override
    public ValueHandler createKeyValueHandler(Object object, Db db) {
        if (object == null) {
            throw new ClusterJUserException(local.message("ERR_Key_Must_Not_Be_Null", (Object)this.getName(), (Object)"unknown"));
        }
        if (this.numberOfIdFields == 1) {
            Class<?> clazz = this.idFieldHandlers[0].getType();
            DomainFieldHandler domainFieldHandler = this.idFieldHandlers[0];
            this.checkKeyType(domainFieldHandler.getName(), clazz, object);
        } else {
            if (!object.getClass().isArray()) {
                throw new ClusterJUserException(local.message("ERR_Key_Must_Be_An_Object_Array", this.numberOfIdFields));
            }
            for (int i = 0; i < this.numberOfIdFields; ++i) {
                DomainFieldHandler domainFieldHandler = this.idFieldHandlers[i];
                Object object2 = ((Object[])object)[i];
                Class<?> clazz = domainFieldHandler.getType();
                this.checkKeyType(domainFieldHandler.getName(), clazz, object2);
                if (object2 != null || !domainFieldHandler.isPartitionKey()) continue;
                throw new ClusterJUserException(local.message("ERR_Key_Must_Not_Be_Null", (Object)this.getName(), (Object)this.fieldHandlers[i].getName()));
            }
        }
        return this.valueHandlerFactory.getKeyValueHandler(this, db, object);
    }

    public void checkKeyType(String string, Class<?> clazz, Object object) throws ClusterJUserException {
        if (object == null) {
            return;
        }
        Class<?> clazz2 = object.getClass();
        if (clazz.isAssignableFrom(clazz2) || clazz == Integer.TYPE && clazz2 == Integer.class || clazz == Integer.class && clazz2 == Integer.TYPE || clazz == Long.class && clazz2 == Long.TYPE || clazz == Long.TYPE && clazz2 == Long.class || clazz == Short.TYPE && clazz2 == Short.class || clazz == Short.class && clazz2 == Short.TYPE || clazz == Byte.TYPE && clazz2 == Byte.class || clazz == Byte.class && clazz2 == Byte.TYPE) {
            return;
        }
        throw new ClusterJUserException(local.message("ERR_Incorrect_Key_Type", string, clazz2.getName(), clazz.getName()));
    }

    public Object[] expandKeyValues(Object object) {
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        Object[] objectArray2 = new Object[this.numberOfFields];
        int n = 0;
        int[] nArray = this.idFieldNumbers;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            Integer n3 = nArray[i];
            objectArray2[n3.intValue()] = objectArray[n++];
        }
        return objectArray2;
    }

    @Override
    public Class<?> getOidClass() {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public ColumnMetadata[] columnMetadata() {
        ColumnMetadata[] columnMetadataArray = new ColumnMetadata[this.numberOfFields];
        return this.persistentFieldHandlers.toArray(columnMetadataArray);
    }

    public int getNumberOfTransientFields() {
        return this.numberOfTransientFields;
    }

    public int[] getFieldNumberToColumnNumberMap() {
        return this.fieldNumberToColumnNumberMap;
    }

    public Object[] newTransientValues() {
        Object[] objectArray = new Object[this.numberOfTransientFields];
        int n = 0;
        for (DomainFieldHandlerImpl domainFieldHandlerImpl : this.transientFieldHandlers) {
            Object object = domainFieldHandlerImpl.getDefaultValue();
            objectArray[n++] = object;
        }
        return objectArray;
    }

    protected static interface Finalizable {
        public void finalize() throws Throwable;
    }
}

