/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.Customer;
import testsuite.clusterj.model.Order;
import testsuite.clusterj.model.OrderLine;

public class MultithreadedTest
extends AbstractClusterJModelTest {
    private int numberOfThreads = 50;
    private int numberOfNewCustomersPerThread = 5;
    private int numberOfNewOrdersPerNewCustomer = 5;
    private int numberOfUpdatesPerThread = 2;
    private int maximumOrderLinesPerOrder = 5;
    private int maximumQuantityPerOrderLine = 100;
    private int maximumUnitPrice = 100;
    private int numberOfInitialCustomers;
    private int nextCustomerId = this.numberOfInitialCustomers = 10;
    private int nextOrderId = 0;
    private int nextOrderLineId = 0;
    private int numberOfUpdatedOrderLines = 0;
    private int numberOfDeletedOrders = 0;
    private int numberOfDeletedOrderLines = 0;
    private ThreadGroup threadGroup;
    List<Customer> customers = new ArrayList<Customer>();
    List<Order> orders = new ArrayList<Order>();
    Set<OrderLine> orderlines = new TreeSet<OrderLine>(new Comparator<OrderLine>(){

        @Override
        public int compare(OrderLine orderLine, OrderLine orderLine2) {
            return orderLine.getId() - orderLine2.getId();
        }
    });

    @Override
    protected boolean getDebug() {
        return false;
    }

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(Customer.class);
        this.session.deletePersistentAll(Order.class);
        this.session.deletePersistentAll(OrderLine.class);
        this.tx.commit();
        this.createCustomerInstances(this.nextCustomerId);
        this.tx.begin();
        this.session.makePersistentAll(this.customers);
        this.tx.commit();
        this.addTearDownClasses(Customer.class);
        this.addTearDownClasses(Order.class);
        this.addTearDownClasses(OrderLine.class);
    }

    private void createCustomerInstances(int n) {
        for (int i = 0; i < n; ++i) {
            Customer customer = (Customer)this.session.newInstance(Customer.class);
            customer.setId(i);
            customer.setName("Customer number " + i + " (initial)");
            customer.setMagic(i * 100);
            this.customers.add(customer);
        }
    }

    public void test() {
        Query query;
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        this.threadGroup = new ThreadGroup("Stuff");
        AbstractClusterJTest.MyUncaughtExceptionHandler myUncaughtExceptionHandler = new AbstractClusterJTest.MyUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(myUncaughtExceptionHandler);
        for (int i = 0; i < this.numberOfThreads; ++i) {
            Thread object2 = new Thread(this.threadGroup, new StuffToDo());
            arrayList.add(object2);
            object2.start();
        }
        for (Thread thread : arrayList) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted while joining threads.");
            }
        }
        for (Throwable throwable : myUncaughtExceptionHandler.getUncaughtExceptions()) {
            this.error("Caught exception: " + throwable.getClass().getName() + ": " + throwable.getMessage());
            query = throwable.getStackTrace();
            for (StackTraceElement stackTraceElement : query) {
                this.error("        at " + stackTraceElement.toString());
            }
        }
        if (this.getDebug()) {
            System.out.println("Number of threads: " + this.numberOfThreads + "; number of new customers per thread: " + this.numberOfNewCustomersPerThread + "; number of orders per new customer: " + this.numberOfNewOrdersPerNewCustomer);
            System.out.println("Created " + this.nextCustomerId + " customers; " + this.nextOrderId + " orders; and " + this.nextOrderLineId + " order lines.");
            System.out.println("Deleted " + this.numberOfDeletedOrders + " orders; and " + this.numberOfDeletedOrderLines + " order lines.");
            System.out.println("Updated " + this.numberOfUpdatedOrderLines + " order lines.");
        }
        this.errorIfNotEqual("Failed to create customers.", this.numberOfThreads * this.numberOfNewCustomersPerThread + this.numberOfInitialCustomers, this.nextCustomerId);
        this.errorIfNotEqual("Failed to create orders. ", this.numberOfThreads * this.numberOfNewCustomersPerThread * this.numberOfNewOrdersPerNewCustomer, this.nextOrderId);
        Iterator<Object> iterator = this.sessionFactory.getSession();
        QueryDomainType queryDomainType = iterator.getQueryBuilder().createQueryDefinition(OrderLine.class);
        queryDomainType.where(queryDomainType.get("orderId").equal(queryDomainType.param("orderId")));
        query = iterator.createQuery((QueryDefinition)queryDomainType);
        for (Order order : this.orders) {
            int n = order.getId();
            if (this.getDebug()) {
                System.out.println("Read order " + n + " total " + order.getValue());
            }
            order = (Order)iterator.find(Order.class, n);
            double d = order.getValue();
            double d2 = 0.0;
            ArrayList<OrderLine> arrayList2 = new ArrayList<OrderLine>();
            for (OrderLine orderLine : this.getOrderLines((Session)iterator, (Query<OrderLine>)query, n)) {
                arrayList2.add(orderLine);
                if (this.getDebug()) {
                    System.out.println("order " + orderLine.getOrderId() + " orderline " + orderLine.getId() + " value " + orderLine.getTotalValue());
                }
                d2 += orderLine.getTotalValue();
            }
            this.errorIfNotEqual("For order " + n + ", order value does not equal sum of order line values. orderLines: " + MultithreadedTest.dump(arrayList2), d, d2);
        }
        this.failOnError();
    }

    private void createCustomer(Session session, String string) {
        Customer customer = (Customer)session.newInstance(Customer.class);
        int n = this.getNextCustomerId();
        customer.setId(n);
        customer.setName("Customer number " + n + " thread " + string);
        customer.setMagic(n * 10000);
        session.makePersistent((Object)customer);
        this.addCustomer(customer);
    }

    public void createOrder(Session session, Random random) {
        session.currentTransaction().begin();
        int n = this.getNextOrderId();
        Order order = (Order)session.newInstance(Order.class);
        order.setId(n);
        int n2 = random.nextInt(this.nextCustomerId);
        order.setCustomerId(n2);
        order.setDescription("Order " + n + " for Customer " + n2);
        Double d = 0.0;
        int n3 = random.nextInt(this.maximumOrderLinesPerOrder);
        if (this.getDebug()) {
            System.out.println("Create Order " + n + " with numberOfOrderLines: " + n3);
        }
        for (int i = 0; i < n3; ++i) {
            int n4 = this.getNextOrderLineId();
            OrderLine orderLine = (OrderLine)session.newInstance(OrderLine.class);
            orderLine.setId(n4);
            orderLine.setOrderId(n);
            long l = random.nextInt(this.maximumQuantityPerOrderLine);
            orderLine.setQuantity(l);
            float f = (float)random.nextInt(this.maximumUnitPrice) / 4.0f;
            orderLine.setUnitPrice(f);
            double d2 = f * (float)l;
            d = d + d2;
            if (this.getDebug()) {
                System.out.println("Create orderline " + n4 + " for Order " + n + " quantity " + l + " price " + f + " order line value " + d2 + " order value " + d);
            }
            orderLine.setTotalValue(d2);
            this.addOrderLine(orderLine);
            session.persist((Object)orderLine);
        }
        order.setValue(d);
        session.persist((Object)order);
        session.currentTransaction().commit();
        this.addOrder(order);
    }

    public void updateOrder(Session session, Random random, Query<OrderLine> query) {
        session.currentTransaction().begin();
        Order order = null;
        order = this.removeOrderFromOrdersCollection(random);
        if (order == null) {
            return;
        }
        int n = order.getId();
        order = (Order)session.find(Order.class, (Object)n);
        List<OrderLine> list = this.getOrderLines(session, query, n);
        int n2 = list.size();
        OrderLine orderLine = null;
        double d = order.getValue();
        if (n2 > 0) {
            int n3 = random.nextInt(n2);
            orderLine = list.get(n3);
            d -= orderLine.getTotalValue();
            this.updateOrderLine(orderLine, random);
            d += orderLine.getTotalValue();
        }
        order.setValue(d);
        session.updatePersistent(orderLine);
        session.updatePersistent((Object)order);
        session.currentTransaction().commit();
        this.addOrder(order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOrderLine(OrderLine orderLine, Random random) {
        int n = orderLine.getOrderId();
        int n2 = orderLine.getId();
        double d = orderLine.getTotalValue();
        long l = random.nextInt(this.maximumQuantityPerOrderLine);
        orderLine.setQuantity(l);
        float f = (float)random.nextInt(this.maximumUnitPrice) / 4.0f;
        orderLine.setUnitPrice(f);
        double d2 = f * (float)l;
        orderLine.setTotalValue(d2);
        if (this.getDebug()) {
            System.out.println("For order " + n + " orderline " + n2 + " previous order line value " + d + " new order line value " + d2);
        }
        Set<OrderLine> set = this.orderlines;
        synchronized (set) {
            ++this.numberOfUpdatedOrderLines;
        }
    }

    public void deleteOrder(Session session, Random random, Query<OrderLine> query) {
        session.currentTransaction().begin();
        Order order = null;
        order = this.removeOrderFromOrdersCollection(random);
        if (order == null) {
            return;
        }
        int n = order.getId();
        List<OrderLine> list = this.getOrderLines(session, query, n);
        this.removeOrderLinesFromOrderLinesCollection(list);
        session.deletePersistentAll(list);
        session.deletePersistent((Object)order);
        session.currentTransaction().commit();
    }

    private List<OrderLine> getOrderLines(Session session, Query<OrderLine> query, int n) {
        query.setParameter("orderId", (Object)n);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Order removeOrderFromOrdersCollection(Random random) {
        List<Order> list = this.orders;
        synchronized (list) {
            int n = this.orders.size();
            if (n < 10) {
                return null;
            }
            int n2 = random.nextInt(n);
            ++this.numberOfDeletedOrders;
            return this.orders.remove(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOrderLinesFromOrderLinesCollection(Collection<OrderLine> collection) {
        Set<OrderLine> set = this.orderlines;
        synchronized (set) {
            this.orderlines.removeAll(collection);
            this.numberOfDeletedOrderLines += collection.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCustomer(Customer customer) {
        List<Customer> list = this.customers;
        synchronized (list) {
            this.customers.add(customer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextCustomerId() {
        List<Customer> list = this.customers;
        synchronized (list) {
            int n = this.nextCustomerId++;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextOrderId() {
        List<Order> list = this.orders;
        synchronized (list) {
            int n = this.nextOrderId++;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextOrderLineId() {
        Set<OrderLine> set = this.orderlines;
        synchronized (set) {
            int n = this.nextOrderLineId++;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrder(Order order) {
        List<Order> list = this.orders;
        synchronized (list) {
            this.orders.add(order);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrderLine(OrderLine orderLine) {
        Set<OrderLine> set = this.orderlines;
        synchronized (set) {
            this.orderlines.add(orderLine);
        }
    }

    class StuffToDo
    implements Runnable {
        private Random myRandom = new Random();

        StuffToDo() {
        }

        @Override
        public void run() {
            int n;
            Session session = MultithreadedTest.this.sessionFactory.getSession();
            QueryDomainType queryDomainType = session.getQueryBuilder().createQueryDefinition(OrderLine.class);
            queryDomainType.where(queryDomainType.get("orderId").equal(queryDomainType.param("orderId")));
            Query query = session.createQuery((QueryDefinition)queryDomainType);
            for (n = 0; n < MultithreadedTest.this.numberOfNewCustomersPerThread; ++n) {
                MultithreadedTest.this.createCustomer(session, String.valueOf(Thread.currentThread().getId()));
                for (int i = 0; i < MultithreadedTest.this.numberOfNewOrdersPerNewCustomer; ++i) {
                    MultithreadedTest.this.createOrder(session, this.myRandom);
                }
            }
            for (n = 0; n < MultithreadedTest.this.numberOfUpdatesPerThread; ++n) {
                MultithreadedTest.this.updateOrder(session, this.myRandom, (Query<OrderLine>)query);
            }
            MultithreadedTest.this.deleteOrder(session, this.myRandom, (Query<OrderLine>)query);
        }
    }
}

