%feature("docstring") OT::SkellamFactory
"Skellam factory.

Notes
-----
The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle \\Hat{\\lambda_1} & = \\frac{1}{2}(\\Hat{\\sigma}_x + \\Hat{x}_n) \\\\
      \\displaystyle \\Hat{\\lambda_2} & = \\frac{1}{2}(\\Hat{\\sigma}_x - \\Hat{x}_n)
    \\end{eqnarray*}

See also
--------
DistributionFactory, Skellam"

// ---------------------------------------------------------------------

%feature("docstring") OT::SkellamFactory::buildAsSkellam
"Estimate the distribution as native distribution.

**Available usages**:

    buildAsSkellam()

    buildAsSkellam(*sample*)

    buildAsSkellam(*param*)

Parameters
----------
sample : 2-d sequence of float
    Data.
param : sequence of float
    The parameters of the :class:`~openturns.Skellam`.

Returns
-------
dist : :class:`~openturns.Skellam`
    The estimated distribution as a Skellam.
    
    In the first usage, the default Skellam distribution is built."
